/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class ScrollableDesktop
extends JDesktopPane {
    transient ComponentListener resizer;

    public Dimension getPreferredSize() {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < jInternalFrameArray.length) {
            int n4 = jInternalFrameArray[n3].getX() + jInternalFrameArray[n3].getWidth();
            int n5 = jInternalFrameArray[n3].getY() + jInternalFrameArray[n3].getHeight();
            if (n4 > n) {
                n = n4;
            }
            if (n5 > n2) {
                n2 = n5;
            }
            ++n3;
        }
        return new Dimension(n, n2);
    }

    public void add(Component component, Object object) {
        super.add(component, object);
        System.out.println("add!");
        if (this.resizer == null) {
            this.initResizer();
        }
        component.addComponentListener(this.resizer);
    }

    public void remove(Component component) {
        component.removeComponentListener(this.resizer);
        super.remove(component);
        this.validateGrandparent();
    }

    private void validateGrandparent() {
        Container container;
        Container container2 = this.getParent();
        if (container2 != null && (container = container2.getParent()) != null) {
            container.validate();
        }
    }

    private void initResizer() {
        this.resizer = new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                ScrollableDesktop.this.validateGrandparent();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                this.componentResized(componentEvent);
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        int n = 0;
        while (n < jInternalFrameArray.length) {
            jInternalFrameArray[n].removeComponentListener(this.resizer);
            ++n;
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initResizer();
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        System.out.println("read frames: " + jInternalFrameArray.length);
        int n = 0;
        while (n < jInternalFrameArray.length) {
            jInternalFrameArray[n].addComponentListener(this.resizer);
            ++n;
        }
        jInternalFrameArray[0].addComponentListener(this.resizer);
    }
}

