/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui;

import com.kb.owl.Form;
import com.kb.owl.OWL;
import com.kb.owl.OWLParser;
import com.kb.owl.Symbol;
import com.kb.owl.SyntaxError;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class LinkedSentence
implements Serializable {
    String onelineText;
    String indentText;
    boolean indented;
    boolean useHtml;
    Form sentence;
    String sentenceString;
    ArrayList stringStructure;
    boolean error = false;
    String text;

    public LinkedSentence() {
        this("");
    }

    public LinkedSentence(String string) {
        this(string, false);
    }

    public LinkedSentence(String string, boolean bl) {
        this(string, bl, true);
    }

    public LinkedSentence(String string, boolean bl, boolean bl2) {
        this.setIndented(bl);
        this.setHTML(bl2);
        this.setSentence(string);
    }

    public LinkedSentence(Form form) {
        this(form, false);
    }

    public LinkedSentence(Form form, boolean bl) {
        this(form, bl, true);
    }

    public LinkedSentence(Form form, boolean bl, boolean bl2) {
        this.setIndented(bl);
        this.setHTML(bl2);
        this.setSentence(form);
    }

    public String getText() {
        return this.text;
    }

    public void setSentence(String string) {
        this.sentenceString = string;
        this.sentence = null;
        OWL oWL = null;
        OWLParser oWLParser = new OWLParser(new StringReader(string));
        try {
            oWL = oWLParser.readExpr();
            if (oWL == OWLParser.eof) {
                this.setEmptyString();
            } else if (oWL instanceof Form) {
                this.sentence = (Form)oWL;
            } else {
                this.setNotAFormError(oWL);
            }
            if (this.sentence != null) {
                this.setSentence0();
            }
        }
        catch (IOException iOException) {
            this.setIOError(iOException);
        }
        catch (SyntaxError syntaxError) {
            this.setParseError(syntaxError);
        }
    }

    public void setSentence(Form form) {
        this.sentence = form;
        this.setSentence0();
    }

    private void setSentence0() {
        if (this.sentence == null) {
            this.setEmptyString();
        } else {
            this.stringStructure = (ArrayList)this.toStringStructure(this.sentence);
            this.onelineText = null;
            this.indentText = null;
            this.error = false;
            this.refreshText();
        }
    }

    public Form getSentence() {
        return this.sentence;
    }

    public boolean isIndented() {
        return this.indented;
    }

    public boolean isHTML() {
        return this.useHtml;
    }

    public void setIndented(boolean bl) {
        if (bl == this.indented) {
            return;
        }
        this.indented = bl;
        if (this.sentence == null) {
            this.setEmptyString();
        } else {
            this.refreshText();
        }
    }

    public void setHTML(boolean bl) {
        if (bl == this.useHtml) {
            return;
        }
        this.useHtml = bl;
        if (this.sentence == null) {
            this.setEmptyString();
        } else {
            this.refreshText();
        }
    }

    private void setEmptyString() {
        this.setText(this.useHtml ? "<font color=red>No sentence given to display!</font>" : "No sentence given to display!");
        this.error = true;
    }

    private void setNotAFormError(OWL oWL) {
        String string = LinkedSentence.verbatim(oWL.toString(), this.useHtml) + (this.useHtml ? " <font color=red>seems to parse as a \"" : " seems to parse as a \"") + oWL.getClass().getName() + (this.useHtml ? "\" instead of a \"com.kb.owl.Form\".</font>" : "\" instead of a \"com.kb.owl.Form\".");
        this.setText(string);
        this.error = true;
    }

    private void setParseError(SyntaxError syntaxError) {
        String string = syntaxError == null ? "??" : syntaxError.getMessage();
        StringBuffer stringBuffer = new StringBuffer(this.useHtml ? "<font color=red>Invalid sentence (" : "Invalid sentence (");
        stringBuffer.append(string);
        stringBuffer.append(this.useHtml ? "):</font> " : "): ");
        stringBuffer.append(LinkedSentence.verbatim(this.sentenceString, this.useHtml));
        this.setText(stringBuffer.toString());
        this.error = true;
    }

    private void setIOError(IOException iOException) {
        String string = iOException == null ? "??" : iOException.getMessage();
        StringBuffer stringBuffer = new StringBuffer(this.useHtml ? "<font color=red>IO error (" : "IO error (");
        stringBuffer.append(string);
        stringBuffer.append(this.useHtml ? "):</font> " : "): ");
        stringBuffer.append(LinkedSentence.verbatim(this.sentenceString, this.useHtml));
        this.setText(stringBuffer.toString());
        this.error = true;
    }

    private void setText(String string) {
        this.text = string;
    }

    private void refreshText() {
        if (this.error) {
            return;
        }
        this.text = this.indented ? this.indent() : this.oneline();
        System.out.println("setting text to:");
        System.out.println(this.text);
    }

    private String oneline() {
        if (this.onelineText == null) {
            this.onelineText = this.oneline0(this.stringStructure).toString();
        }
        return this.onelineText;
    }

    private StringBuffer oneline0(Object object) {
        StringBuffer stringBuffer;
        if (object instanceof String) {
            stringBuffer = new StringBuffer((String)object);
        } else {
            ArrayList arrayList = (ArrayList)object;
            stringBuffer = new StringBuffer("(");
            int n = 0;
            while (n < arrayList.size()) {
                if (n > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append((Object)this.oneline0(arrayList.get(n)));
                ++n;
            }
            stringBuffer.append(')');
        }
        return stringBuffer;
    }

    private String indent() {
        if (this.indentText == null) {
            this.indentText = this.indent0(this.stringStructure, "").toString();
        }
        return this.indentText;
    }

    private StringBuffer indent0(Object object, String string) {
        StringBuffer stringBuffer;
        if (object instanceof String) {
            stringBuffer = new StringBuffer((String)object);
        } else {
            ArrayList arrayList = (ArrayList)object;
            if (!this.needsIndenting(arrayList)) {
                stringBuffer = this.oneline0(arrayList);
            } else {
                string = string + (this.useHtml ? "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" : "     ");
                stringBuffer = new StringBuffer("(");
                int n = 0;
                while (n < arrayList.size()) {
                    if (n > 0) {
                        stringBuffer.append(this.useHtml ? "<br>\n" : "\n");
                        stringBuffer.append(string);
                    }
                    stringBuffer.append((Object)this.indent0(arrayList.get(n), string));
                    ++n;
                }
                stringBuffer.append(')');
            }
        }
        return stringBuffer;
    }

    private boolean needsIndenting(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            ArrayList arrayList2;
            Object e = arrayList.get(n2);
            if (e instanceof ArrayList && (arrayList2 = (ArrayList)e).size() > 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Object toStringStructure(OWL oWL) {
        Object object = null;
        if (oWL instanceof Form) {
            Form form = (Form)oWL;
            ArrayList<Object> arrayList = new ArrayList<Object>(form.length());
            int n = 0;
            while (n < form.length()) {
                arrayList.add(this.toStringStructure(form.arg(n - 1)));
                ++n;
            }
            object = arrayList;
        } else {
            object = oWL instanceof Symbol ? this.markUp((Symbol)oWL) : LinkedSentence.verbatim(oWL.toString(), this.useHtml);
        }
        return object;
    }

    private String markUp(Symbol symbol) {
        if (!this.useHtml) {
            return symbol.toString();
        }
        if (symbol.isInt() || symbol.isReal()) {
            return symbol.toString();
        }
        String string = symbol.toString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<a href=");
        if (string.indexOf(62) != -1) {
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append('>');
        stringBuffer.append(string);
        stringBuffer.append("</a>");
        return stringBuffer.toString();
    }

    public static String verbatim(String string, boolean bl) {
        if (!bl) {
            return LinkedSentence.verbatimNoHTML(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>&\n", true);
        try {
            while (true) {
                String string2;
                String string3 = (string2 = stringTokenizer.nextToken()).equals("<") ? "&lt;" : (string2.equals(">") ? "&gt;" : (string2.equals("&") ? "&amp;" : (string2.equals("\n") ? "<br>" : string2)));
                stringBuffer.append(string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return stringBuffer.toString();
        }
    }

    private static String verbatimNoHTML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        try {
            while (true) {
                String string2;
                String string3 = (string2 = stringTokenizer.nextToken()).equals("\n") ? "\\n" : string2;
                stringBuffer.append(string3);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return stringBuffer.toString();
        }
    }

    protected void explore1() {
        System.out.println("LinkedSentence.explore1():");
        if (this.sentence == null) {
            System.out.println("  null sentence");
        } else {
            this.explore1(this.sentence, "");
        }
    }

    private void explore1(OWL oWL, String string) {
        if (oWL instanceof Form) {
            Form form = (Form)oWL;
            string = string + "  ";
            OWL oWL2 = form.car();
            System.out.print(string);
            System.out.print("functor: ");
            System.out.print(oWL2.getClass().toString());
            System.out.print(": ");
            System.out.println(oWL2.toString());
            if (oWL2 instanceof Form) {
                this.explore1(oWL2, string);
            }
            int n = form.arity();
            int n2 = 0;
            while (n2 < n) {
                this.explore1(form.arg(n2), string);
                ++n2;
            }
        } else if (oWL instanceof Symbol) {
            System.out.print(string);
            if (oWL.isInt()) {
                System.out.print("int");
            } else if (oWL.isFloat()) {
                System.out.print("float");
            } else {
                System.out.print("symbol");
            }
            System.out.print(": ");
            System.out.println(oWL.toString());
        } else {
            System.out.print(string);
            System.out.print(oWL.getClass().toString());
            System.out.print(": ");
            System.out.println(oWL.toString());
        }
    }
}

