/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class AutoCompleteField
extends JTextField {
    boolean moveUp = true;
    boolean addOnEnter = true;
    Stack strings;
    transient ArrayList keysPressed;

    public AutoCompleteField() {
        this(new Stack());
    }

    public AutoCompleteField(Stack stack) {
        this.strings = stack;
        this.keysPressed = new ArrayList(10);
        this.addWiring();
    }

    private void addWiring() {
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                Integer n;
                int n2 = keyEvent.getKeyCode();
                char c = keyEvent.getKeyChar();
                if (n2 != 38 && n2 != 40 && c != '\uffff' && !Character.isISOControl(c) && AutoCompleteField.this.keysPressed.indexOf(n = new Integer(n2)) == -1) {
                    AutoCompleteField.this.keysPressed.add(n);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (AutoCompleteField.this.getSelectionEnd() != AutoCompleteField.this.getText().length()) {
                    return;
                }
                int n = keyEvent.getKeyCode();
                char c = keyEvent.getKeyChar();
                if (n == 38 || n == 40) {
                    if (keyEvent.getModifiers() != 0) {
                        return;
                    }
                    String string = AutoCompleteField.this.getText();
                    int n2 = AutoCompleteField.this.getSelectionStart();
                    String string2 = string.substring(0, n2);
                    String string3 = n == 38 ? AutoCompleteField.this.previousMatch(string2, string) : AutoCompleteField.this.nextMatch(string2, string);
                    AutoCompleteField.this.setAndMark(string3, string2);
                } else if (c != '\uffff' && !Character.isISOControl(c)) {
                    ((AbstractCollection)AutoCompleteField.this.keysPressed).remove(new Integer(n));
                    if (AutoCompleteField.this.keysPressed.size() == 0) {
                        AutoCompleteField.this.processChar(c, n);
                    }
                }
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AutoCompleteField.this.addOnEnter) {
                    AutoCompleteField.this.add(AutoCompleteField.this.getText());
                }
            }
        });
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.strings);
        objectOutputStream.writeBoolean(this.moveUp);
        objectOutputStream.writeBoolean(this.addOnEnter);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.strings = (Stack)objectInputStream.readObject();
        this.moveUp = objectInputStream.readBoolean();
        this.addOnEnter = objectInputStream.readBoolean();
        this.keysPressed = new ArrayList();
        this.addWiring();
    }

    public boolean isAddOnEnterSet() {
        return this.addOnEnter;
    }

    public void setAddOnEnter(boolean bl) {
        this.addOnEnter = bl;
    }

    public boolean isMoveUpSet() {
        return this.moveUp;
    }

    public void setMoveUp(boolean bl) {
        this.moveUp = bl;
    }

    public void setCompletionList(Stack stack) {
        this.strings = stack;
    }

    public Stack getCompletionList() {
        return this.strings;
    }

    public String[] getCompletionListCopy() {
        String[] stringArray = new String[this.strings.size()];
        this.strings.toArray(stringArray);
        return stringArray;
    }

    public String getString(int n) {
        return (String)this.strings.get(n);
    }

    public void add(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.strings.remove(string);
        this.strings.push(string);
    }

    public void remove(String string) {
        this.strings.remove(string);
    }

    public void pop() {
        this.strings.pop();
    }

    public String firstMatch(String string) {
        int n = this.strings.size() - 1;
        boolean bl = false;
        String string2 = null;
        while (n >= 0 && !bl) {
            string2 = (String)this.strings.elementAt(n);
            bl = string2.startsWith(string);
            --n;
        }
        return bl ? string2 : null;
    }

    public String nextMatch(String string, String string2) {
        return this.anotherMatch(string, string2, 1);
    }

    public String previousMatch(String string, String string2) {
        return this.anotherMatch(string, string2, -1);
    }

    private String anotherMatch(String string, String string2, int n) {
        if (!string2.startsWith(string)) {
            return this.firstMatch(string);
        }
        Stack stack = this.strings;
        synchronized (stack) {
            int n2 = this.strings.indexOf(string2);
            if (n2 == -1) {
                String string3 = this.firstMatch(string);
                return string3;
            }
            int n3 = this.strings.size() - 1;
            boolean bl = false;
            String string4 = null;
            while (!bl) {
                if ((n2 -= n) < 0) {
                    n2 = n3;
                }
                if (n2 > n3) {
                    n2 = 0;
                }
                string4 = (String)this.strings.elementAt(n2);
                bl = string4.startsWith(string);
            }
            String string5 = string4;
            return string5;
        }
    }

    protected void processChar(char c, int n) {
        String string = this.getText();
        String string2 = this.firstMatch(string);
        if (string2 != null) {
            this.setAndMark(string2, string);
        }
    }

    protected void setAndMark(String string, String string2) {
        this.setText(string);
        this.setCaretPosition(string.length());
        this.moveCaretPosition(string2.length());
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("AutoCompleteField demo");
        AutoCompleteField autoCompleteField = new AutoCompleteField();
        jFrame.getContentPane().add("North", autoCompleteField);
        jFrame.setDefaultCloseOperation(3);
        ((Component)jFrame).setSize(200, 50);
        jFrame.show();
    }
}

