/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui;

import com.ow.gui.OWIconManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AnimatedIcon
extends JPanel {
    public static final int defaultInterval = 100;
    private static final int maxHueChanges = 60;
    private static final Dimension defaultPrefSize = new Dimension(32, 32);
    private static final Dimension minSize = new Dimension(0, 0);
    ArrayList icons = null;
    ImageIcon stoppedIcon = null;
    ImageIcon currentIcon = null;
    int curIdx = 0;
    int interval = 100;
    boolean stopped = true;
    boolean iconsLoaded = false;
    Thread animator;
    Dimension seqPrefSize = defaultPrefSize;
    Dimension prefSize = defaultPrefSize;

    public AnimatedIcon() {
        this(100);
    }

    public AnimatedIcon(int n) {
        this.interval = n;
    }

    public AnimatedIcon(String[] stringArray) throws FileNotFoundException {
        this(stringArray, 100);
    }

    public AnimatedIcon(ImageIcon[] imageIconArray) {
        this(imageIconArray, 100);
    }

    public AnimatedIcon(String[] stringArray, int n) throws FileNotFoundException {
        this.interval = n;
        this.setIcons(stringArray);
    }

    public AnimatedIcon(ImageIcon[] imageIconArray, int n) {
        this.interval = n;
        this.setIcons(imageIconArray);
    }

    public void setIcons(String[] stringArray) throws FileNotFoundException {
        if (stringArray == null) {
            this.clearIcons();
            return;
        }
        ImageIcon[] imageIconArray = new ImageIcon[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            imageIconArray[n] = OWIconManager.getIcon(stringArray[n]);
            ++n;
        }
        this.setIcons(imageIconArray);
    }

    public void setIcons(ImageIcon[] imageIconArray) {
        if (imageIconArray == null) {
            this.clearIcons();
            return;
        }
        this.icons = new ArrayList(imageIconArray.length);
        int n = 0;
        while (n < imageIconArray.length) {
            this.addIcon(imageIconArray[n]);
            ++n;
        }
    }

    public void clearIcons() {
        this.icons = null;
        this.updatePrefSize();
    }

    public void addIcon(String string) throws FileNotFoundException {
        if (string == null) {
            throw new IllegalArgumentException("icon name must be non-null");
        }
        this.addIcon(OWIconManager.getIcon(string));
    }

    public void addIcon(ImageIcon imageIcon) {
        if (imageIcon == null) {
            throw new IllegalArgumentException("icon must be non-null");
        }
        if (this.icons == null) {
            this.seqPrefSize = minSize;
            this.icons = new ArrayList();
        }
        this.icons.add(imageIcon);
        this.updatePrefSize(imageIcon);
    }

    public void setInterval(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("milliseconds must be greater than zero (" + n + ")");
        }
        this.interval = n;
    }

    public void setStoppedIcon(int n) {
        this.setStoppedIcon((ImageIcon)this.icons.get(n));
    }

    public void setStoppedIcon(ImageIcon imageIcon) {
        this.stoppedIcon = imageIcon;
        this.updatePrefSize();
        if (this.stopped) {
            this.currentIcon = this.stoppedIcon;
            if (!this.stopped || this.stoppedIcon != null) {
                this.repaint();
            }
        }
    }

    public void start() {
        if (this.animator != null) {
            this.stop();
        }
        this.stopped = false;
        if (this.stoppedIcon != null) {
            this.curIdx = 0;
        }
        this.animator = new Thread(){

            public void run() {
                AnimatedIcon.this.animate();
            }
        };
        this.animator.start();
    }

    public void stop() {
        this.stopped = true;
        this.animator = null;
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.prefSize;
    }

    public Dimension getMaximumSize() {
        return this.iconsLoaded ? this.prefSize : super.getMaximumSize();
    }

    private void animate() {
        while (!this.stopped) {
            ++this.curIdx;
            if (this.icons == null) {
                if (this.curIdx == 60) {
                    this.curIdx = 0;
                }
            } else {
                ArrayList arrayList = this.icons;
                synchronized (arrayList) {
                    if (this.curIdx == this.icons.size()) {
                        this.curIdx = 0;
                    }
                    this.currentIcon = (ImageIcon)this.icons.get(this.curIdx);
                }
            }
            if (!this.stopped || this.stoppedIcon != null) {
                this.repaint();
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.stoppedIcon != null) {
            this.currentIcon = this.stoppedIcon;
        }
        if (!this.stopped || this.stoppedIcon != null) {
            this.repaint();
        }
    }

    private void showCurrentIcon(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.currentIcon == null) {
            graphics.setColor(Color.getHSBColor((float)this.curIdx / 60.0f, 1.0f, 0.5f));
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.currentIcon.paintIcon(this, graphics, 0, 0);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.showCurrentIcon(graphics);
    }

    private void debugPrintIndex() {
        System.out.print(" " + this.curIdx);
        System.out.print("/");
        if (this.icons == null) {
            System.out.print("60h");
        } else {
            System.out.print(this.icons.size() + "i");
        }
    }

    private void updatePrefSize(ImageIcon imageIcon) {
        this.seqPrefSize = new Dimension(Math.max(this.seqPrefSize.width, imageIcon.getIconWidth()), Math.max(this.seqPrefSize.height, imageIcon.getIconHeight()));
        this.updatePrefSize();
    }

    private void updatePrefSize() {
        this.prefSize = this.stoppedIcon == null ? (this.icons == null ? defaultPrefSize : this.seqPrefSize) : (this.icons == null ? new Dimension(this.stoppedIcon.getIconWidth(), this.stoppedIcon.getIconHeight()) : new Dimension(Math.max(this.seqPrefSize.width, this.stoppedIcon.getIconWidth()), Math.max(this.seqPrefSize.height, this.stoppedIcon.getIconHeight())));
        this.iconsLoaded = this.icons != null || this.stoppedIcon != null;
    }

    public static void main(String[] stringArray) {
        final AnimatedIcon animatedIcon = new AnimatedIcon();
        final Runnable runnable = new Runnable(){

            public void run() {
                animatedIcon.start();
            }
        };
        final Runnable runnable2 = new Runnable(){

            public void run() {
                animatedIcon.stop();
            }
        };
        final JCheckBox jCheckBox = new JCheckBox("animate");
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(jCheckBox.isSelected() ? runnable : runnable2);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", animatedIcon);
        jPanel.add("South", jCheckBox);
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(jPanel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.show();
    }
}

