/*
 * Decompiled with CFR 0.152.
 */
package com.ow.gui;

import com.ow.gui.SentenceView;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public abstract class AmbidexLinkListener
implements HyperlinkListener,
MouseListener {
    JEditorPane editorPane;
    URL currentURL;
    String currentDesc;
    boolean overLink;

    public AmbidexLinkListener(JEditorPane jEditorPane) {
        this.editorPane = jEditorPane;
        jEditorPane.addMouseListener(this);
        jEditorPane.addHyperlinkListener(this);
    }

    public abstract void hyperlinkEntered(HyperlinkEvent var1);

    public abstract void hyperlinkExited(HyperlinkEvent var1);

    public abstract void hyperlinkLeftClicked(HyperlinkEvent var1, int var2, int var3);

    public abstract void hyperlinkRightClicked(HyperlinkEvent var1, int var2, int var3);

    public abstract void paneLeftClicked(MouseEvent var1);

    public abstract void paneRightClicked(MouseEvent var1);

    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl;
        if (mouseEvent.getClickCount() > 1) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            bl = true;
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            bl = false;
        } else {
            return;
        }
        if (this.overLink) {
            HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(mouseEvent.getSource(), HyperlinkEvent.EventType.ACTIVATED, this.currentURL, this.currentDesc);
            if (bl) {
                this.hyperlinkLeftClicked(hyperlinkEvent, mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.hyperlinkRightClicked(hyperlinkEvent, mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (bl) {
            this.paneLeftClicked(mouseEvent);
        } else {
            this.paneRightClicked(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public final void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
        if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        if (eventType == HyperlinkEvent.EventType.ENTERED) {
            this.currentURL = hyperlinkEvent.getURL();
            this.currentDesc = hyperlinkEvent.getDescription();
            this.overLink = true;
            this.hyperlinkEntered(hyperlinkEvent);
        }
        if (eventType == HyperlinkEvent.EventType.EXITED) {
            this.currentURL = null;
            this.currentDesc = null;
            this.overLink = false;
            this.hyperlinkExited(hyperlinkEvent);
        }
    }

    public static void main(String[] stringArray) {
        SentenceView.main(stringArray);
    }
}

