/*
 * Decompiled with CFR 0.152.
 */
package com.kb.xsb;

import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.owl.QuotedString;
import com.kb.owl.SVar;
import com.kb.owl.Symbol;
import com.kb.owl.SyntaxError;
import com.kb.owl.Time;
import com.kb.owl.TypedVarSpec;
import com.kb.owl.VarSpec;
import com.kb.xsb.List;
import com.kb.xsb.Structure;
import com.kb.xsb.Variable;

public class OWL2XSB {
    private static final String IVAR = "ivar";
    private static final String SVAR = "svar";
    private static final String QSTR = "qstr";
    private static final String ELST = "_elist";

    public static OWL makeOWL(Object object) {
        if (object instanceof OWL) {
            return (OWL)object;
        }
        if (object instanceof String) {
            return new Symbol((String)object);
        }
        if (object instanceof Integer) {
            return new Symbol("" + (Integer)object);
        }
        if (object instanceof Float) {
            return new Symbol("" + ((Float)object).floatValue());
        }
        if (object instanceof List) {
            List list = (List)object;
            OWL[] oWLArray = new OWL[list.length()];
            int n = 0;
            while (n < oWLArray.length) {
                oWLArray[n] = OWL2XSB.makeOWL(list.car);
                list = list.cdr instanceof String && list.cdr.equals("[]") ? null : (List)list.cdr;
                ++n;
            }
            return new Form(oWLArray);
        }
        if (object instanceof Structure) {
            Structure structure = (Structure)object;
            OWL[] oWLArray = new OWL[structure.arity() + 1];
            oWLArray[0] = OWL2XSB.makeOWL(structure.functor());
            int n = 0;
            while (n < structure.arity()) {
                oWLArray[n + 1] = OWL2XSB.makeOWL(structure.arg(n));
                ++n;
            }
            return new Form(oWLArray);
        }
        if (object instanceof Variable) {
            return new IVar(OWL2XSB.convert_Variable_name(object.toString()));
        }
        throw new ClassCastException("Cannot make a term from " + object);
    }

    public static OWL convertParseStructure(Object object) {
        if (object instanceof OWL) {
            return (OWL)object;
        }
        if (object instanceof String) {
            if (object.equals("[]")) {
                return new Form("listof");
            }
            if (object.equals("_kbeq")) {
                return new Symbol("=");
            }
            if (object.equals("_kbunify")) {
                return new Symbol("=");
            }
            if (object.equals("_kbneq")) {
                return new Symbol("/=");
            }
            return new Symbol((String)object);
        }
        if (object instanceof List) {
            List list = (List)object;
            OWL[] oWLArray = new OWL[list.length()];
            int n = 0;
            while (n < oWLArray.length) {
                oWLArray[n] = OWL2XSB.convertParseStructure(list.car);
                list = "[]".equals(list.cdr) ? null : (List)list.cdr;
                ++n;
            }
            return new Form("listof", oWLArray);
        }
        if (object instanceof Structure) {
            Structure structure = (Structure)object;
            Object object2 = structure.functor();
            if (object2.equals("exists") || object2.equals("forall")) {
                VarSpec varSpec = OWL2XSB.convert_to_VarSpec(structure.arg(0));
                OWL oWL = OWL2XSB.convertParseStructure(structure.arg(1));
                return new Form(new Symbol((String)object2), (OWL)varSpec, oWL);
            }
            if (object2.equals(IVAR)) {
                if (structure.arg(0).equals("?")) {
                    return new IVar();
                }
                return new IVar((String)structure.arg(0));
            }
            if (object2.equals(SVAR)) {
                return new SVar((String)structure.arg(0));
            }
            if (object2.equals(QSTR)) {
                return new QuotedString((String)structure.arg(0));
            }
            if (object2.equals(ELST)) {
                return new Form("listof");
            }
            if (object2.equals("_kbtp")) {
                return Time.xsb2owl(structure);
            }
            if (object2.equals("_kbti")) {
                return Time.xsb2owl(structure);
            }
            OWL[] oWLArray = new OWL[structure.arity() + 1];
            oWLArray[0] = OWL2XSB.convertParseStructure(object2);
            int n = 0;
            while (n < structure.arity()) {
                oWLArray[n + 1] = OWL2XSB.convertParseStructure(structure.arg(n));
                ++n;
            }
            return new Form(oWLArray);
        }
        if (object instanceof Integer) {
            return new Symbol("" + (Integer)object);
        }
        if (object instanceof Float) {
            return new Symbol("" + ((Float)object).floatValue());
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            OWL[] oWLArray = new OWL[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                oWLArray[n] = OWL2XSB.convertParseStructure(objectArray[n]);
                ++n;
            }
            return new Form("listof", oWLArray);
        }
        if (object instanceof Variable) {
            String string = OWL2XSB.convert_Variable_name(object.toString());
            return new IVar(string);
        }
        throw new ClassCastException("Cannot make a term from " + object.getClass().getName() + " " + object);
    }

    private static VarSpec convert_to_VarSpec(Object object) {
        if (!(object instanceof List)) {
            throw new Error("Must have a com.kb.xsb.List for a VarSpec: " + object + ", " + object.getClass());
        }
        Object[] objectArray = List.toArray((List)object);
        OWL[] oWLArray = new OWL[objectArray.length];
        int n = 0;
        while (n < oWLArray.length) {
            if (!(objectArray[n] instanceof Structure)) {
                throw new Error("Unrecognized parse-structure element in variable specification: " + objectArray[n] + ", " + objectArray[n].getClass());
            }
            Structure structure = (Structure)objectArray[n];
            Object object2 = structure.functor();
            if (object2.equals(",")) {
                OWL oWL = OWL2XSB.convertParseStructure(structure.arg(0));
                if (!(oWL instanceof IVar)) {
                    throw new Error("Expected an IVar for a variable: " + oWL + ", " + oWL.getClass());
                }
                OWL oWL2 = OWL2XSB.convertParseStructure(structure.arg(1));
                oWLArray[n] = new TypedVarSpec((IVar)oWL, oWL2);
            } else if (object2.equals(IVAR)) {
                oWLArray[n] = new IVar(OWL2XSB.convert_Variable_name(structure.arg(0).toString()));
            } else {
                throw new Error("Unrecognized parse-structure element in variable specification: " + objectArray[n] + ", " + objectArray[n].getClass());
            }
            ++n;
        }
        return new VarSpec(oWLArray);
    }

    private static String convert_Variable_name(String string) {
        if (string.charAt(0) == '_') {
            string = string.length() == 0 ? "?" : "?" + string.substring(1);
        } else if (!string.startsWith("?")) {
            string = "?" + string;
        }
        return string;
    }

    public static Form make(Object[] objectArray) {
        OWL[] oWLArray = new OWL[objectArray.length];
        int n = 0;
        while (n < oWLArray.length) {
            oWLArray[n] = OWL2XSB.makeOWL(objectArray[n]);
            ++n;
        }
        return new Form(oWLArray);
    }

    public static Form make(Object object) {
        return new Form(OWL2XSB.makeOWL(object));
    }

    public static Form make(Object object, Object object2) {
        return new Form(OWL2XSB.makeOWL(object), OWL2XSB.makeOWL(object2));
    }

    public static Form make(Object object, Object object2, Object object3) {
        return new Form(OWL2XSB.makeOWL(object), OWL2XSB.makeOWL(object2), OWL2XSB.makeOWL(object3));
    }

    public static Form make(Object object, Object object2, Object object3, Object object4) {
        return new Form(OWL2XSB.makeOWL(object), OWL2XSB.makeOWL(object2), OWL2XSB.makeOWL(object3), OWL2XSB.makeOWL(object4));
    }

    public static Form make(Object object, Object object2, Object object3, Object object4, Object object5) {
        return new Form(OWL2XSB.makeOWL(object), OWL2XSB.makeOWL(object2), OWL2XSB.makeOWL(object3), OWL2XSB.makeOWL(object4), OWL2XSB.makeOWL(object5));
    }

    public static Object toXSB(VarSpec varSpec) {
        Object[] objectArray = new Object[varSpec.length()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = OWL2XSB.toXSB(varSpec.arg(n));
            ++n;
        }
        return OWL2XSB.toList(objectArray);
    }

    public static Object toList(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return "[]";
        }
        List list = new List(objectArray[objectArray.length - 1], "[]");
        int n = objectArray.length - 2;
        while (n >= 0) {
            list = new List(objectArray[n], list);
            --n;
        }
        return list;
    }

    public static Object toXSB(Form form) {
        try {
            if (form.named("RootCtx.Date")) {
                return Time.owl2xsb(form);
            }
            return OWL2XSB.toStructure(form);
        }
        catch (SyntaxError syntaxError) {
            throw new RuntimeException(syntaxError.toString());
        }
    }

    public static Object toXSB(OWL oWL) {
        if (oWL instanceof Form) {
            return OWL2XSB.toXSB((Form)oWL);
        }
        if (oWL instanceof VarSpec) {
            return OWL2XSB.toXSB((VarSpec)oWL);
        }
        if (oWL instanceof TypedVarSpec) {
            return OWL2XSB.toXSB((TypedVarSpec)oWL);
        }
        if (oWL instanceof Symbol) {
            return OWL2XSB.toXSB((Symbol)oWL);
        }
        if (oWL instanceof IVar) {
            return OWL2XSB.toXSB((IVar)oWL);
        }
        if (oWL instanceof SVar) {
            return OWL2XSB.toXSB((SVar)oWL);
        }
        if (oWL instanceof QuotedString) {
            return OWL2XSB.toXSB((QuotedString)oWL);
        }
        throw new ClassCastException("Cannot make a term from " + oWL);
    }

    public static Structure toStructure(Form form) {
        Object[] objectArray;
        if (form.arity() == 0 && form.functor() instanceof Symbol && ("listof".equals(objectArray = form.functor().name()) || "RootCtx.listof".equals(objectArray))) {
            return new Structure((Object)ELST, (Object)objectArray);
        }
        objectArray = new Object[form.arity()];
        int n = 0;
        while (n < objectArray.length) {
            try {
                objectArray[n] = OWL2XSB.toXSB(form.arg(n));
            }
            catch (NullPointerException nullPointerException) {
                throw new NullPointerException(form.toString());
            }
            ++n;
        }
        return new Structure(OWL2XSB.toXSB(form.functor()), objectArray);
    }

    public static Object toXSB(TypedVarSpec typedVarSpec) {
        Object object = OWL2XSB.toXSB(typedVarSpec.arg(0));
        Object object2 = OWL2XSB.toXSB(typedVarSpec.arg(1));
        return new Structure(",", object, object2);
    }

    public static Object toXSB(Symbol symbol) {
        if (symbol.isInt()) {
            return new Integer(symbol.intValue());
        }
        if (symbol.isReal()) {
            return new Float(symbol.realValue());
        }
        return symbol.name();
    }

    public static Object toXSB(QuotedString quotedString) {
        return new Structure((Object)QSTR, quotedString.text());
    }

    public static Object toXSB(IVar iVar) {
        if (iVar.isAnonymous()) {
            return new Structure((Object)IVAR, "?");
        }
        return new Structure((Object)IVAR, iVar.name());
    }

    public static Object toXSB(SVar sVar) {
        return new Structure((Object)SVAR, sVar.name());
    }
}

