/*
 * Decompiled with CFR 0.152.
 */
package com.kb.util.io;

import com.kb.util.io.MiscIOUtils;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.util.zip.GZIPInputStream;

public class MultiOIS
extends InputStream {
    protected boolean is_zipd;
    protected File the_file;
    protected FileInputStream the_fis;
    protected long tot_cnt = 0L;
    protected long tot_max;
    protected ObjectInputStream cur_ois = null;
    protected long cur_max = 0L;
    protected long cur_cnt = 0L;

    public MultiOIS(File file) throws FileNotFoundException, EOFException, IOException {
        this(file, false);
    }

    public MultiOIS(File file, boolean bl) throws FileNotFoundException, EOFException, IOException {
        this.is_zipd = bl;
        this.the_fis = new FileInputStream(file);
        this.tot_max = file.length();
        this.the_file = file;
        this.openNextOIS();
    }

    public Object readObject() throws IOException, ClassNotFoundException, EOFException {
        Object object = null;
        try {
            object = this.cur_ois.readObject();
        }
        catch (EOFException eOFException) {
            this.openNextOIS();
            object = this.cur_ois.readObject();
        }
        catch (StreamCorruptedException streamCorruptedException) {
            if (this.read() == -1) {
                this.openNextOIS();
                object = this.cur_ois.readObject();
            }
            throw streamCorruptedException;
        }
        return object;
    }

    public int read() throws IOException {
        if (this.cur_cnt == this.cur_max) {
            return -1;
        }
        ++this.cur_cnt;
        return this.the_fis.read();
    }

    protected void openNextOIS() throws IOException, EOFException {
        long l = this.cur_max - this.cur_cnt;
        int n = 1;
        while ((long)n <= l) {
            this.the_fis.read();
            ++n;
        }
        this.tot_cnt += this.cur_max;
        if (this.tot_cnt == this.tot_max) {
            throw new EOFException("reached end of the file of streams");
        }
        this.cur_max = MiscIOUtils.getLong(this.the_fis);
        this.tot_cnt += 8L;
        this.cur_cnt = 0L;
        InputStream inputStream = this;
        if (this.is_zipd) {
            inputStream = new GZIPInputStream(this);
        }
        this.cur_ois = new ObjectInputStream(inputStream);
    }

    protected void finalize() {
        try {
            super.close();
        }
        catch (Exception exception) {
            throw new Error("Exception closing filter: " + exception);
        }
    }
}

