/*
 * Decompiled with CFR 0.152.
 */
package com.kb.util.io;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class MiscIOUtils {
    public static final LineNumberReader openLNR(File file) {
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            return new LineNumberReader(bufferedReader);
        }
        catch (Exception exception) {
            throw new Error("Exception opening file: " + file + "\n" + exception);
        }
    }

    public static final void close(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            throw new Error("Exception closing in stream: " + exception);
        }
    }

    public static final void close(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            throw new Error("Exception closing out stream: " + exception);
        }
    }

    public static final void close(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (Exception exception) {
            throw new Error("Exception in closing reader: " + exception);
        }
    }

    public static final void close(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.flush();
            writer.close();
        }
        catch (Exception exception) {
            throw new Error("Exception in closing writer: " + exception);
        }
    }

    public static final ObjectOutputStream openW(File file, boolean bl, boolean bl2) {
        ObjectOutputStream objectOutputStream = null;
        try {
            FileOutputStream fileOutputStream;
            OutputStream outputStream = fileOutputStream = new FileOutputStream(file.toString(), bl);
            if (bl2) {
                outputStream = new GZIPOutputStream(fileOutputStream);
            }
            objectOutputStream = new ObjectOutputStream(outputStream);
        }
        catch (Exception exception) {
            throw new Error("Exception open file: " + file + "\n" + exception);
        }
        return objectOutputStream;
    }

    public static final ObjectInputStream openR(File file, boolean bl) {
        ObjectInputStream objectInputStream = null;
        try {
            FileInputStream fileInputStream;
            InputStream inputStream = fileInputStream = new FileInputStream(file.toString());
            if (bl) {
                inputStream = new GZIPInputStream(fileInputStream);
            }
            objectInputStream = new ObjectInputStream(inputStream);
        }
        catch (Exception exception) {
            throw new Error("Exception open file: " + file + "\n" + exception);
        }
        return objectInputStream;
    }

    public static final BufferedOutputStream openWBuf(File file, boolean bl) {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file.toString(), bl);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        }
        catch (Exception exception) {
            throw new Error("Exception open file: " + file + "\n" + exception);
        }
        return bufferedOutputStream;
    }

    public static final PrintWriter openPW(File file) {
        return MiscIOUtils.openPW(file, true);
    }

    public static final PrintWriter openPW(File file, boolean bl) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(file)), bl);
        }
        catch (Exception exception) {
            throw new Error("Exception creating PrintWriter: " + file + "\n" + exception);
        }
        return printWriter;
    }

    public static final BufferedInputStream openRBuf(File file) {
        BufferedInputStream bufferedInputStream = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file.toString());
            bufferedInputStream = new BufferedInputStream(fileInputStream);
        }
        catch (Exception exception) {
            throw new Error("Exception open file: " + file + "\n" + exception);
        }
        return bufferedInputStream;
    }

    public static final void appendTo(File file, File file2) throws IOException {
        if (!file.exists() || file.length() == 0L) {
            return;
        }
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedInputStream = MiscIOUtils.openRBuf(file);
            bufferedOutputStream = MiscIOUtils.openWBuf(file2, file2.exists());
            int n = -1;
            while ((n = bufferedInputStream.read()) != -1) {
                bufferedOutputStream.write(n);
            }
            bufferedOutputStream.flush();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            MiscIOUtils.close(bufferedOutputStream);
            MiscIOUtils.close(bufferedInputStream);
            throw throwable;
        }
        MiscIOUtils.close(bufferedOutputStream);
        MiscIOUtils.close(bufferedInputStream);
    }

    public static final void replaceWith(File file, File file2) {
        try {
            if (file.exists()) {
                file.delete();
            }
            if (!file2.renameTo(file)) {
                throw new Error("rename failed: " + file2 + ", to " + file);
            }
        }
        catch (Exception exception) {
            throw new Error("Exception: " + exception);
        }
    }

    public static final long getLong(InputStream inputStream) throws IOException {
        return ((long)MiscIOUtils.getInt(inputStream) << 32) + ((long)MiscIOUtils.getInt(inputStream) & 0xFFFFFFFFL);
    }

    public static final int getInt(InputStream inputStream) throws IOException, EOFException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public static final void writeLong(long l, OutputStream outputStream) throws IOException {
        outputStream.write((int)(l >>> 56) & 0xFF);
        outputStream.write((int)(l >>> 48) & 0xFF);
        outputStream.write((int)(l >>> 40) & 0xFF);
        outputStream.write((int)(l >>> 32) & 0xFF);
        outputStream.write((int)(l >>> 24) & 0xFF);
        outputStream.write((int)(l >>> 16) & 0xFF);
        outputStream.write((int)(l >>> 8) & 0xFF);
        outputStream.write((int)(l >>> 0) & 0xFF);
        outputStream.flush();
    }

    public static final void writeLong(long l, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file.toString(), file.exists());
        MiscIOUtils.writeLong(l, fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public static final File selectFile(boolean bl, String string) {
        FileDialog fileDialog = new FileDialog(new Frame(), "Print List", bl ? 1 : 0);
        if (string != null && !string.equals("")) {
            fileDialog.setDirectory(string);
        }
        ((Component)fileDialog).setVisible(true);
        String string2 = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        if (string3 == null || string2 == null) {
            return null;
        }
        return new File(string2, string3);
    }

    public static final String stripExt(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static final boolean copy(File file, File file2) throws IOException {
        block5: {
            if (file.isFile()) {
                BufferedInputStream bufferedInputStream = null;
                BufferedOutputStream bufferedOutputStream = null;
                try {
                    int n;
                    bufferedInputStream = MiscIOUtils.openRBuf(file);
                    bufferedOutputStream = MiscIOUtils.openWBuf(file2, false);
                    byte[] byArray = new byte[4096];
                    while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                        ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                    }
                    ((OutputStream)bufferedOutputStream).flush();
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    MiscIOUtils.close(bufferedInputStream);
                    MiscIOUtils.close(bufferedOutputStream);
                    throw throwable;
                }
                MiscIOUtils.close(bufferedInputStream);
                MiscIOUtils.close(bufferedOutputStream);
                {
                    break block5;
                }
            }
            file2.mkdirs();
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                File file3 = new File(file2, fileArray[n].getName());
                MiscIOUtils.copy(fileArray[n], file3);
                ++n;
            }
        }
        return true;
    }

    public static final boolean delete(File file) {
        return !file.exists() || MiscIOUtils.delete_file(file);
    }

    private static boolean delete_file(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (!MiscIOUtils.delete_file(fileArray[n])) {
                    return false;
                }
                ++n;
            }
        }
        return file.delete();
    }
}

