/*
 * Decompiled with CFR 0.152.
 */
package com.kb.util.io;

import com.kb.trans.TransError;
import com.kb.util.io.MiscIOUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;

public class LogMsg
implements Serializable {
    private String odir_str;
    private transient PrintWriter the_pw;
    private File log_file;

    public LogMsg(String string) {
        this.openLog(string);
    }

    public void logMsg(String string) {
        if (this.the_pw == null) {
            throw new TransError("Message log not opened.");
        }
        this.the_pw.print(string);
        this.the_pw.print('\n');
    }

    public void openLog(String string) {
        this.odir_str = string;
        this.log_file = new File(this.odir_str, "log.out");
        this.the_pw = MiscIOUtils.openPW(this.log_file, true);
    }

    public void closeLog() {
        this.flushLog();
        MiscIOUtils.close(this.the_pw);
    }

    public void flushLog() {
        if (this.the_pw != null) {
            this.the_pw.flush();
        }
    }

    public void warn(String string) {
        String string2 = "### WARNING: " + string;
        System.err.println(string2);
        this.logMsg(string2);
        this.flushLog();
    }

    public String getOutputDir() {
        return this.odir_str;
    }
}

