/*
 * Decompiled with CFR 0.152.
 */
package com.kb.util.gui;

import com.kb.util.gui.JListMouseListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionListener;

public class UJList
extends JComponent
implements MouseListener {
    private JList list;
    private JScrollPane scroll;
    private int nDismissDelay = 10000;
    protected DefaultListModel the_dlm = null;
    protected DefaultListSelectionModel the_dsm = null;
    protected int SINGLE_SELECTION = 1;
    protected int SINGLE_INTERVAL_SELECTION = 2;
    protected int MULTIPLE_INTERVAL_SELECTION = 3;

    public UJList() {
        this(new DefaultListModel());
    }

    public UJList(Object[] objectArray) {
        this(UJList.toListModel(objectArray));
    }

    public UJList(Vector vector) {
        this(vector.toArray());
    }

    public UJList(ListModel listModel) {
        this.the_dlm = (DefaultListModel)listModel;
        this.list = new JListMouseListener(this.the_dlm){

            public String getToolTipText(MouseEvent mouseEvent) {
                return UJList.this.list_getToolTipText(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                UJList.this.this_mouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                UJList.this.this_mouseExited(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        };
        this.list.setToolTipText("");
        this.the_dsm = new DefaultListSelectionModel();
        this.setSelectionModel(this.the_dsm);
        this.scroll = new JScrollPane(this.list);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroll, "Center");
        this.setVisible(true);
    }

    public UJList(int n, boolean bl) {
        this();
        this.setVisibleRowCount(n);
        this.setMultipleMode(bl);
    }

    protected static ListModel toListModel(Object[] objectArray) {
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        int n = 0;
        while (n < objectArray.length) {
            defaultListModel.addElement(objectArray[n]);
            ++n;
        }
        return defaultListModel;
    }

    protected String list_getToolTipText(MouseEvent mouseEvent) {
        int n = this.list.locationToIndex(mouseEvent.getPoint());
        if (n == -1) {
            return null;
        }
        Object e = this.list.getModel().getElementAt(n);
        Component component = this.list.getCellRenderer().getListCellRendererComponent(this.list, e, n, true, true);
        if (e == null) {
            return null;
        }
        if (e.toString().equals("")) {
            return null;
        }
        if (component.getPreferredSize().width < this.scroll.getSize().width) {
            return null;
        }
        return e.toString();
    }

    public void this_mouseEntered(MouseEvent mouseEvent) {
        this.mouseEntered(mouseEvent);
    }

    public void this_mouseExited(MouseEvent mouseEvent) {
        this.mouseExited(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.nDismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        ToolTipManager.sharedInstance().setDismissDelay(this.nDismissDelay);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void clearList() {
        this.the_dlm.clear();
    }

    public int getItemCount() {
        return this.the_dlm.size();
    }

    public void add(Object object) {
        this.add(object, this.the_dlm.size());
    }

    public void add(Object object, int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("index less than 0");
        }
        if (n >= this.the_dlm.size()) {
            this.the_dlm.addElement(object);
        } else {
            this.the_dlm.add(n, object);
        }
    }

    public void addSelection(int n) {
        this.the_dsm.addSelectionInterval(n, n);
    }

    public void ensureCapacity(int n) {
        this.the_dlm.ensureCapacity(n);
    }

    public Object get(int n) {
        return this.the_dlm.get(n);
    }

    public void delete(int n) {
        this.the_dlm.remove(n);
    }

    public void delete_rows(int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            this.delete(n3);
            ++n3;
        }
    }

    public void delete(Object object) {
        int n = this.indexOf(object);
        if (n != -1) {
            this.delete(n);
        }
    }

    public void replace(Object object, int n) {
        this.the_dlm.set(n, object);
    }

    public boolean containsObj(Object object) {
        return this.indexOf(object) != -1;
    }

    public int indexOf(Object object) {
        return this.the_dlm.indexOf(object);
    }

    public boolean isEmpty() {
        return this.the_dlm.isEmpty();
    }

    public Enumeration elements() {
        return this.the_dlm.elements();
    }

    public void setMultipleMode(boolean bl) {
        if (bl) {
            this.setSelectionMode(2);
        } else {
            this.setSelectionMode(0);
        }
    }

    public void deselect(int n) {
        this.the_dsm.removeIndexInterval(n, n);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.list.addListSelectionListener(listSelectionListener);
    }

    public void addSelectionInterval(int n, int n2) {
        this.list.addSelectionInterval(n, n2);
    }

    public void clearSelection() {
        this.list.clearSelection();
    }

    public void ensureIndexIsVisible(int n) {
        this.list.ensureIndexIsVisible(n);
    }

    public int getAnchorSelectionIndex() {
        return this.list.getAnchorSelectionIndex();
    }

    public Rectangle getCellBounds(int n, int n2) {
        return this.list.getCellBounds(n, n2);
    }

    public int getFirstVisibleIndex() {
        return this.list.getFirstVisibleIndex();
    }

    public int getFixedCellHeight() {
        return this.list.getFixedCellHeight();
    }

    public int getFixedCellWidth() {
        return this.list.getFixedCellWidth();
    }

    public int getLastVisibleIndex() {
        return this.list.getLastVisibleIndex();
    }

    public int getLeadSelectionIndex() {
        return this.list.getLeadSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.list.getMaxSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.list.getMinSelectionIndex();
    }

    public ListModel getModel() {
        return this.list.getModel();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public int[] getSelectedIndices() {
        return this.list.getSelectedIndices();
    }

    public Object getSelectedValue() {
        return this.list.getSelectedValue();
    }

    public Object[] getSelectedValues() {
        return this.list.getSelectedValues();
    }

    public int getSelectionMode() {
        return this.list.getSelectionMode();
    }

    public ListSelectionModel getSelectionModel() {
        return this.list.getSelectionModel();
    }

    public int getVisibleRowCount() {
        return this.list.getVisibleRowCount();
    }

    public Point indexToLocation(int n) {
        return this.list.indexToLocation(n);
    }

    public boolean isSelectedIndex(int n) {
        return this.list.isSelectedIndex(n);
    }

    public boolean isSelectionEmpty() {
        return this.list.isSelectionEmpty();
    }

    public int locationToIndex(Point point) {
        return this.list.locationToIndex(point);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.list.removeListSelectionListener(listSelectionListener);
    }

    public void removeSelectionInterval(int n, int n2) {
        this.list.removeSelectionInterval(n, n2);
    }

    public void setFixedCellHeight(int n) {
        this.list.setFixedCellHeight(n);
    }

    public void setFixedCellWidth(int n) {
        this.list.setFixedCellWidth(n);
    }

    public void setListData(Object[] objectArray) {
        this.list.setListData(objectArray);
    }

    public void setListData(Vector vector) {
        this.list.setListData(vector);
    }

    public void setModel(ListModel listModel) {
        this.list.setModel(listModel);
    }

    public void setSelectedIndex(int n) {
        this.list.setSelectedIndex(n);
    }

    public void setSelectedIndices(int[] nArray) {
        this.list.setSelectedIndices(nArray);
    }

    public void setSelectedValue(Object object, boolean bl) {
        this.list.setSelectedValue(object, bl);
    }

    public void setSelectionInterval(int n, int n2) {
        this.list.setSelectionInterval(n, n2);
    }

    public void setSelectionMode(int n) {
        this.list.setSelectionMode(n);
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        this.list.setSelectionModel(listSelectionModel);
    }

    public void setVisibleRowCount(int n) {
        this.list.setVisibleRowCount(n);
    }

    public Object getSelectedObject() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return this.the_dlm.get(n);
    }

    public Object[] getSelectedObjects() {
        int[] nArray = this.getSelectedIndices();
        if (nArray == null || nArray.length == 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            objectArray[n] = this.the_dlm.get(nArray[n]);
            ++n;
        }
        return objectArray;
    }

    public JList getJList() {
        return this.list;
    }

    public UJList copy() {
        UJList uJList = new UJList();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            uJList.add(enumeration.nextElement());
        }
        return uJList;
    }

    public void copy(UJList uJList) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            uJList.add(enumeration.nextElement());
        }
    }
}

