/*
 * Decompiled with CFR 0.152.
 */
package com.kb.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import javax.swing.ProgressMonitor;

public class Unflatten {
    static File output;
    static boolean copy;
    static boolean quiet;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0 || stringArray[0].equals("?") || stringArray[0].equals("-help")) {
            System.out.println(Unflatten.usage());
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-d")) {
                output = new File(stringArray[++n]);
            } else if (stringArray[n].equals("-copy")) {
                copy = true;
            } else if (stringArray[n].equals("-quiet")) {
                quiet = true;
            } else if (stringArray[n].startsWith("-")) {
                System.out.println(Unflatten.usage());
            } else {
                File file = new File(stringArray[n]);
                if (file.isDirectory()) {
                    File[] fileArray = file.listFiles();
                    int n2 = 0;
                    while (n2 < fileArray.length) {
                        if (fileArray[n2].getName().endsWith(".java")) {
                            Unflatten.unflatten(fileArray[n2]);
                        }
                        ++n2;
                    }
                } else {
                    Unflatten.unflatten(file);
                }
            }
            ++n;
        }
    }

    public static String usage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("java com.kb.util.Unflatten <options> <src-list>\n").append("    <src-list> is a space-separated list of files or directories to unflatten.\n").append("    <options>\n").append("       ?\n").append("       -help: display usage statement\n").append("       -d <out>: unflatten to the <out> directory\n").append("       -copy: copy files instead of moving them\n").append("       -quite: suppress non-error/warning messages\n").append("    If no arguments, defaults to -help.");
        return stringBuffer.toString();
    }

    public static void unflatten(File file) throws IOException {
        String string = Unflatten.getPackage(file);
        if (string == null) {
            System.out.println(file + ": no package");
        } else {
            String string2 = string.replace('.', '/');
            File file2 = output;
            if (file2 == null) {
                file2 = file.getParentFile();
            }
            File file3 = new File(file2, string2 + "/" + file.getName());
            file3.getParentFile().mkdirs();
            if (!quiet) {
                System.out.println(file + "->" + file3);
            }
            if (copy) {
                Unflatten.copyFile(file, file3, null);
            } else {
                file.renameTo(file3);
            }
        }
    }

    static String getPackage(File file) throws IOException {
        try {
            FileReader fileReader = new FileReader(file);
            LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
            String string = lineNumberReader.readLine().trim();
            String string2 = null;
            while (string != null) {
                if (string.startsWith("package")) {
                    int n = string.indexOf(32);
                    if (n == -1) {
                        throw new RuntimeException("Weird package line: " + lineNumberReader.getLineNumber() + ": " + string);
                    }
                    string2 = string.substring(n + 1, string.length() - 1).trim();
                    break;
                }
                string = lineNumberReader.readLine();
            }
            ((Reader)fileReader).close();
            return string2;
        }
        catch (IOException iOException) {
            System.out.println("Cannot move " + file);
            return null;
        }
    }

    public static void copyFile(File file, File file2, ProgressMonitor progressMonitor) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        while (progressMonitor == null || !progressMonitor.isCanceled()) {
            byte[] byArray = new byte[1024];
            int n = ((InputStream)bufferedInputStream).read(byArray);
            if (n == -1) break;
            ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
        }
        ((OutputStream)bufferedOutputStream).flush();
        ((OutputStream)bufferedOutputStream).close();
    }

    static {
        copy = false;
        quiet = false;
    }
}

