/*
 * Decompiled with CFR 0.152.
 */
package com.kb.util;

import com.kb.util.Enum;
import java.io.Serializable;

public class Queue
implements Serializable {
    private Object[] buf;
    private int last;
    private int first;

    public Queue() {
        this(50);
    }

    public Queue(int n) {
        this.buf = new Object[n];
        this.last = -1;
        this.first = -1;
    }

    private int after(int n) {
        int n2 = n + 1;
        if (n2 == this.buf.length) {
            n2 = 0;
        }
        return n2;
    }

    private void incr_last() {
        int n = this.last + 1;
        if (n == this.buf.length) {
            n = 0;
        }
        this.last = n == this.first ? this.expand_buf() : n;
    }

    private int expand_buf() {
        Object[] objectArray = new Object[this.buf.length * 2];
        int n = 0;
        int n2 = this.first;
        while (n2 != this.last) {
            objectArray[n++] = this.buf[n2];
            n2 = this.after(n2);
        }
        objectArray[n++] = this.buf[this.last];
        this.buf = objectArray;
        return n;
    }

    public void clear() {
        if (this.first == -1) {
            return;
        }
        int n = this.first;
        while (n != this.last) {
            this.buf[n] = null;
            n = this.after(n);
        }
        this.buf[this.last] = null;
        this.first = -1;
        this.last = -1;
    }

    public void add(Object object) {
        this.incr_last();
        this.buf[this.last] = object;
        if (this.first == -1) {
            this.first = 0;
        }
    }

    public Object peek() {
        return this.buf[this.first];
    }

    public Object next() {
        Object object = this.buf[this.first];
        this.buf[this.first] = null;
        if (this.first == this.last) {
            this.last = -1;
            this.first = -1;
        } else {
            this.first = this.after(this.first);
        }
        return object;
    }

    public int size() {
        if (this.first == -1) {
            return 0;
        }
        if (this.first <= this.last) {
            return this.last - this.first + 1;
        }
        return this.buf.length - (this.first - this.last - 1);
    }

    public boolean isEmpty() {
        return this.first == -1;
    }

    public Enum elements() {
        if (this.first == -1) {
            return new Enum(new Object[0]);
        }
        Object[] objectArray = new Object[this.size()];
        int n = 0;
        int n2 = this.first;
        while (n2 != this.last) {
            objectArray[n++] = this.buf[n2];
            n2 = this.after(n2);
        }
        objectArray[n] = this.buf[this.last];
        return new Enum(objectArray);
    }

    public String toString() {
        if (this.size() == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer(this.size() * 10);
        stringBuffer.append('[');
        stringBuffer.append(this.buf[this.first].toString());
        if (this.first == this.last) {
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
        int n = this.after(this.first);
        while (n != this.last) {
            stringBuffer.append(',');
            stringBuffer.append(this.buf[n].toString());
            n = this.after(n);
        }
        stringBuffer.append(',');
        stringBuffer.append(this.buf[this.last].toString());
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

