/*
 * Decompiled with CFR 0.152.
 */
package com.kb.util;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class ArrayUtils {
    public static final int indexOf(Object[] objectArray, Object object) {
        if (objectArray == null || object == null) {
            return -1;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (object.equals(objectArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static final int indexOf(int[] nArray, int n) {
        if (nArray == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static final boolean contains(Object[] objectArray, Object object) {
        return objectArray != null && ArrayUtils.indexOf(objectArray, object) != -1;
    }

    public static final boolean contains(int[] nArray, int n) {
        return nArray != null && ArrayUtils.indexOf(nArray, n) != -1;
    }

    public static final void reverse(Object[] objectArray) {
        int n = objectArray.length / 2;
        int n2 = objectArray.length - 1;
        int n3 = 0;
        while (n3 < n) {
            Object object = objectArray[n3];
            objectArray[n3] = objectArray[n2];
            objectArray[n2] = object;
            ++n3;
            --n2;
        }
    }

    public static final Object[] remove(Object[] objectArray, int n) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length - 1);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        if (n < objectArray.length - 1) {
            System.arraycopy(objectArray, n + 1, objectArray2, n, objectArray.length - (n + 1));
        }
        return objectArray2;
    }

    public static final int setUnique(Object[] objectArray, int n, Object object) {
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2].equals(object)) {
                return n;
            }
            ++n2;
        }
        objectArray[n] = object;
        return n + 1;
    }

    public static final Object[] insert(Object object, Object[] objectArray) {
        if (objectArray == null) {
            Class<?> clazz = object.getClass();
            Object[] objectArray2 = (Object[])Array.newInstance(clazz, 1);
            objectArray2[0] = object;
            return objectArray2;
        }
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray3 = (Object[])Array.newInstance(clazz, 1 + objectArray.length);
        objectArray3[0] = object;
        System.arraycopy(objectArray, 0, objectArray3, 1, objectArray.length);
        return objectArray3;
    }

    public static final Object[] add(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2;
        }
        if (objectArray2 == null) {
            return objectArray;
        }
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray3 = (Object[])Array.newInstance(clazz, objectArray.length + objectArray2.length);
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    public static final Object[] addUnique(Object[] objectArray, Object[] objectArray2) {
        if (objectArray2 == null || objectArray2.length == 0) {
            return objectArray;
        }
        if (objectArray == null || objectArray.length == 0) {
            return objectArray2;
        }
        Object object = new Object();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(objectArray.length + objectArray2.length, 1.0f);
        Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            hashtable.put(objectArray[n], object);
            ++n;
        }
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < objectArray2.length) {
            if (!hashtable.containsKey(objectArray2[n3])) {
                int n4 = n2++;
                Object object2 = objectArray2[n3];
                objectArray3[n4] = object2;
                hashtable.put(object2, object);
            }
            ++n3;
        }
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray4 = (Object[])Array.newInstance(clazz, n2);
        System.arraycopy(objectArray3, 0, objectArray4, 0, n2);
        return objectArray4;
    }

    public static final Object[] diff(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray2 == null || objectArray2.length == 0) {
            return objectArray;
        }
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(objectArray2.length, 1.0f);
        int n = 0;
        while (n < objectArray2.length) {
            hashtable.put(objectArray2[n], objectArray2[n]);
            ++n;
        }
        Object[] objectArray3 = new Object[objectArray.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (!hashtable.containsKey(objectArray[n3])) {
                objectArray3[n2++] = objectArray[n3];
            }
            ++n3;
        }
        if (n2 == objectArray.length) {
            return objectArray;
        }
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray4 = (Object[])Array.newInstance(clazz, n2);
        System.arraycopy(objectArray3, 0, objectArray4, 0, n2);
        return objectArray4;
    }

    public static final Object[] union(Object[][] objectArray) {
        if (objectArray.length == 0) {
            return null;
        }
        Class<?> clazz = objectArray[0].getClass().getComponentType();
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            n += objectArray[n2].length;
            ++n2;
        }
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(n, 1.0f);
        int n3 = 0;
        while (n3 < objectArray.length) {
            int n4 = 0;
            while (n4 < objectArray[n3].length) {
                hashtable.put(objectArray[n3][n4], objectArray[n3][n4]);
                ++n4;
            }
            ++n3;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, hashtable.size());
        int n5 = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            objectArray2[n5] = enumeration.nextElement();
            ++n5;
        }
        return objectArray2;
    }

    public static final Object[] intersect(Object[][] objectArray) {
        int n;
        Object[] objectArray2;
        if (objectArray.length == 0) {
            return null;
        }
        Class<?> clazz = objectArray[0].getClass().getComponentType();
        Object[] objectArray3 = new Hashtable(objectArray[0].length + 1, 1.0f);
        int n2 = 0;
        while (n2 < objectArray[0].length) {
            objectArray3.put(objectArray[0][n2], objectArray[0][n2]);
            ++n2;
        }
        int n3 = 1;
        while (n3 < objectArray.length) {
            if (objectArray3.size() == 0) {
                return (Object[])Array.newInstance(clazz, 0);
            }
            objectArray2 = new Hashtable(objectArray3.size() + 1, 1.0f);
            n = 0;
            while (n < objectArray[n3].length) {
                if (objectArray3.containsKey(objectArray[n3][n])) {
                    objectArray2.put(objectArray[n3][n], objectArray[n3][n]);
                }
                ++n;
            }
            objectArray3 = objectArray2;
            ++n3;
        }
        objectArray2 = (Object[])Array.newInstance(clazz, objectArray3.size());
        n = 0;
        Enumeration enumeration = objectArray3.keys();
        while (enumeration.hasMoreElements()) {
            objectArray2[n] = enumeration.nextElement();
            ++n;
        }
        return objectArray2;
    }

    public static final void printArray(Object[] objectArray, PrintStream printStream, String string) {
        if (objectArray == null) {
            printStream.println(string + "null");
        } else if (objectArray.length == 0) {
            printStream.println(string + "empty array");
        } else {
            int n = 0;
            while (n < objectArray.length) {
                printStream.println(string + objectArray[n]);
                ++n;
            }
        }
    }

    public static final void printArray(Object[] objectArray) {
        ArrayUtils.printArray(objectArray, System.out, "");
    }

    public static final void printArray(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            System.out.println(arrayList.get(n2));
            ++n2;
        }
    }

    public static final Object[] prefix(Object[] objectArray, int n) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, n);
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length > n ? n : objectArray.length);
        return objectArray2;
    }

    public static final String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        if (objectArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayUtils.to_str2(stringBuffer, objectArray);
        return stringBuffer.toString();
    }

    private static final void to_str(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            stringBuffer.append("null");
        } else if (object instanceof Object[]) {
            ArrayUtils.to_str2(stringBuffer, (Object[])object);
        } else {
            stringBuffer.append(object.toString());
        }
    }

    private static final void to_str2(StringBuffer stringBuffer, Object[] objectArray) {
        if (objectArray == null) {
            stringBuffer.append("null");
            return;
        }
        if (objectArray.length > 0) {
            ArrayUtils.to_str(stringBuffer.append('['), objectArray[0]);
            int n = 1;
            while (n < objectArray.length) {
                ArrayUtils.to_str(stringBuffer.append(','), objectArray[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
    }

    public static final String toString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        if (nArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(Integer.toString(nArray[0]));
        int n = 1;
        while (n < nArray.length) {
            stringBuffer.append(',').append(Integer.toString(nArray[n]));
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static final String toString(boolean[] blArray) {
        if (blArray == null) {
            return "null";
        }
        if (blArray.length == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[').append(blArray[0]);
        int n = 1;
        while (n < blArray.length) {
            stringBuffer.append(',').append(blArray[n]);
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static final void add(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList2 == null) {
            return;
        }
        arrayList.addAll(arrayList2);
    }

    public static final void addUnique(List list, List list2) {
        int n = list2.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = list2.get(n2);
            if (!list.contains(e)) {
                list.add(e);
            }
            ++n2;
        }
    }

    public static final Object move(Object object, ArrayList arrayList, ArrayList arrayList2) {
        int n = arrayList.indexOf(object);
        if (n < 0) {
            return null;
        }
        Object e = arrayList.remove(n);
        arrayList2.add(e);
        return e;
    }

    public static final boolean containsAll(ArrayList arrayList, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (!arrayList.contains(objectArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static final int indexOf(ArrayList arrayList, Object object, int n) {
        int n2 = arrayList.size();
        int n3 = n;
        while (n3 < n2) {
            if (arrayList.get(n3).equals(object)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static final void reverse(ArrayList arrayList) {
        int n = -1;
        int n2 = arrayList.size();
        while (++n < --n2) {
            Object e = arrayList.get(n);
            arrayList.set(n, arrayList.get(n2));
            arrayList.set(n2, e);
        }
    }

    public static final int replaceAll(Object[] objectArray, Object object, Object object2) {
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2].equals(object)) {
                objectArray[n2] = object2;
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static final Object getAssoc(Object[][] objectArray, Object object) {
        int n = 0;
        while (n < objectArray.length) {
            Object[] objectArray2 = objectArray[n];
            if (object.equals(objectArray2[0])) {
                return objectArray2[1];
            }
            ++n;
        }
        return null;
    }

    public static final boolean pairEquals(ArrayList arrayList, ArrayList arrayList2) {
        return ArrayUtils.pairEquals(arrayList, arrayList2, false);
    }

    public static final boolean pairEquals(ArrayList arrayList, ArrayList arrayList2, boolean bl) {
        int n = arrayList.size();
        int n2 = arrayList2.size();
        int n3 = n;
        if (n != n2) {
            if (!bl) {
                return false;
            }
            if (n2 < n) {
                n3 = n2;
            }
        }
        int n4 = 0;
        while (n4 < n) {
            if (!arrayList.get(n4).equals(arrayList2.get(n4))) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static final boolean pairEquals(Object[] objectArray, Object[] objectArray2) {
        return ArrayUtils.pairEquals(objectArray, objectArray2, null, false);
    }

    public static final boolean pairEquals(Object[] objectArray, Object[] objectArray2, Comparator comparator, boolean bl) {
        int n = objectArray.length;
        if (objectArray.length != objectArray2.length) {
            if (!bl) {
                return false;
            }
            if (objectArray2.length < objectArray.length) {
                n = objectArray2.length;
            }
        }
        int n2 = 0;
        while (n2 < n) {
            if (comparator == null ? !objectArray[n2].equals(objectArray2[n2]) : comparator.compare(objectArray[n2], objectArray2[n2]) != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

