/*
 * Decompiled with CFR 0.152.
 */
package com.kb.server.sm.ddb;

import com.kb.client.Database;
import com.kb.client.InsertFailure;
import com.kb.client.InvalidQuery;
import com.kb.client.QueryFailure;
import com.kb.client.StorageManagerFault;
import com.kb.client.UpdateFailure;
import com.kb.client_server.Answers;
import com.kb.client_server.ICViolation;
import com.kb.kbddutil.FileNamer;
import com.kb.kbddutil.KBProperties;
import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.KBDate;
import com.kb.owl.OWL;
import com.kb.owl.QuotedString;
import com.kb.owl.SVar;
import com.kb.owl.Symbol;
import com.kb.owl.SyntaxError;
import com.kb.owl.Time;
import com.kb.server.ServerMD;
import com.kb.server.ServerUtils;
import com.kb.server.sm.DbArchive;
import com.kb.server.sm.ImproperTransactionFault;
import com.kb.server.sm.SMTransaction;
import com.kb.server.sm.StorageManager;
import com.kb.server.sm.ddb.XsbConnection;
import com.kb.xsb.List;
import com.kb.xsb.OWL2XSB;
import com.kb.xsb.Structure;
import com.kb.xsb.Variable;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class XSBStorageManager
extends StorageManager {
    boolean needsAbolish = false;
    boolean verbose = false;
    boolean closed = false;
    XsbConnection xsb;
    SigMap idbSigs;
    SigMap edbSigs;
    public boolean heartbeat = KBProperties.getBoolean("com.kb.heartbeat");
    public static final Variable ErrID = new Variable("ErrID");
    public static final Variable ErrMsg = new Variable("ErrMsg");
    static final ServerMD queryMD = new ServerMD();
    static /* synthetic */ Class class$com$kb$server$sm$ddb$XSBStorageManager;

    public XSBStorageManager(Database database, boolean bl) throws StorageManagerFault {
        super(database);
        this.initializeXSB();
        String string = KBProperties.get("com.kb.xsbDebug");
        if (string != null && string.length() > 0) {
            this.xsb.command(new Structure((Object)"reconsult", "kb_debug"));
            this.xsb.command(new Structure((Object)"kb_set_debug_file", string));
        }
        try {
            long l = System.currentTimeMillis();
            this.readLog(bl);
            long l2 = System.currentTimeMillis();
            System.err.println("Log load time: " + (l2 - l));
        }
        catch (Exception exception) {
            throw new StorageManagerFault("Cannot initialize", exception);
        }
        if (KBProperties.getBoolean("kb.bootstrap")) {
            this.xsb.command(this.xsb.struct("reconsult", "bootstrap"));
        }
        String string2 = database.getDir();
        this.xsb.command("kb_initial_bootstrap", new File(string2, "kbdir.P").getAbsolutePath(), new File(string2, "kbtax.P").getAbsolutePath(), new File(string2, "kbfacts.P").getAbsolutePath());
        this.idbSigs = this.getSigMap("idb");
        this.edbSigs = this.getSigMap("es");
    }

    void initializeXSB() {
        Object object;
        String[] stringArray;
        Object object2;
        Object object3;
        Object object4;
        String string = KBProperties.get("com.kb.xsb.home");
        if (string == null || string.length() == 0) {
            object4 = (class$com$kb$server$sm$ddb$XSBStorageManager == null ? (class$com$kb$server$sm$ddb$XSBStorageManager = XSBStorageManager.class$("com.kb.server.sm.ddb.XSBStorageManager")) : class$com$kb$server$sm$ddb$XSBStorageManager).getResource("/xsb/syslib/loader.O");
            if (object4 == null) {
                string = "xsb";
            } else {
                object3 = new File(FileNamer.decodeURL(((URL)object4).getFile()));
                if (!((File)object3).exists()) {
                    throw new RuntimeException("Could not determine location of support files: best guess is " + object3);
                }
                string = ((File)object3).getParentFile().getParent();
            }
        }
        string = FileNamer.name(string);
        object4 = KBProperties.get("com.kb.xsb.kb");
        if (object4 == null || ((String)object4).length() == 0) {
            object3 = (class$com$kb$server$sm$ddb$XSBStorageManager == null ? (class$com$kb$server$sm$ddb$XSBStorageManager = XSBStorageManager.class$("com.kb.server.sm.ddb.XSBStorageManager")) : class$com$kb$server$sm$ddb$XSBStorageManager).getResource("/xsb/kb/xfindall.O");
            if (object3 == null) {
                object4 = string + "/kb";
            } else {
                object2 = new File(FileNamer.decodeURL(((URL)object3).getFile()));
                object4 = ((File)object2).getParent();
            }
        }
        object4 = FileNamer.name((String)object4);
        object3 = KBProperties.get("com.kb.xsb.kbdb");
        if (object3 == null || ((String)object3).length() == 0) {
            object2 = (class$com$kb$server$sm$ddb$XSBStorageManager == null ? (class$com$kb$server$sm$ddb$XSBStorageManager = XSBStorageManager.class$("com.kb.server.sm.ddb.XSBStorageManager")) : class$com$kb$server$sm$ddb$XSBStorageManager).getResource("/xsb/kb/kbdb.O");
            object3 = object2 == null ? "owddb/xsb/kb" : new File(((URL)object2).getFile()).getParent();
        }
        object3 = FileNamer.name((String)object3);
        object2 = KBProperties.get("com.kb.xsb.args");
        if (object2 == null) {
            object2 = "";
        }
        if ((object2 = "-S " + (String)object2) == null) {
            stringArray = new String[]{};
        } else {
            object = new StringTokenizer((String)object2);
            stringArray = new String[((StringTokenizer)object).countTokens()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = ((StringTokenizer)object).nextToken();
                ++n;
            }
        }
        this.xsb = new XsbConnection(string, stringArray);
        object = this.database.getDir();
        this.xsb.command(this.xsb.struct("asserta", this.xsb.struct("library_directory", object4)));
        this.xsb.command(this.xsb.struct("asserta", this.xsb.struct("library_directory", object3)));
        this.xsb.command(this.xsb.struct("asserta", this.xsb.struct("library_directory", object)));
        this.xsb.command(this.xsb.struct("reconsult", "kbload"));
    }

    public void close() throws StorageManagerFault {
        System.out.println("Closing");
        try {
            XsbConnection xsbConnection = this.xsb;
            synchronized (xsbConnection) {
                if (!this.closed) {
                    this.xsb.command("close");
                    this.xsb.command("kb_shutdown");
                }
                this.closed = true;
            }
        }
        catch (Exception exception) {
            throw new StorageManagerFault(exception.getMessage());
        }
        System.out.println("Done closing");
    }

    public void readLog(boolean bl) throws StorageManagerFault {
        File file = new File(this.database.getDir());
        if (!file.exists()) {
            throw new StorageManagerFault("Database " + this.database.getDatabaseName() + " does not exist; no directory " + file);
        }
        String string = new File(this.database.getDir() + "/data").getAbsolutePath();
        System.out.println("Database directory: " + string);
        try {
            String[] stringArray;
            Answers answers;
            Variable variable = new Variable("ErrID");
            Variable variable2 = new Variable("ErrMsg");
            if (new File(string).mkdirs()) {
                System.out.println("Created " + string);
            }
            if ((answers = this.queryDB(new Structure((Object)"openDB", new Object[]{string, stringArray = bl ? new String[]{"rdonly"} : new String[]{"create"}, variable, variable2}), new Variable[]{variable, variable2})).numAnswers() != 1) {
                throw new StorageManagerFault("Database opened funny; returned " + answers.numAnswers() + " times");
            }
            if (answers.answer(0, 0) instanceof String || answers.answer(0, 0) instanceof Integer) {
                String string2 = answers.answer(0, 0).toString();
                if (!string2.equals("OK")) {
                    String string3 = answers.answer(0, 1).toString();
                    throw new StorageManagerFault("Database open failed with code " + string2 + ": " + string3);
                }
            } else {
                throw new StorageManagerFault("Database opened funny; got a " + answers.answer(0, 0).getClass().getName());
            }
            System.out.println("Database open succeeded");
        }
        catch (QueryFailure queryFailure) {
            throw new StorageManagerFault("Cannot open database", queryFailure);
        }
    }

    public void insertDB(Object object, SMTransaction sMTransaction) throws StorageManagerFault, InsertFailure {
        Object object2;
        if ((object = this.removeQuote(object)) instanceof Structure && ((Structure)(object2 = (Structure)object)).functor().equals("oms_s2f") && ((Structure)object2).arg(0) instanceof Variable) {
            throw new Error("Bogus oms_s2f: " + object2);
        }
        object2 = (SleepycatTransaction)sMTransaction;
        if (this.heartbeat) {
            System.out.println("Inserting " + object + " via " + ((SleepycatTransaction)object2).txn());
        }
        XsbConnection xsbConnection = this.xsb;
        synchronized (xsbConnection) {
            this.needsAbolish = true;
            Structure structure = new Structure((Object)"insert", new Object[]{object, new Integer(((SleepycatTransaction)object2).txn()), ErrID, ErrMsg});
            this.xsb.j2p_term(structure, this.xsb.reg_term(1));
            int n = this.xsb.xsb_query();
            if (n != 0) {
                throw new StorageManagerFault("XSB returned " + n);
            }
            int n2 = this.xsb.reg_term(1);
            Object object3 = this.xsb.p2j_term(this.xsb.p2p_arg(n2, 3));
            Object object4 = this.xsb.p2j_term(this.xsb.p2p_arg(n2, 4));
            this.xsb.xsb_close_query();
            if (!object3.equals("OK") && !object3.equals("DB_KEYEXIST")) {
                throw new InsertFailure(structure + ": " + object3 + " " + object4);
            }
        }
    }

    public void deleteDB(Object object, SMTransaction sMTransaction) throws StorageManagerFault {
        object = this.removeQuote(object);
        SleepycatTransaction sleepycatTransaction = (SleepycatTransaction)sMTransaction;
        XsbConnection xsbConnection = this.xsb;
        synchronized (xsbConnection) {
            this.needsAbolish = true;
            this.xsb.command("delete", object, new Integer(sleepycatTransaction.txn()));
        }
    }

    public SMTransaction beginTransactionDB(SMTransaction sMTransaction) throws StorageManagerFault {
        if (sMTransaction != null && !(sMTransaction instanceof SleepycatTransaction)) {
            throw new ImproperTransactionFault(sMTransaction);
        }
        SleepycatTransaction sleepycatTransaction = (SleepycatTransaction)sMTransaction;
        try {
            SleepycatTransaction sleepycatTransaction2 = new SleepycatTransaction(sleepycatTransaction);
            return sleepycatTransaction2;
        }
        catch (Throwable throwable) {
            throw new StorageManagerFault("Cannot commit", throwable);
        }
    }

    public void cleanUpDatabase() throws StorageManagerFault {
        Answers answers;
        Variable variable = new Variable("X");
        Variable variable2 = new Variable("Err");
        try {
            answers = this.queryDB(new Structure("sleepycatLogArchive", "unused", variable, variable2), new Variable[]{variable, variable2});
        }
        catch (QueryFailure queryFailure) {
            throw new StorageManagerFault("Error cleaning up database", queryFailure);
        }
        if (answers.numAnswers() != 1) {
            throw new StorageManagerFault("Database cleanup failed for an unknown reason");
        }
        try {
            List list = (List)answers.answer(0, 0);
            int n = (Integer)answers.answer(0, 1);
            if (n != 0) {
                throw new StorageManagerFault("log_archive returned " + n);
            }
            Object[] objectArray = list.toArray();
            int n2 = 0;
            while (n2 < objectArray.length) {
                new File((String)objectArray[n2]).delete();
                ++n2;
            }
        }
        catch (ClassCastException classCastException) {
            throw new StorageManagerFault("Invalid returns from sleepycatLogArchive: " + answers);
        }
    }

    public void commitDB(SMTransaction sMTransaction) throws StorageManagerFault {
        if (!(sMTransaction instanceof SleepycatTransaction)) {
            throw new ImproperTransactionFault(sMTransaction);
        }
        SleepycatTransaction sleepycatTransaction = (SleepycatTransaction)sMTransaction;
        XsbConnection xsbConnection = this.xsb;
        synchronized (xsbConnection) {
            try {
                System.out.println("Committing " + sleepycatTransaction.txn());
                if (!this.closed) {
                    Structure structure = new Structure("commit", new Integer(sleepycatTransaction.txn()), ErrID, ErrMsg);
                    this.xsb.j2p_term(structure, this.xsb.reg_term(1));
                    int n = this.xsb.xsb_query();
                    if (n != 0) {
                        throw new StorageManagerFault("Rollback failed: code = " + n);
                    }
                    int n2 = this.xsb.reg_term(1);
                    Object object = this.xsb.p2j_term(this.xsb.p2p_arg(n2, 2));
                    Object object2 = this.xsb.p2j_term(this.xsb.p2p_arg(n2, 3));
                    this.xsb.xsb_close_query();
                    if (!object.equals("OK")) {
                        throw new InsertFailure(structure + ": " + object + " " + object2);
                    }
                    this.cleanUpDatabase();
                    System.out.println("Done committing " + sleepycatTransaction.txn());
                } else {
                    System.err.println("Cannot abort transaction; DB closed\n");
                }
            }
            catch (Throwable throwable) {
                throw new StorageManagerFault("Cannot abort", throwable);
            }
        }
    }

    public void rollbackDB(SMTransaction sMTransaction) throws StorageManagerFault {
        if (!(sMTransaction instanceof SleepycatTransaction)) {
            throw new ImproperTransactionFault(sMTransaction);
        }
        SleepycatTransaction sleepycatTransaction = (SleepycatTransaction)sMTransaction;
        this.needsAbolish = true;
        XsbConnection xsbConnection = this.xsb;
        synchronized (xsbConnection) {
            try {
                XSBStorageManager xSBStorageManager = this;
                synchronized (xSBStorageManager) {
                    if (!this.closed) {
                        Structure structure = new Structure("rollback", new Integer(sleepycatTransaction.txn()), ErrID, ErrMsg);
                        this.xsb.j2p_term(structure, this.xsb.reg_term(1));
                        int n = this.xsb.xsb_query();
                        if (n != 0) {
                            throw new StorageManagerFault("Rollback failed: code = " + n);
                        }
                        int n2 = this.xsb.reg_term(1);
                        Object object = this.xsb.p2j_term(this.xsb.p2p_arg(n2, 2));
                        Object object2 = this.xsb.p2j_term(this.xsb.p2p_arg(n2, 3));
                        this.xsb.xsb_close_query();
                        if (!object.equals("OK")) {
                            throw new InsertFailure(structure + ": " + object + " " + object2);
                        }
                    } else {
                        System.err.println("Cannot abort transaction; DB closed\n");
                    }
                }
            }
            catch (Throwable throwable) {
                throw new StorageManagerFault("Cannot abort", throwable);
            }
        }
    }

    public void archive(String string) throws StorageManagerFault {
        try {
            DbArchive.archive(this.database.getDir(), string);
        }
        catch (Exception exception) {
            throw new StorageManagerFault(exception.toString());
        }
    }

    public void restore(String string) throws StorageManagerFault {
        try {
            XsbConnection xsbConnection = this.xsb;
            synchronized (xsbConnection) {
                this.xsb.command("close");
                DbArchive.restore(this.database.getDir(), string);
                this.readLog(false);
            }
        }
        catch (Exception exception) {
            throw new StorageManagerFault(exception.toString());
        }
    }

    private Object removeQuote(Object object) {
        if (object instanceof Structure && ((Structure)object).functor().equals("_$kbquote")) {
            return ((Structure)object).arg(0);
        }
        return object;
    }

    public ICViolation[] runIntegrityConstraints(SMTransaction sMTransaction) throws QueryFailure, StorageManagerFault {
        if (!KBProperties.getBoolean("kb.skipIntegrityConstraints")) {
            Variable variable = new Variable("Violations");
            SleepycatTransaction sleepycatTransaction = (SleepycatTransaction)sMTransaction;
            System.out.println("Executing transaction ICs");
            Structure structure = new Structure("oms_exec_ics", new Integer(sleepycatTransaction.txn()), variable);
            Answers answers = this.queryDB(structure, new Variable[]{variable}, 1);
            if (answers.numAnswers() == 0) {
                return new ICViolation[0];
            }
            Object object = answers.answer(0, 0);
            Vector<Object> vector = new Vector<Object>();
            while (object instanceof List) {
                List list = (List)object;
                vector.addElement(list.car);
                object = list.cdr;
            }
            return this.buildICViolationList(vector.toArray());
        }
        return new ICViolation[0];
    }

    ICViolation[] buildICViolationList(Object[] objectArray) throws StorageManagerFault {
        ICViolation[] iCViolationArray = new ICViolation[objectArray.length];
        int n = 0;
        while (n < iCViolationArray.length) {
            try {
                Structure structure = (Structure)objectArray[n];
                String string = OWL2XSB.convertParseStructure(structure.arg(0)).name();
                String string2 = OWL2XSB.convertParseStructure(structure.arg(3)).name();
                Object object = structure.arg(1);
                Object object2 = structure.arg(2);
                iCViolationArray[n] = new ICViolation(string2, string, object, object2);
            }
            catch (ClassCastException classCastException) {
                throw new StorageManagerFault("Unexpected IC violation structure: " + objectArray[n], classCastException);
            }
            ++n;
        }
        return iCViolationArray;
    }

    public Answers queryDB(Object object, Variable[] variableArray, int n) throws QueryFailure {
        if (KBProperties.getBoolean("com.kb.server.sm.sleepycat.heartbeat")) {
            System.out.println("Asking " + object);
        }
        object = this.removeQuote(object);
        XsbConnection xsbConnection = this.xsb;
        synchronized (xsbConnection) {
            Answers answers;
            try {
                Answers answers2;
                if (this.needsAbolish) {
                    if (KBProperties.getBoolean("com.kb.server.sm.sleepycat.abolish.heartbeat")) {
                        System.err.println("Abolishing all tables");
                    }
                    this.xsb.command("abolish_all_tables");
                    this.needsAbolish = false;
                }
                Hashtable hashtable = new Hashtable();
                Structure structure = this.xsb.struct(",", this.xsb.struct("succeed", variableArray), object);
                this.xsb.j2p_term(structure, this.xsb.reg_term(1), hashtable, null);
                answers = answers2 = this.fetchAnswers(hashtable, variableArray, n);
                Object var10_9 = null;
                this.xsb.xsb_close_query();
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.xsb.xsb_close_query();
                throw throwable;
            }
            return answers;
        }
    }

    Answers fetchAnswers(Dictionary dictionary, Variable[] variableArray, int n) {
        int n2;
        if (this.heartbeat) {
            System.err.println(">>Asking: " + this.xsb.ptoj_term(1));
        }
        if ((n2 = this.xsb.xsb_query()) == 1) {
            if (this.heartbeat) {
                System.out.println(">> No answers");
            }
            return new Answers(0, new int[0][], null);
        }
        if (n2 != 0 && n2 != 1) {
            throw new RuntimeException("xsb_query returned " + n2);
        }
        Vector<Object> vector = null;
        int n3 = 0;
        int n4 = variableArray.length;
        int[][] nArray = new int[100][n4];
        if (variableArray.length == 0) {
            n = 1;
        }
        boolean bl = KBProperties.getBoolean("kb.runToCompletion");
        while (n2 == 0 && (bl || n3 < n)) {
            if (n3 >= nArray.length) {
                int[][] nArray2 = new int[n3 * 2][n4];
                System.arraycopy(nArray, 0, nArray2, 0, n3);
                nArray = nArray2;
            }
            if (this.heartbeat) {
                System.out.println(">>Answer: " + this.xsb.p2j_term(this.xsb.reg_term(1)));
            }
            int n5 = this.xsb.p2p_arg(this.xsb.p2p_arg(this.xsb.reg_term(1), 1), 1);
            int n6 = 0;
            while (n6 < variableArray.length) {
                int n7;
                int n8 = this.xsb.p2p_car(n5);
                n5 = this.xsb.p2p_cdr(n5);
                if (this.verbose) {
                    System.out.println(variableArray[n6] + "=" + this.xsb.p2j_term(n8));
                }
                if (this.xsb.is_int(n8) && (n7 = this.xsb.p2j_int(n8)) >= 0) {
                    nArray[n3][n6] = n7;
                } else {
                    if (vector == null) {
                        vector = new Vector<Object>();
                    }
                    Object object = this.xsb.p2j_term(n8);
                    vector.addElement(object);
                    nArray[n3][n6] = -vector.size();
                }
                ++n6;
            }
            ++n3;
            n2 = this.xsb.xsb_next();
        }
        if (n2 != 0 && n2 != 1) {
            throw new RuntimeException("xsb_next returned " + n2);
        }
        return new Answers(n3, nArray, vector);
    }

    public SigMap getSigMap(String string) {
        return new SigMap(string);
    }

    public static void printAnswers(Object[] objectArray, PrintStream printStream) {
        int n = 0;
        while (n < objectArray.length) {
            printStream.println(n + ". " + objectArray[n]);
            if (objectArray[n] instanceof Object[]) {
                Object[] objectArray2 = (Object[])objectArray[n];
                int n2 = 0;
                while (n2 < objectArray2.length) {
                    printStream.println(n + "." + n2 + ". " + objectArray2[n2]);
                    ++n2;
                }
            }
            ++n;
        }
    }

    Object[] formatForm(OWL oWL, ServerMD serverMD, SigMap sigMap) throws InvalidQuery, StorageManagerFault {
        if (oWL.named("holdsIn")) {
            return this.holdsIn(oWL, serverMD, sigMap);
        }
        Structure[] structureArray = null;
        if (ServerUtils.isInternallyDefinedPredicate(oWL.name())) {
            return new Object[]{this.formatNaive(oWL)};
        }
        structureArray = sigMap.signature(oWL.name(), oWL.arity());
        if (structureArray.length == 0) {
            throw new InvalidQuery("Unknown predicate " + oWL.name() + "/" + oWL.arity());
        }
        Object[] objectArray = new Object[structureArray.length];
        int n = 0;
        while (n < objectArray.length) {
            Structure structure = structureArray[n];
            try {
                Object[] objectArray2 = new Object[structure.arity()];
                int n2 = 0;
                boolean bl = false;
                Object[] objectArray3 = new Object[]{new Variable(), new Variable()};
                int n3 = 0;
                while (n3 < structure.arity()) {
                    if ("st_time".equals(structure.arg(n3))) {
                        objectArray2[n3] = serverMD.time == null ? (sigMap == this.idbSigs ? new Variable() : Time.java2xsb(KBDate.start)) : Time.owl2xsbPair(serverMD.time)[0];
                        objectArray3[0] = objectArray2[n3];
                        bl = true;
                    } else if ("en_time".equals(structure.arg(n3))) {
                        objectArray2[n3] = serverMD.time == null ? (sigMap == this.idbSigs ? new Variable() : Time.java2xsb(KBDate.now)) : Time.owl2xsbPair(serverMD.time)[1];
                        objectArray3[1] = objectArray2[n3];
                        bl = true;
                    } else if ("aid".equals(structure.arg(n3))) {
                        serverMD.outAID = objectArray2[n3] = this.formatAID(serverMD.aid);
                    } else {
                        objectArray2[n3] = "ctx".equals(structure.arg(n3)) ? (serverMD.context == null ? "RootCtx" : serverMD.context.name()) : this.formatFunctionTerm(oWL.arg(n2++));
                    }
                    ++n3;
                }
                objectArray[n] = new Structure(structure.functor(), objectArray2);
                if (bl) {
                    serverMD.outTime = new Structure((Object)"_kbti", objectArray3);
                }
            }
            catch (SyntaxError syntaxError) {
                throw new StorageManagerFault("Cannot transform " + oWL + " into " + structure, syntaxError);
            }
            ++n;
        }
        return objectArray;
    }

    Object formatAID(OWL oWL) throws InvalidQuery {
        return oWL == null ? new Variable() : this.formatFunctionTerm(oWL);
    }

    Object formatFunction(Form form) throws InvalidQuery {
        Answers answers;
        Object[] objectArray;
        if (form.named("RootCtx.listof") || form.named("listof")) {
            Object[] objectArray2 = new Object[form.arity()];
            int n = 0;
            while (n < objectArray2.length) {
                objectArray2[n] = this.formatFunctionTerm(form.arg(n));
                ++n;
            }
            return objectArray2;
        }
        if (form.named("RootCtx.Date") || form.named("RootCtx.Span")) {
            try {
                return (Structure)Time.owl2xsb(form);
            }
            catch (SyntaxError syntaxError) {
                throw new InvalidQuery(syntaxError.getMessage());
            }
        }
        try {
            objectArray = new Variable();
            Variable variable = new Variable();
            answers = this.queryDB(new Structure((Object)"kbprop", new Object[]{form.functor().toString(), new Integer(form.arity()), "fun", objectArray, variable}), new Variable[]{objectArray, variable});
        }
        catch (QueryFailure queryFailure) {
            throw new StorageManagerFault(queryFailure.getMessage(), queryFailure);
        }
        if (answers.no()) {
            throw new InvalidQuery("Unknown function " + form.functor() + "/" + form.arity());
        }
        objectArray = new Object[form.arity()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.formatFunctionTerm(form.arg(n));
            ++n;
        }
        return new Structure(this.formatFunctionTerm(form.functor()), objectArray);
    }

    Object formatNaive(OWL oWL) throws InvalidQuery {
        if (oWL instanceof Form) {
            Form form = (Form)oWL;
            Object[] objectArray = new Object[form.arity()];
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = this.formatNaive(form.arg(n));
                ++n;
            }
            return new Structure(this.formatNaive(form.functor()), objectArray);
        }
        return this.formatFunctionTerm(oWL);
    }

    Object formatSymbol(Symbol symbol) {
        Object object;
        if (symbol.isInt()) {
            int n = symbol.intValue();
            object = n > 100000000 ? (Number)Float.valueOf(symbol.name()) : (Number)Integer.valueOf(symbol.name());
        } else if (symbol.isReal()) {
            object = Float.valueOf(symbol.name());
        } else {
            if (symbol.named("=")) {
                return "_kbeq";
            }
            if (symbol.named("/=")) {
                return "_kbneq";
            }
            object = symbol.name();
        }
        return object;
    }

    Object formatFunctionTerm(OWL oWL) throws InvalidQuery {
        if (oWL.named("quote") && oWL instanceof Form) {
            Form form = (Form)oWL;
            if (form.arity() != 1) {
                throw new InvalidQuery("quote requires 1 argument");
            }
            return new Structure((Object)"quote", this.formatNaive(form.arg(0)));
        }
        if (oWL instanceof IVar) {
            return new Variable(oWL.name());
        }
        if (oWL instanceof Form) {
            return this.formatFunction((Form)oWL);
        }
        if (oWL instanceof Symbol) {
            return this.formatSymbol((Symbol)oWL);
        }
        if (oWL instanceof QuotedString) {
            return new Structure((Object)"qstr", ((QuotedString)oWL).text());
        }
        throw new InvalidQuery("Invalid function term " + oWL);
    }

    Object[] holdsIn(OWL oWL, ServerMD serverMD, SigMap sigMap) throws InvalidQuery, StorageManagerFault {
        if (!(oWL instanceof Form)) {
            throw new InvalidQuery("holdsIn must be a form: " + oWL);
        }
        Form form = (Form)oWL;
        if (form.arity() != 2) {
            throw new InvalidQuery("Invalid syntax of holdsIn: " + oWL);
        }
        OWL oWL2 = form.arg(0);
        OWL oWL3 = form.arg(1);
        serverMD.time = oWL2;
        return this.formatForm(oWL3, serverMD, sigMap);
    }

    Object formatQuery(OWL oWL, ServerMD serverMD, SigMap sigMap) throws InvalidQuery, StorageManagerFault {
        if (oWL == null) {
            return new Variable();
        }
        if (oWL.named("!xsb")) {
            return this.formatNaive(((Form)oWL).arg(0));
        }
        if (oWL.named("and")) {
            int n = oWL.arity() - 1;
            Object object = this.formatQuery(oWL.arg(n), serverMD, sigMap);
            --n;
            while (n >= 0) {
                object = new Structure(",", this.formatQuery(oWL.arg(n), serverMD, sigMap), object);
                --n;
            }
            return object;
        }
        if (oWL.named("or")) {
            int n = oWL.arity() - 1;
            Object object = this.formatQuery(oWL.arg(n), serverMD, sigMap);
            --n;
            while (n >= 0) {
                object = new Structure(";", this.formatQuery(oWL.arg(n), serverMD, sigMap), object);
                --n;
            }
            return object;
        }
        if (oWL.named("not")) {
            Object[] objectArray = new Object[oWL.arity()];
            if (objectArray.length != 1) {
                throw new InvalidQuery("not requires 1 argument");
            }
            int n = 0;
            while (n < oWL.arity()) {
                objectArray[n] = this.formatQuery(oWL.arg(n), serverMD, sigMap);
                ++n;
            }
            return new Structure((Object)"enot", objectArray);
        }
        if (oWL.named("exists")) {
            Object[] objectArray = new Object[oWL.arity()];
            if (objectArray.length != 2) {
                throw new InvalidQuery("exists requires 2 arguments");
            }
            return this.formatQuery(oWL.arg(1), serverMD, sigMap);
        }
        if (oWL.named("findall")) {
            Object[] objectArray = new Object[oWL.arity()];
            if (objectArray.length != 3) {
                throw new InvalidQuery("findall requires 3 arguments");
            }
            int n = 0;
            while (n < oWL.arity()) {
                objectArray[n] = this.formatQuery(oWL.arg(n), serverMD, sigMap);
                ++n;
            }
            return new Structure((Object)"xfindall", objectArray);
        }
        if (oWL.named("setof")) {
            Object[] objectArray = new Object[oWL.arity()];
            if (objectArray.length != 3) {
                throw new InvalidQuery("setof requires 3 arguments");
            }
            int n = 0;
            while (n < oWL.arity()) {
                objectArray[n] = this.formatQuery(oWL.arg(n), serverMD, sigMap);
                ++n;
            }
            return new Structure((Object)"xsetof", objectArray);
        }
        if (oWL.named("RootCtx.edbForm")) {
            Object[] objectArray = new Object[2];
            if (objectArray.length != 2) {
                throw new InvalidQuery("edbForm requires 2 arguments");
            }
            objectArray[0] = this.formatQuery(oWL.arg(0), serverMD, sigMap);
            objectArray[1] = this.formatQuery(oWL.arg(1), serverMD, sigMap);
            return new Structure((Object)"RootCtx.edbForm", objectArray);
        }
        if (oWL.named("holdsIn")) {
            Object object;
            Object[] objectArray = this.holdsIn(oWL, serverMD, sigMap);
            if (objectArray.length > 1) {
                String string = "Cannot handle multi-part holdsIn queries: " + oWL;
                int n = 0;
                while (n < objectArray.length) {
                    string = string + "\n" + objectArray[n];
                    ++n;
                }
                throw new InvalidQuery(string);
            }
            if (serverMD.outTime == null && !(oWL.arg(1) instanceof IVar)) {
                object = objectArray[0];
            } else {
                try {
                    object = new Structure(",", objectArray[0], new Structure("=", Time.owl2xsb(oWL.arg(0)), serverMD.outTime));
                }
                catch (SyntaxError syntaxError) {
                    throw new StorageManagerFault("Unexpected time syntax error", syntaxError);
                }
            }
            serverMD.outTime = null;
            return object;
        }
        if (oWL instanceof IVar) {
            return new Variable(oWL.name());
        }
        if (oWL instanceof Symbol) {
            return this.formatSymbol((Symbol)oWL);
        }
        if (oWL instanceof SVar) {
            throw new Error("Can't handle SVars yet");
        }
        if (oWL instanceof Form) {
            Object[] objectArray = this.formatForm((Form)oWL, serverMD, sigMap);
            return objectArray[0];
        }
        if (oWL instanceof QuotedString) {
            return new Structure((Object)"qstr", ((QuotedString)oWL).text());
        }
        throw new Error("Unknown OWL " + oWL);
    }

    Object formatTime(Object object) throws InvalidQuery {
        if (object instanceof IVar) {
            return new Variable(((IVar)object).name);
        }
        if (object instanceof Date) {
            return Time.java2xsb((Date)object);
        }
        if (object == null) {
            return new Variable();
        }
        throw new InvalidQuery("Invalid time object " + object);
    }

    public Answers query(OWL oWL, IVar[] iVarArray, int n) throws QueryFailure {
        Object object = this.formatQuery(oWL, queryMD, this.idbSigs);
        int n2 = iVarArray.length;
        if (XSBStorageManager.queryMD.outAID instanceof Variable) {
            ++n2;
        }
        Variable[] variableArray = new Variable[n2];
        int n3 = 0;
        while (n3 < iVarArray.length) {
            variableArray[n3] = new Variable(iVarArray[n3].name());
            ++n3;
        }
        if (XSBStorageManager.queryMD.outAID instanceof Variable) {
            variableArray[n2 - 1] = (Variable)XSBStorageManager.queryMD.outAID;
        }
        return this.queryDB(object, variableArray);
    }

    public void insert(OWL oWL, ServerMD serverMD, SMTransaction sMTransaction) throws StorageManagerFault, UpdateFailure {
        try {
            if (serverMD == null) {
                serverMD = queryMD;
            }
            Object[] objectArray = this.formatForm(oWL, serverMD, this.edbSigs);
            int n = 0;
            while (n < objectArray.length) {
                this.insertDB(objectArray[n], sMTransaction);
                ++n;
            }
        }
        catch (InvalidQuery invalidQuery) {
            throw new UpdateFailure(invalidQuery);
        }
    }

    public void delete(OWL oWL, ServerMD serverMD, SMTransaction sMTransaction) throws StorageManagerFault, UpdateFailure {
        try {
            if (serverMD == null) {
                serverMD = queryMD;
            }
            Object[] objectArray = this.formatForm(oWL, serverMD, this.edbSigs);
            int n = 0;
            while (n < objectArray.length) {
                this.deleteDB(objectArray[n], sMTransaction);
                ++n;
            }
        }
        catch (InvalidQuery invalidQuery) {
            throw new UpdateFailure(invalidQuery);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SleepycatTransaction
    extends SMTransaction {
        private int txn = 0;
        private boolean begun = false;

        SleepycatTransaction(SleepycatTransaction sleepycatTransaction) throws StorageManagerFault {
        }

        public int txn() throws StorageManagerFault {
            if (!this.begun) {
                XSBStorageManager.this.xsb.jtop_term(new Structure((Object)"begin", new Variable("X")), 1);
                XSBStorageManager.this.xsb.xsb_query();
                this.txn = XSBStorageManager.this.xsb.p2j_int(XSBStorageManager.this.xsb.p2p_arg(XSBStorageManager.this.xsb.reg_term(1), 1));
                XSBStorageManager.this.xsb.xsb_close_query();
                this.begun = true;
            }
            return this.txn;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof SleepycatTransaction) {
                try {
                    return ((SleepycatTransaction)object).txn() == this.txn();
                }
                catch (StorageManagerFault storageManagerFault) {
                    // empty catch block
                }
            }
            return false;
        }

        public int hashCode() {
            try {
                return this.txn();
            }
            catch (StorageManagerFault storageManagerFault) {
                return this.txn;
            }
        }

        public String toString() {
            try {
                return "[SleepycatTransaction " + this.txn() + "]";
            }
            catch (StorageManagerFault storageManagerFault) {
                return "[SleepycatTransaction none]";
            }
        }
    }

    class SigMap
    extends com.kb.server.sm.SigMap {
        SigMap(String string) {
            super(string);
        }

        protected Structure struct(String string, Object object) {
            return new Structure((Object)string, object);
        }

        Structure struct(String string, Object object, Object object2) {
            return new Structure(string, object, object2);
        }

        public Structure[] signatures(Object object, int n) throws StorageManagerFault {
            try {
                Object object2;
                Vector<Structure> vector = new Vector<Structure>();
                Variable variable = new Variable("X");
                Variable variable2 = new Variable("Arity");
                Answers answers = XSBStorageManager.this.queryDB(new Structure((Object)"kbprop", new Object[]{variable, variable2, this.type, object, new Integer(n)}), new Variable[]{variable, variable2});
                int n2 = 0;
                while (n2 < answers.numAnswers()) {
                    Structure structure;
                    object2 = (String)answers.answer(n2, 0);
                    int n3 = (Integer)answers.answer(n2, 1);
                    Variable variable3 = new Variable("C");
                    Object[] objectArray = new Object[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        structure = new Structure((Object)"kbarg", new Object[]{object2, new Integer(n3), new Integer(n4 + 1), variable3});
                        Answers answers2 = XSBStorageManager.this.queryDB(structure, new Variable[]{variable3});
                        if (answers2.numAnswers() == 0) {
                            System.err.println("Error: no answers for " + structure);
                            objectArray[n4] = "top";
                        } else {
                            objectArray[n4] = answers2.answer(0, 0);
                        }
                        ++n4;
                    }
                    structure = new Structure(object2, objectArray);
                    vector.addElement(structure);
                    ++n2;
                }
                object2 = new Structure[vector.size()];
                vector.copyInto((Object[])object2);
                return object2;
            }
            catch (QueryFailure queryFailure) {
                throw new StorageManagerFault("Could not find implemenation fro " + object + "/" + n, queryFailure);
            }
        }
    }
}

