/*
 * Decompiled with CFR 0.152.
 */
package com.kb.server.sm;

import com.kb.client.StorageManagerFault;
import com.kb.server.sm.CorruptLogFault;
import com.kb.xsb.List;
import com.kb.xsb.Structure;
import com.kb.xsb.Variable;
import com.kb.xsb.XsbConstants;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class SymbolTable
implements XsbConstants {
    Hashtable lookup = new Hashtable();
    Vector symbols = new Vector();
    DataOutput out;
    String file;

    public SymbolTable(String string) throws StorageManagerFault {
        try {
            this.file = string;
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(fileInputStream));
            int n = 0;
            try {
                while (true) {
                    int n2 = dataInputStream.readInt();
                    String string2 = dataInputStream.readUTF();
                    byte by = dataInputStream.readByte();
                    FunctorArity functorArity = new FunctorArity(string2, by);
                    this.lookup.put(functorArity, new Integer(n2));
                    if (this.symbols.size() < n2 + 1) {
                        this.symbols.setSize(n2 + 1);
                    }
                    this.symbols.setElementAt(functorArity, n2);
                    ++n;
                }
            }
            catch (EOFException eOFException) {
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("&&& Establishing new symbol table " + string);
        }
        catch (IOException iOException) {
            throw new CorruptLogFault(string, iOException.getMessage());
        }
        try {
            this.out = new DataOutputStream(new FileOutputStream(string, true));
        }
        catch (IOException iOException) {
            throw new CorruptLogFault(string, iOException.getMessage());
        }
    }

    public FunctorArity symbol(int n) {
        return (FunctorArity)this.symbols.elementAt(n);
    }

    public int symbol(String string, int n) throws IOException {
        FunctorArity functorArity = new FunctorArity(string, n);
        Integer n2 = (Integer)this.lookup.get(functorArity);
        if (n2 == null) {
            int n3 = this.symbols.size();
            this.symbols.addElement(functorArity);
            this.lookup.put(functorArity, new Integer(n3));
            this.out.writeInt(n3);
            this.out.writeUTF(string);
            this.out.writeByte(n);
            return n3;
        }
        return n2;
    }

    public Object read(DataInput dataInput) throws IOException, StorageManagerFault {
        byte by = dataInput.readByte();
        switch (by) {
            case 1: {
                int n = dataInput.readInt();
                FunctorArity functorArity = this.symbol(n);
                if (functorArity == null) {
                    throw new CorruptLogFault(this.file, "Undefined symbol " + n);
                }
                Object[] objectArray = new Object[functorArity.arity];
                int n2 = 0;
                while (n2 < objectArray.length) {
                    objectArray[n2] = this.read(dataInput);
                    ++n2;
                }
                return new Structure((Object)functorArity.functor, objectArray);
            }
            case 9: {
                Object object = this.read(dataInput);
                int n = dataInput.readInt();
                Object[] objectArray = new Object[n];
                int n3 = 0;
                while (n3 < objectArray.length) {
                    objectArray[n3] = this.read(dataInput);
                    ++n3;
                }
                return new Structure(object, objectArray);
            }
            case 5: {
                int n = dataInput.readInt();
                FunctorArity functorArity = this.symbol(n);
                if (functorArity == null) {
                    throw new CorruptLogFault(this.file, "Undefined constant " + n);
                }
                return functorArity.functor;
            }
            case 2: {
                return new Integer(dataInput.readInt());
            }
            case 6: {
                return new Float(dataInput.readFloat());
            }
            case 3: {
                return new List(this.read(dataInput), this.read(dataInput));
            }
            case 0: {
                int n = dataInput.readInt();
                FunctorArity functorArity = this.symbol(n);
                if (functorArity == null) {
                    throw new CorruptLogFault(this.file, "Undefined variable " + n);
                }
                return new Variable(functorArity.functor);
            }
            case 8: {
                return null;
            }
        }
        throw new CorruptLogFault(this.file, "Undefined data type " + by);
    }

    public void write(Object object, DataOutput dataOutput) throws IOException, StorageManagerFault {
        if (object instanceof Structure) {
            int n;
            Structure structure = (Structure)object;
            if (structure.functor() instanceof String) {
                dataOutput.writeByte(1);
                n = this.symbol((String)structure.functor(), structure.arity());
                dataOutput.writeInt(n);
            } else {
                dataOutput.writeByte(9);
                this.write(structure.functor(), dataOutput);
                dataOutput.writeInt(structure.arity());
            }
            n = 0;
            while (n < structure.arity()) {
                this.write(structure.arg(n), dataOutput);
                ++n;
            }
        } else if (object instanceof String) {
            dataOutput.writeByte(5);
            int n = this.symbol((String)object, -1);
            dataOutput.writeInt(n);
        } else if (object instanceof Integer) {
            dataOutput.writeByte(2);
            dataOutput.writeInt((Integer)object);
        } else if (object instanceof Float) {
            dataOutput.writeByte(6);
            dataOutput.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Variable) {
            dataOutput.writeByte(0);
            int n = this.symbol(object.toString(), -1);
            dataOutput.writeInt(n);
        } else if (object instanceof List) {
            dataOutput.writeByte(3);
            this.write(((List)object).car, dataOutput);
            this.write(((List)object).cdr, dataOutput);
        } else if (object == null) {
            dataOutput.writeByte(8);
        } else {
            throw new StorageManagerFault("Unrecognized object " + object);
        }
    }

    class FunctorArity {
        String functor;
        int arity;

        FunctorArity(String string, int n) {
            this.functor = string;
            this.arity = n;
        }

        public int hashCode() {
            return this.functor.hashCode() + this.arity;
        }

        public boolean equals(Object object) {
            if (object instanceof FunctorArity) {
                FunctorArity functorArity = (FunctorArity)object;
                return this.arity == functorArity.arity && this.functor.equals(functorArity.functor);
            }
            return false;
        }
    }
}

