/*
 * Decompiled with CFR 0.152.
 */
package com.kb.server.sm;

import com.kb.client.StorageManagerFault;
import com.kb.server.sm.LogEntry;
import com.kb.server.sm.Operation;
import com.kb.server.sm.SMTransaction;
import com.kb.server.sm.UnbegunTransactionFault;
import java.util.Enumeration;
import java.util.Hashtable;

public class Log {
    private Hashtable log = new Hashtable();
    private Hashtable topLevelTransactions = new Hashtable();

    public boolean isEmpty() {
        return this.log.isEmpty();
    }

    public Enumeration transactions() {
        return this.log.keys();
    }

    LogEntry get(SMTransaction sMTransaction) {
        return (LogEntry)this.log.get(sMTransaction);
    }

    public void begin(SMTransaction sMTransaction, SMTransaction sMTransaction2) throws StorageManagerFault {
        LogEntry logEntry = new LogEntry();
        if (sMTransaction2 == null) {
            this.topLevelTransactions.put(sMTransaction, sMTransaction);
        } else {
            this.put(sMTransaction2, logEntry);
        }
        this.log.put(sMTransaction, logEntry);
    }

    public void commit(SMTransaction sMTransaction) {
        this.topLevelTransactions.remove(sMTransaction);
        this.log.remove(sMTransaction);
    }

    public void rollback(SMTransaction sMTransaction) {
        LogEntry logEntry = (LogEntry)this.log.get(sMTransaction);
        logEntry.erase();
        this.topLevelTransactions.remove(sMTransaction);
        this.log.remove(sMTransaction);
    }

    public void put(SMTransaction sMTransaction, Operation operation) throws UnbegunTransactionFault {
        LogEntry logEntry = (LogEntry)this.log.get(sMTransaction);
        if (logEntry == null) {
            throw new UnbegunTransactionFault(sMTransaction);
        }
        logEntry.append(operation);
    }

    public boolean isTopLevel(SMTransaction sMTransaction) {
        return this.topLevelTransactions.containsKey(sMTransaction);
    }
}

