/*
 * Decompiled with CFR 0.152.
 */
package com.kb.server.sm;

import com.kb.client_server.ArchiveException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class DbArchive {
    public static void main(String[] stringArray) {
        try {
            DbArchive.archive(stringArray[0], "c:/temp/foo.zip");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void archive(String string, String string2) throws ArchiveException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);
            DbArchive.addToArchive(string, ".", zipOutputStream);
            zipOutputStream.close();
            System.out.println("Done archiving.");
        }
        catch (Throwable throwable) {
            throw new ArchiveException(throwable.toString());
        }
    }

    static void addToArchive(String string, String string2, ZipOutputStream zipOutputStream) throws IOException {
        byte[] byArray = new byte[0x100000];
        File file = new File(string + "/" + string2);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                DbArchive.addToArchive(string, string2 + "/" + stringArray[n], zipOutputStream);
                ++n;
            }
        } else {
            int n;
            System.out.println(string2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string + "/" + string2));
            zipOutputStream.putNextEntry(new ZipEntry(string2));
            while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
        }
    }

    public static void restore(String string, String string2) throws ArchiveException {
        try {
            new File(string).mkdirs();
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string2));
            byte[] byArray = new byte[0x100000];
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                int n;
                File file = new File(string + "/" + zipEntry.getName());
                System.out.println(zipEntry.getName());
                if (file.exists()) {
                    file.delete();
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string + "/" + zipEntry.getName()));
                while ((n = zipInputStream.read(byArray)) != -1) {
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                }
                ((OutputStream)bufferedOutputStream).close();
                zipEntry = zipInputStream.getNextEntry();
            }
            System.out.println("Done restoring.");
        }
        catch (Throwable throwable) {
            throw new ArchiveException(throwable.toString());
        }
    }
}

