/*
 * Decompiled with CFR 0.152.
 */
package com.kb.server;

import com.kb.client.BindingProblem;
import com.kb.client.Database;
import com.kb.client.DatabaseFailure;
import com.kb.client.Deadlock;
import com.kb.client.Isolation;
import com.kb.client.LockUnavailable;
import com.kb.client.QueryFailure;
import com.kb.client.StorageManagerFault;
import com.kb.client.Timeout;
import com.kb.client.UpdateFailure;
import com.kb.client_server.Answers;
import com.kb.client_server.ConnectionID;
import com.kb.client_server.ICStatus;
import com.kb.client_server.ICViolation;
import com.kb.client_server.LockInfo;
import com.kb.client_server.Request;
import com.kb.kbddutil.FileNamer;
import com.kb.kbddutil.KBProperties;
import com.kb.license.Verify;
import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import com.kb.server.Administration;
import com.kb.server.ConnectionProperties;
import com.kb.server.ICManager;
import com.kb.server.LockRequest;
import com.kb.server.Locking;
import com.kb.server.OIDPool;
import com.kb.server.ServerMD;
import com.kb.server.ServerUtils;
import com.kb.server.Transaction;
import com.kb.server.sm.SMTransaction;
import com.kb.server.sm.StorageManager;
import com.kb.server.sm.ddb.XSBStorageManager;
import com.kb.xsb.OWL2XSB;
import com.kb.xsb.Structure;
import com.kb.xsb.Variable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Server {
    public static final Object adminLock = "Adminstrative lock";
    public static final Object globalLock = "Global lock";
    boolean ready = false;
    boolean failed = false;
    OIDPool oidpool = new OIDPool();
    StorageManager sm;
    ConnectionID myConnectionID;
    Administration admin = new Administration();
    Locking locking = new Locking(this);
    ICManager icManager = new ICManager(this);
    public boolean heartbeat = KBProperties.getBoolean("com.kb.heartbeat");
    public Database database;
    PrintWriter trace;
    boolean readOnly;
    Map passwords;
    boolean checkBindingPattern = false;

    public Server(Database database, boolean bl) throws StorageManagerFault {
        this.openLog();
        if (this.getLicense()) {
            this.database = database;
            this.readOnly = bl;
            ((Hashtable)database).put("startTime", new Date().toString());
        }
    }

    boolean getLicense() {
        boolean bl = false;
        File[] fileArray = Verify.getLicenseLocations();
        int n = 0;
        while (n < fileArray.length && !bl) {
            try {
                Verify.findLicense(fileArray[n]);
                bl = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        if (!bl) {
            System.exit(-7);
        }
        return true;
    }

    public void initializeStorageManager() throws StorageManagerFault {
        try {
            Server server = this;
            synchronized (server) {
                if (this.ready) {
                    return;
                }
                String string = this.database.getProperty("storageManagerType", "ddb");
                if (string.equals("ddb")) {
                    PrintStream printStream = System.out;
                    synchronized (printStream) {
                        this.sm = new XSBStorageManager(this.database, this.readOnly);
                    }
                    if (this.sm.queryDB("_kb_oms", new Variable[0]).yes()) {
                        ((Hashtable)this.database).put("isOMS", "true");
                    } else {
                        ((Hashtable)this.database).put("isOMS", "false");
                    }
                } else if (string.equals("oracle")) {
                    this.sm = (StorageManager)Class.forName("com.kb.server.sm.oracle.OracleStorageManager").getConstructors()[0].newInstance(this.database);
                } else {
                    throw new StorageManagerFault("Unknown database type: " + string);
                }
                this.trace("Connecting");
                this.myConnectionID = new ConnectionID();
                this.admin.addConnection(this.myConnectionID);
                this.admin.getConnection(this.myConnectionID).setUser("The Server");
                this.ready = true;
                this.trace("Server initialized");
                this.notifyAll();
            }
        }
        catch (Throwable throwable) {
            this.trace(throwable);
            if (throwable instanceof StorageManagerFault) {
                throw (StorageManagerFault)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new StorageManagerFault("Unknown error", throwable);
        }
    }

    public ConnectionID connect(Properties properties) throws DatabaseFailure {
        this.waitUntilReady();
        ConnectionID connectionID = new ConnectionID();
        this.admin.addConnection(connectionID);
        ((Hashtable)properties).putAll(this.database);
        return connectionID;
    }

    public void close() {
        this.trace("Close called on server");
    }

    public void close(ConnectionID connectionID) throws DatabaseFailure {
        Transaction transaction = this.admin.getConnection(connectionID).getTransaction();
        if (transaction != null) {
            this.rollback(connectionID);
        }
        this.admin.removeConnection(connectionID);
    }

    public void stop() {
        if (this.heartbeat) {
            this.trace("Shutting down server");
        }
        try {
            if (this.sm != null) {
                this.sm.close();
            }
        }
        catch (Exception exception) {
            this.trace(exception);
        }
    }

    public void archive(String string) throws DatabaseFailure {
        try {
            this.sm.archive(string);
        }
        catch (StorageManagerFault storageManagerFault) {
            throw this.fail(storageManagerFault);
        }
    }

    public void restore(String string) throws DatabaseFailure {
        if (this.readOnly) {
            throw new DatabaseFailure("Cannot restore read-only database");
        }
        try {
            this.sm.restore(string);
        }
        catch (StorageManagerFault storageManagerFault) {
            throw this.fail(storageManagerFault);
        }
    }

    public Object create(ConnectionID connectionID, Object object, boolean bl, Isolation isolation) throws UpdateFailure, LockUnavailable {
        Object object2 = this.oidpool.next();
        this.insert(connectionID, new Form(OWL2XSB.makeOWL(object), OWL2XSB.makeOWL(object2)), bl, isolation);
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICStatus insert(ConnectionID connectionID, Object object, boolean bl, Isolation isolation) throws UpdateFailure, LockUnavailable {
        ICStatus iCStatus;
        if (this.readOnly) {
            throw new UpdateFailure("Cannot insert into read-only database");
        }
        Request request = this.admin.addRequest(connectionID, "Insert", object);
        this.waitUntilReady();
        try {
            try {
                request.setCurrentState("Waiting on Locks");
                this.locking.obtainLocks(globalLock, this.getTransaction(connectionID), true, isolation);
                request.setCurrentState("Executing insert");
                this.getTransaction(connectionID).setICs(null);
                this.sm.insertDB(object, this.getSMTransaction(connectionID));
                request.setCurrentState("Inserted");
                ICStatus iCStatus2 = bl ? this.commit(connectionID) : ICStatus.OK;
                iCStatus = iCStatus2;
                Object var9_9 = null;
            }
            catch (StorageManagerFault storageManagerFault) {
                throw this.fail(storageManagerFault);
            }
            this.admin.removeRequest(request);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.admin.removeRequest(request);
            this.locking.freeShortLocks(this.getTransaction(connectionID));
            throw throwable;
        }
        this.locking.freeShortLocks(this.getTransaction(connectionID));
        return iCStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICStatus delete(ConnectionID connectionID, Object object, boolean bl, Isolation isolation) throws UpdateFailure, LockUnavailable {
        ICStatus iCStatus;
        if (this.readOnly) {
            throw new UpdateFailure("Cannot delete from read-only database");
        }
        Request request = this.admin.addRequest(connectionID, "Delete", object);
        this.waitUntilReady();
        try {
            try {
                request.setCurrentState("Waiting on Locks");
                this.locking.obtainLocks(globalLock, this.getTransaction(connectionID), true, isolation);
                request.setCurrentState("Executing delete");
                this.getTransaction(connectionID).setICs(null);
                this.sm.deleteDB(object, this.getSMTransaction(connectionID));
                request.setCurrentState("Deleted");
                ICStatus iCStatus2 = bl ? this.commit(connectionID) : ICStatus.OK;
                iCStatus = iCStatus2;
                Object var9_9 = null;
            }
            catch (StorageManagerFault storageManagerFault) {
                throw this.fail(storageManagerFault);
            }
            this.admin.removeRequest(request);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.admin.removeRequest(request);
            this.locking.freeShortLocks(this.getTransaction(connectionID));
            throw throwable;
        }
        this.locking.freeShortLocks(this.getTransaction(connectionID));
        return iCStatus;
    }

    public ICStatus checkIntegrityConstraints(ConnectionID connectionID) throws DatabaseFailure {
        try {
            this.waitUntilReady();
            Transaction transaction = this.getTransaction(connectionID);
            if (transaction.getICs() == null) {
                ICViolation[] iCViolationArray = this.sm.runIntegrityConstraints(this.getSMTransaction(connectionID));
                boolean bl = true;
                int n = 0;
                while (n < iCViolationArray.length) {
                    if (ICManager.isHardIC(iCViolationArray[n])) {
                        bl = false;
                    }
                    ++n;
                }
                transaction.setICs(new ICStatus(bl, iCViolationArray));
            }
            return transaction.getICs();
        }
        catch (QueryFailure queryFailure) {
            throw this.fail(queryFailure);
        }
    }

    public ICStatus commit(ConnectionID connectionID) throws DatabaseFailure {
        this.waitUntilReady();
        ICStatus iCStatus = ICStatus.OK;
        if (!this.readOnly) {
            iCStatus = this.checkIntegrityConstraints(connectionID);
        }
        if (iCStatus.databaseOK()) {
            if (!this.readOnly) {
                this.icManager.insertICs(iCStatus.violations(), connectionID);
                this.sm.commit(this.getSMTransaction(connectionID));
            }
            this.endTransaction(connectionID);
        }
        return iCStatus;
    }

    public void rollback(ConnectionID connectionID) throws DatabaseFailure {
        try {
            try {
                SMTransaction sMTransaction;
                if (!this.readOnly && (sMTransaction = this.admin.getConnection(connectionID).getSMTransaction()) != null) {
                    this.sm.rollback(sMTransaction);
                }
                this.endTransaction(connectionID);
            }
            catch (StorageManagerFault storageManagerFault) {
                throw this.fail(storageManagerFault);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            throw throwable;
        }
    }

    public Answers extent(ConnectionID connectionID, Object object, boolean bl, Isolation isolation) throws QueryFailure {
        return this.extent(connectionID, OWL2XSB.makeOWL(object), bl, isolation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void waitUntilReady() throws DatabaseFailure {
        if (this.failed) {
            throw new DatabaseFailure("Request rejected due to database failure.  The database must be shut down.");
        }
        Server server = this;
        synchronized (server) {
            while (!this.ready) {
                try {
                    this.trace("Waiting for the storage manager to initialize...");
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public String[] useridList(ConnectionID connectionID) throws QueryFailure, LockUnavailable {
        Request request = this.admin.addRequest(connectionID, "Get Users", "");
        try {
            request.setCurrentState("Waiting on locks");
            this.locking.obtainLocks(adminLock, this.getTransaction(connectionID), false, Isolation.SERIALIZABLE);
            Set set = this.getPasswords().keySet();
            ArrayList arrayList = new ArrayList();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            String[] stringArray2 = stringArray;
            Object var9_8 = null;
            this.admin.removeRequest(request);
            this.locking.freeLocks(this.getTransaction(connectionID));
            return stringArray2;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.admin.removeRequest(request);
            this.locking.freeLocks(this.getTransaction(connectionID));
            throw throwable;
        }
    }

    Map getPasswords() throws DatabaseFailure, QueryFailure {
        this.waitUntilReady();
        if (this.passwords == null) {
            IVar iVar = new IVar("USERID");
            IVar iVar2 = new IVar("PASSWORD");
            this.sm.query(new Form("dynamic", (OWL)new Form("password", (OWL)iVar, (OWL)iVar2)), new IVar[0], Integer.MAX_VALUE);
            this.passwords = new HashMap();
            Form form = new Form("password", (OWL)iVar, (OWL)iVar2);
            Answers answers = this.sm.query(form, new IVar[]{iVar, iVar2}, Integer.MAX_VALUE);
            int n = 0;
            while (n < answers.numAnswers()) {
                this.passwords.put(answers.answer(n, 0), answers.answer(n, 1));
                ++n;
            }
        }
        return this.passwords;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Answers query(ConnectionID connectionID, Object object, Variable[] variableArray, int n, boolean bl, Isolation isolation) throws QueryFailure, LockUnavailable {
        Answers answers;
        Request request = this.admin.addQuery(connectionID, object);
        this.waitUntilReady();
        Object object2 = object;
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        try {
            try {
                request.setCurrentState("Waiting on Locks");
                this.locking.obtainLocks(globalLock, this.getTransaction(connectionID), false, isolation);
                request.setCurrentState("Executing low-level query");
                answers = this.sm.queryDB(object2, variableArray, n);
                Object var11_11 = null;
                this.admin.removeRequest(request);
                if (bl) {
                    this.endTransaction(connectionID);
                    return answers;
                }
            }
            catch (Timeout timeout) {
                this.trace.println("Timeout querying " + object);
                throw timeout;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.admin.removeRequest(request);
            if (bl) {
                this.endTransaction(connectionID);
                throw throwable;
            }
            this.locking.freeShortLocks(this.getTransaction(connectionID));
            throw throwable;
        }
        this.locking.freeShortLocks(this.getTransaction(connectionID));
        return answers;
    }

    public LockInfo[] locks() {
        return this.locking.locks();
    }

    public Transaction getTransaction(ConnectionID connectionID) {
        ConnectionProperties connectionProperties = this.admin.getConnection(connectionID);
        Transaction transaction = connectionProperties.getTransaction();
        if (transaction == null) {
            connectionProperties.setTransaction(new Transaction(this));
            transaction = connectionProperties.getTransaction();
        }
        return transaction;
    }

    public SMTransaction getSMTransaction(ConnectionID connectionID) throws StorageManagerFault {
        ConnectionProperties connectionProperties = this.admin.getConnection(connectionID);
        SMTransaction sMTransaction = connectionProperties.getSMTransaction();
        if (sMTransaction == null) {
            sMTransaction = this.sm.beginTransaction(null);
            connectionProperties.setSMTransaction(sMTransaction);
        }
        return sMTransaction;
    }

    public void endTransaction(ConnectionID connectionID) {
        this.locking.freeLocks(this.getTransaction(connectionID));
        this.admin.getConnection(connectionID).setTransaction(null);
        this.admin.getConnection(connectionID).setSMTransaction(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Answers query(ConnectionID connectionID, OWL oWL, IVar[] iVarArray, int n, boolean bl, Isolation isolation) throws QueryFailure, LockUnavailable {
        Answers answers;
        Request request = this.admin.addQuery(connectionID, oWL);
        this.waitUntilReady();
        this.checkBindingPattern(oWL, new HashSet());
        try {
            request.setCurrentState("Waiting on Locks");
            this.locking.obtainLocks(globalLock, this.getTransaction(connectionID), false, isolation);
            request.setCurrentState("Asking query");
            answers = this.sm.query(oWL, iVarArray, n, this.getSMTransaction(connectionID));
            Object var10_9 = null;
            this.admin.removeRequest(request);
            if (bl) {
                this.endTransaction(connectionID);
                return answers;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.admin.removeRequest(request);
            if (bl) {
                this.endTransaction(connectionID);
                throw throwable;
            }
            this.locking.freeShortLocks(this.getTransaction(connectionID));
            throw throwable;
        }
        this.locking.freeShortLocks(this.getTransaction(connectionID));
        return answers;
    }

    public void checkBindingPattern(OWL oWL, Set set) throws QueryFailure {
        if (ServerUtils.isInternallyDefinedPredicate(oWL.name())) {
            return;
        }
        if (oWL instanceof Symbol) {
            return;
        }
        if (!(oWL instanceof Form)) {
            throw new QueryFailure("Invalid query: " + oWL + "; expected a Form");
        }
        Form form = (Form)oWL;
        if (oWL.named("and")) {
            int n = 0;
            while (n < form.arity()) {
                this.checkBindingPattern(form.arg(n), set);
                ++n;
            }
        } else {
            if (oWL.named("or")) {
                return;
            }
            if (oWL.named("not")) {
                return;
            }
            if (oWL.named("findall")) {
                return;
            }
            if (oWL.named("setof")) {
                return;
            }
            this.checkBindingPattern((Form)oWL, set);
        }
    }

    public void checkBindingPattern(Form form, Set set) throws QueryFailure {
        IVar iVar;
        IVar iVar2;
        if (!this.checkBindingPattern) {
            return;
        }
        OWL oWL = form.functor();
        Form form2 = new Form("RootCtx.argMode", oWL, (OWL)(iVar2 = new IVar("ArgNum")), (OWL)(iVar = new IVar("Mode")));
        Answers answers = this.sm.query(form2, new IVar[]{iVar2, iVar}, Integer.MAX_VALUE);
        if (answers.numAnswers() == 0) {
            // empty if block
        }
        int n = 0;
        while (n < answers.numAnswers()) {
            Integer n2 = (Integer)answers.answer(n, 0);
            String string = (String)answers.answer(n, 1);
            OWL oWL2 = form.arg(n2 - 1);
            if (!string.equals("RootCtx.anyMC")) {
                if (string.equals("RootCtx.boundMC")) {
                    if (oWL2 instanceof IVar && !set.contains(oWL2)) {
                        throw new BindingProblem("Argument " + (n + 1) + " of " + oWL + " must be bound");
                    }
                } else if (string.equals("RootCtx.groundMC")) {
                    if (oWL2 instanceof IVar && !set.contains(oWL2)) {
                        throw new BindingProblem("Argument " + (n + 1) + " of " + oWL + " must be ground");
                    }
                } else if (string.equals("RootCtx.freeMC")) {
                    if (!(oWL2 instanceof IVar) || set.contains(oWL2)) {
                        throw new BindingProblem("Argument " + (n + 1) + " of " + oWL + " must be free");
                    }
                } else if (!string.equals("RootCtx.nonBindingMC")) {
                    throw new DatabaseFailure("Unrecognized binding mode " + string);
                }
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < form.arity()) {
            if (form.arg(n3) instanceof IVar) {
                set.add(form.arg(n3));
            }
            ++n3;
        }
    }

    public OWL create(ConnectionID connectionID, OWL oWL, boolean bl, Isolation isolation) throws UpdateFailure, LockUnavailable {
        this.waitUntilReady();
        Symbol symbol = new Symbol(this.oidpool.next().toString());
        this.insert(connectionID, new Form(oWL, (OWL)symbol), bl, isolation);
        return symbol;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICStatus insert(ConnectionID connectionID, OWL oWL, boolean bl, Isolation isolation) throws DatabaseFailure, UpdateFailure, LockUnavailable {
        ICStatus iCStatus;
        if (this.readOnly) {
            throw new UpdateFailure("Cannot insert into read-only database");
        }
        Request request = this.admin.addRequest(connectionID, "Insert", oWL);
        this.waitUntilReady();
        try {
            try {
                request.setCurrentState("Waiting on Locks");
                this.locking.obtainLocks(globalLock, this.getTransaction(connectionID), true, isolation);
                request.setCurrentState("Executing insert");
                ServerMD serverMD = new ServerMD();
                serverMD.aid = OWL2XSB.convertParseStructure(this.oidpool.next());
                this.sm.insert(oWL, serverMD, this.getSMTransaction(connectionID));
                this.getTransaction(connectionID).setICs(null);
                ICStatus iCStatus2 = bl ? this.commit(connectionID) : ICStatus.OK;
                iCStatus = iCStatus2;
                Object var10_10 = null;
                this.admin.removeRequest(request);
            }
            catch (QueryFailure queryFailure) {
                throw new UpdateFailure(queryFailure);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.admin.removeRequest(request);
            this.locking.freeShortLocks(this.getTransaction(connectionID));
            throw throwable;
        }
        this.locking.freeShortLocks(this.getTransaction(connectionID));
        return iCStatus;
    }

    public ICStatus delete(ConnectionID connectionID, OWL oWL, boolean bl, Isolation isolation) throws DatabaseFailure, UpdateFailure, LockUnavailable {
        ICStatus iCStatus;
        if (this.readOnly) {
            throw new UpdateFailure("Cannot delete from read-only database");
        }
        Request request = this.admin.addRequest(connectionID, "Delete", oWL);
        this.waitUntilReady();
        try {
            request.setCurrentState("Waiting on Locks");
            this.locking.obtainLocks(globalLock, this.getTransaction(connectionID), true, isolation);
            request.setCurrentState("Executing delete");
            this.getTransaction(connectionID).setICs(null);
            this.sm.delete(oWL, null, this.getSMTransaction(connectionID));
            ICStatus iCStatus2 = bl ? this.commit(connectionID) : ICStatus.OK;
            iCStatus = iCStatus2;
            Object var9_8 = null;
            this.admin.removeRequest(request);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.admin.removeRequest(request);
            this.locking.freeShortLocks(this.getTransaction(connectionID));
            throw throwable;
        }
        this.locking.freeShortLocks(this.getTransaction(connectionID));
        return iCStatus;
    }

    ICStatus checkSignature(OWL oWL) throws QueryFailure, LockUnavailable {
        return this.checkSignature(oWL, this.myConnectionID);
    }

    ICStatus checkSignature(OWL oWL, ConnectionID connectionID) throws QueryFailure, LockUnavailable {
        Serializable serializable;
        if (oWL.named("holdsIn") && oWL.arity() == 2) {
            return this.checkSignature(oWL.arg(1), connectionID);
        }
        if (ServerUtils.isInternallyDefinedPredicate(oWL.name())) {
            return ICStatus.OK;
        }
        if (!(oWL instanceof Form)) {
            throw new QueryFailure("Invalid form " + oWL);
        }
        Form form = (Form)oWL;
        OWL oWL2 = form.functor();
        IVar iVar = new IVar("Type");
        IVar iVar2 = new IVar("N");
        Answers answers = this.query(connectionID, new Form("RootCtx.argProp", oWL2, (OWL)iVar2, (OWL)iVar), new IVar[]{iVar, iVar2}, Integer.MAX_VALUE, false, Isolation.READ_UNCOMMITTED);
        ArrayList<ICViolation> arrayList = new ArrayList<ICViolation>();
        if (answers.numAnswers() != form.arity()) {
            throw new QueryFailure("Incorrect number of arguments to " + oWL2 + ": " + answers.numAnswers() + " required");
        }
        int n = 0;
        while (n < answers.numAnswers()) {
            int n2;
            if (!answers.answer(n, 0).equals("RootCtx.Top") && (n2 = this.query(connectionID, (OWL)(serializable = new Form(OWL2XSB.makeOWL(answers.answer(n, 0)), form.arg(this.getInt(answers, n, 1) - 1))), new IVar[0], 1, false, Isolation.READ_UNCOMMITTED).numAnswers()) == 0) {
                Structure structure = (Structure)OWL2XSB.toXSB((Form)serializable);
                ICViolation iCViolation = new ICViolation("Type signature violation: arg " + this.getInt(answers, n, 1) + " of " + oWL2 + " must be a " + answers.answer(n, 0), "hard", "typecheck", structure);
                arrayList.add(iCViolation);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            ICViolation[] iCViolationArray = new ICViolation[arrayList.size()];
            arrayList.toArray(iCViolationArray);
            serializable = new ICStatus(false, iCViolationArray);
        } else {
            serializable = ICStatus.OK;
        }
        return serializable;
    }

    private int getInt(Answers answers, int n, int n2) {
        int n3 = answers.id(n, n2);
        if (n3 < 0) {
            try {
                n3 = Integer.parseInt(answers.answer(n, n2).toString());
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return n3;
    }

    public ICStatus listICs(ConnectionID connectionID) throws QueryFailure {
        this.waitUntilReady();
        return this.icManager.listICs(connectionID);
    }

    public String[] currentUsers() {
        return this.admin.currentUsers();
    }

    public long numQueriesAsked() {
        return this.admin.numQueriesAsked();
    }

    public Request[] getCurrentRequests() {
        return this.admin.getCurrentRequests();
    }

    public boolean recheckICViolation(Object object, ConnectionID connectionID) throws QueryFailure {
        return this.icManager.recheckICViolation(object, connectionID);
    }

    public long numConnections() {
        return this.admin.numConnections() - 1;
    }

    public void lock(LockRequest[] lockRequestArray) throws Timeout, Deadlock {
        this.locking.lock(lockRequestArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean login(String string, String string2, ConnectionID connectionID) throws DatabaseFailure {
        boolean bl;
        Request request = this.admin.addRequest(connectionID, "Login", string2);
        try {
            try {
                request.setCurrentState("Waiting on locks");
                this.locking.obtainLocks(adminLock, this.getTransaction(connectionID), false, Isolation.SERIALIZABLE);
                request.setCurrentState("Logging in");
                Map map = this.getPasswords();
                if (map.size() == 0 || string2.equals("Ping") || string.equals(map.get(string2))) {
                    ConnectionProperties connectionProperties = this.admin.getConnection(connectionID);
                    connectionProperties.setUser(string2);
                    boolean bl2 = true;
                    Object var9_10 = null;
                    this.admin.removeRequest(request);
                    this.locking.freeLocks(this.getTransaction(connectionID));
                    return bl2;
                }
                bl = false;
            }
            catch (Exception exception) {
                throw new DatabaseFailure("Login failed", exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.admin.removeRequest(request);
            this.locking.freeLocks(this.getTransaction(connectionID));
            throw throwable;
        }
        Object var9_11 = null;
        this.admin.removeRequest(request);
        this.locking.freeLocks(this.getTransaction(connectionID));
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteUser(String string, ConnectionID connectionID) throws StorageManagerFault, UpdateFailure, LockUnavailable {
        boolean bl;
        if (this.readOnly) {
            throw new UpdateFailure("Cannot delete from read-only database");
        }
        Request request = this.admin.addRequest(connectionID, "Delete user", string);
        try {
            try {
                request.setCurrentState("Waiting on locks");
                this.locking.obtainLocks(adminLock, this.getTransaction(connectionID), true, Isolation.SERIALIZABLE);
                Map map = this.getPasswords();
                if (map.get(string) == null) {
                    boolean bl2 = false;
                    Object var9_7 = null;
                    this.locking.freeLocks(this.getTransaction(connectionID));
                    this.admin.removeRequest(request);
                    return bl2;
                }
                Form form = new Form("password", (OWL)new Symbol(string), (OWL)new IVar());
                this.sm.delete(form, null, this.getSMTransaction(connectionID));
                this.commit(connectionID);
                bl = true;
            }
            catch (QueryFailure queryFailure) {
                throw new UpdateFailure(queryFailure);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.locking.freeLocks(this.getTransaction(connectionID));
            this.admin.removeRequest(request);
            throw throwable;
        }
        Object var9_8 = null;
        this.locking.freeLocks(this.getTransaction(connectionID));
        this.admin.removeRequest(request);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addUser(String string, String string2, ConnectionID connectionID) throws UpdateFailure, StorageManagerFault, LockUnavailable {
        boolean bl;
        if (this.readOnly) {
            throw new UpdateFailure("Cannot add user to read-only database");
        }
        Request request = this.admin.addRequest(connectionID, "Add user", string);
        try {
            try {
                request.setCurrentState("Waiting on locks");
                this.locking.obtainLocks(adminLock, this.getTransaction(connectionID), true, Isolation.SERIALIZABLE);
                Map map = this.getPasswords();
                if (map.get(string) != null) {
                    boolean bl2 = false;
                    Object var11_8 = null;
                    this.admin.removeRequest(request);
                    this.locking.freeLocks(this.getTransaction(connectionID));
                    return bl2;
                }
                Form form = new Form("password", (OWL)new Symbol(string), (OWL)new Symbol(string2));
                SMTransaction sMTransaction = this.sm.beginTransaction(null);
                this.sm.insert(form, null, sMTransaction);
                this.sm.commit(sMTransaction);
                bl = true;
            }
            catch (QueryFailure queryFailure) {
                throw new UpdateFailure(queryFailure);
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.admin.removeRequest(request);
            this.locking.freeLocks(this.getTransaction(connectionID));
            throw throwable;
        }
        Object var11_9 = null;
        this.admin.removeRequest(request);
        this.locking.freeLocks(this.getTransaction(connectionID));
        return bl;
    }

    void openLog() {
        String string = KBProperties.get("com.kb.server.trace");
        if (string == null || string.length() == 0) {
            this.trace = new PrintWriter(System.out);
        } else {
            String string2 = FileNamer.name(string);
            try {
                this.trace = new PrintWriter(new FileOutputStream(string2, true));
                this.trace("Log opened");
                System.out.println("Trace log: " + string2);
            }
            catch (IOException iOException) {
                System.err.println("Could not open trace file " + string2);
                this.trace = new PrintWriter(System.err);
            }
        }
    }

    public void trace(String string) {
        PrintWriter printWriter = this.trace;
        synchronized (printWriter) {
            this.trace.println(new Date() + ": " + string);
            this.trace.flush();
        }
    }

    public void trace(Throwable throwable) {
        PrintWriter printWriter = this.trace;
        synchronized (printWriter) {
            this.trace(new Date() + ": " + throwable.getMessage());
            throwable.printStackTrace(this.trace);
            this.trace.flush();
        }
    }

    DatabaseFailure fail(String string) throws DatabaseFailure {
        this.trace(new Exception(string));
        this.failed = true;
        throw new DatabaseFailure(string);
    }

    DatabaseFailure fail(Exception exception) {
        this.trace(exception);
        this.failed = true;
        return new DatabaseFailure("Internal error", exception);
    }
}

