/*
 * Decompiled with CFR 0.152.
 */
package com.kb.server;

import com.kb.client.CommunicationsFailure;
import com.kb.client.Database;
import com.kb.client.DatabaseFailure;
import com.kb.client.IncompatibleVersion;
import com.kb.client.Isolation;
import com.kb.client.RequestFailure;
import com.kb.client.StorageManagerFault;
import com.kb.client_server.Answers;
import com.kb.client_server.ConnectionID;
import com.kb.client_server.ICStatus;
import com.kb.client_server.LockInfo;
import com.kb.client_server.Request;
import com.kb.client_server.WireProtocol;
import com.kb.kbddutil.Console;
import com.kb.kbddutil.KBProperties;
import com.kb.kbddutil.SerialForm;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.server.Server;
import com.kb.xsb.Structure;
import com.kb.xsb.Variable;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class RemoteKBServer
implements WireProtocol {
    final Server server;
    int heartbeat = Integer.getInteger("com.kb.network.heartbeat", 0);
    boolean cont = true;

    public RemoteKBServer(Database database, boolean bl) throws StorageManagerFault {
        this.server = new Server(database, bl);
        this.server.initializeStorageManager();
    }

    public static void main(String[] stringArray) {
        int n;
        Object object;
        boolean bl = KBProperties.getBoolean("com.kb.server.console");
        if (bl) {
            object = "Console for";
            n = 0;
            while (n < stringArray.length) {
                object = (String)object + " " + stringArray[n];
                ++n;
            }
            if (stringArray.length == 0) {
                object = (String)object + " unknown";
            }
            JFrame jFrame = new JFrame("Console for " + (String)object);
            Console console = new Console();
            jFrame.getContentPane().add(new JScrollPane(console));
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
            System.setOut(console.getStream());
            System.setErr(console.getStream());
        }
        try {
            object = stringArray.length > 0 ? new Database(stringArray[0]) : new Database();
            n = KBProperties.getBoolean("com.kb.server.readOnly") ? 1 : 0;
            new RemoteKBServer((Database)object, n != 0).go();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    void go() {
        block14: {
            var1_1 = null;
            try {
                var2_2 = this.server.database.getPort();
                System.out.println("Preparing port " + var2_2);
                var1_1 = new ServerSocket(var2_2);
                var1_1.setSoTimeout(1000);
                System.out.println("Ready on port " + var1_1.getLocalPort());
                while (this.cont) {
                    try {
                        var3_4 = var1_1.accept();
                        new RequestThread(this, var3_4).start();
                    }
                    catch (InterruptedIOException var3_5) {
                        // empty catch block
                    }
                }
                var5_6 = null;
                ** if (var1_1 == null) goto lbl-1000
            }
            catch (Throwable var4_12) {
                var5_8 = null;
                if (var1_1 != null) {
                    try {
                        var1_1.close();
                    }
                    catch (Exception var6_11) {
                        // empty catch block
                    }
                }
                throw var4_12;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var1_1.close();
                }
                catch (Exception var6_9) {}
            }
lbl-1000:
            // 2 sources

            {
                break block14;
                catch (Throwable var2_3) {
                    this.server.trace(var2_3.getMessage());
                    this.server.trace(var2_3);
                    var5_7 = null;
                    if (var1_1 != null) {
                        try {
                            var1_1.close();
                        }
                        catch (Exception var6_10) {}
                    }
                }
            }
        }
        this.server.stop();
        this.server.trace("Terminated");
        System.exit(0);
    }

    class RequestThread
    extends Thread
    implements WireProtocol {
        boolean cont = true;
        DataInputStream in;
        DataOutputStream out;
        Socket socket;
        RemoteKBServer dispatcher;
        ConnectionID cid = null;
        BufferedOutputStream bos;

        RequestThread(RemoteKBServer remoteKBServer2, Socket socket) throws IOException {
            this.socket = socket;
            this.dispatcher = remoteKBServer2;
            this.in = new DataInputStream(socket.getInputStream());
            this.bos = new BufferedOutputStream(socket.getOutputStream());
            this.out = new DataOutputStream(this.bos);
            this.setDaemon(true);
            this.setName("Handling user requests");
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            this.process();
            this.socket.close();
            Object var3_1 = null;
            if (this.cid == null) return;
            try {
                RemoteKBServer.this.server.close(this.cid);
                return;
            }
            catch (DatabaseFailure databaseFailure) {
                databaseFailure.printStackTrace();
            }
            return;
            {
                catch (Throwable throwable) {
                    RemoteKBServer.this.server.trace(throwable);
                    Object var3_2 = null;
                    if (this.cid == null) return;
                    try {
                        RemoteKBServer.this.server.close(this.cid);
                        return;
                    }
                    catch (DatabaseFailure databaseFailure) {
                        databaseFailure.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.cid == null) throw throwable;
                try {
                    RemoteKBServer.this.server.close(this.cid);
                    throw throwable;
                }
                catch (DatabaseFailure databaseFailure) {
                    databaseFailure.printStackTrace();
                }
                throw throwable;
            }
        }

        public void process() {
            this.cont = this.connect();
            while (this.cont) {
                try {
                    byte by;
                    try {
                        by = this.in.readByte();
                    }
                    catch (EOFException eOFException) {
                        return;
                    }
                    catch (SocketException socketException) {
                        return;
                    }
                    switch ((char)by) {
                        case 'Y': {
                            this.currentRequests();
                            break;
                        }
                        case 'W': {
                            this.changePassword();
                            break;
                        }
                        case 'V': {
                            this.allUsers();
                            break;
                        }
                        case 'U': {
                            this.addUser();
                            break;
                        }
                        case 'P': {
                            this.deleteUser();
                            break;
                        }
                        case 'M': {
                            this.currentUsers();
                            break;
                        }
                        case 'G': {
                            this.login();
                            break;
                        }
                        case 'B': {
                            this.listICs();
                            break;
                        }
                        case '1': {
                            this.checkICs();
                            break;
                        }
                        case 'F': {
                            this.isIntegrityConstraintViolation();
                            break;
                        }
                        case 'E': {
                            this.extent();
                            break;
                        }
                        case 'T': {
                            this.commit();
                            break;
                        }
                        case 'R': {
                            this.rollback();
                            break;
                        }
                        case 'q': {
                            this.queryLow();
                            break;
                        }
                        case 'i': {
                            this.insertLow();
                            break;
                        }
                        case 'd': {
                            this.deleteLow();
                            break;
                        }
                        case 'C': {
                            this.create();
                            break;
                        }
                        case 'Q': {
                            this.query();
                            break;
                        }
                        case 'I': {
                            this.insert();
                            break;
                        }
                        case 'D': {
                            this.delete();
                            break;
                        }
                        case 'L': {
                            this.locks();
                            break;
                        }
                        case 'N': {
                            this.numQueriesAsked();
                            break;
                        }
                        case 'S': {
                            this.stopServer();
                            this.cont = false;
                            break;
                        }
                        case 'X': {
                            this.close();
                            this.cont = false;
                            break;
                        }
                        default: {
                            this.out.writeByte(90);
                            this.out.writeUTF(" Invalid request " + by);
                            this.cont = false;
                        }
                    }
                    this.out.flush();
                }
                catch (RequestFailure requestFailure) {
                    try {
                        RemoteKBServer.this.server.trace(requestFailure);
                        System.out.println("Writing exception");
                        this.out.writeByte(88);
                        this.out.writeUTF(requestFailure.getMessage());
                        System.out.println("Done writing exception");
                        this.out.flush();
                        this.bos.flush();
                    }
                    catch (IOException iOException) {
                        RemoteKBServer.this.server.trace(iOException);
                        iOException.printStackTrace();
                        this.cont = false;
                    }
                }
                catch (IOException iOException) {
                    RemoteKBServer.this.server.trace(iOException);
                    iOException.printStackTrace();
                    this.cont = false;
                }
                catch (Throwable throwable) {
                    try {
                        throwable.printStackTrace();
                        RemoteKBServer.this.server.trace(throwable);
                        this.out.writeByte(90);
                        this.out.writeUTF(" " + throwable.toString());
                        this.cont = false;
                        this.out.flush();
                    }
                    catch (Throwable throwable2) {
                        RemoteKBServer.this.server.trace(throwable2);
                    }
                }
            }
        }

        int flagsLimit(int n) {
            return n >> 3 & 0xFFFF;
        }

        Isolation flagsIsolation(int n) {
            switch (n >> 1 & 3) {
                case 0: {
                    return Isolation.READ_UNCOMMITTED;
                }
                case 1: {
                    return Isolation.READ_COMMITTED;
                }
                case 2: {
                    return Isolation.REPEATABLE_READ;
                }
                case 3: {
                    return Isolation.SERIALIZABLE;
                }
            }
            return null;
        }

        boolean flagscommit(int n) {
            return (n >> 0 & 1) == 1;
        }

        boolean connect() {
            try {
                if (RemoteKBServer.this.heartbeat > 5) {
                    System.out.println(">Connect request from " + this.socket.getInetAddress());
                }
                int n = this.in.readInt();
                int n2 = this.in.readInt();
                int n3 = this.in.readInt();
                if (n != -17883392) {
                    this.out.writeByte(90);
                    this.out.writeUTF(" Invalid magic number");
                    this.out.flush();
                    return false;
                }
                if (n2 > 1 || n2 == 1 && n3 > 0) {
                    throw new IncompatibleVersion(n2 + "." + n3 + " incompatible with server " + 1 + "." + 0);
                }
                Properties properties = new Properties();
                this.cid = RemoteKBServer.this.server.connect(properties);
                this.out.writeByte(79);
                this.out.writeInt(this.cid.index());
                new ObjectOutputStream(this.out).writeObject(properties);
                if (RemoteKBServer.this.heartbeat > 5) {
                    System.out.println("<Connect request from " + this.socket.getInetAddress() + " yields " + this.cid);
                }
                this.out.flush();
                return true;
            }
            catch (IOException iOException) {
                try {
                    this.out.writeByte(90);
                    this.out.writeUTF("Bad connection");
                    this.out.flush();
                    return false;
                }
                catch (IOException iOException2) {
                    return false;
                }
            }
        }

        void close() throws IOException, DatabaseFailure {
            if (RemoteKBServer.this.heartbeat > 5) {
                System.out.println("<Disconnect request from " + this.socket.getInetAddress());
            }
            try {
                RemoteKBServer.this.server.close(this.cid);
                this.cid = null;
                this.out.writeByte(79);
                this.out.flush();
            }
            catch (IOException iOException) {
                System.out.println("Problem still exists in close request");
            }
        }

        void stopServer() throws IOException, DatabaseFailure {
            this.out.writeByte(79);
            System.out.println("Shutting down");
            this.dispatcher.cont = false;
        }

        void queryLow() throws IOException, RequestFailure, DatabaseFailure {
            if (RemoteKBServer.this.heartbeat > 5) {
                System.out.print("QUERY" + this.cid);
            }
            Object object = SerialForm.read(this.in);
            if (RemoteKBServer.this.heartbeat > 5) {
                System.out.print(" " + object);
                System.out.flush();
            }
            int n = this.in.readInt();
            Variable[] variableArray = new Variable[n];
            int n2 = 0;
            while (n2 < n) {
                variableArray[n2] = (Variable)SerialForm.read(this.in);
                ++n2;
            }
            int n3 = this.in.readInt();
            if (RemoteKBServer.this.heartbeat > 5) {
                System.out.println(" " + n3);
                System.out.flush();
            }
            Isolation isolation = this.flagsIsolation(n3);
            boolean bl = this.flagscommit(n3);
            int n4 = this.flagsLimit(n3);
            Answers answers = RemoteKBServer.this.server.query(this.cid, object, variableArray, n4, bl, isolation);
            if (RemoteKBServer.this.heartbeat > 5) {
                System.out.println("Returning " + answers.numAnswers() + " answers");
            }
            if (RemoteKBServer.this.heartbeat > 9) {
                int n5 = 0;
                while (n5 < answers.numAnswers()) {
                    int n6 = 0;
                    while (n6 < answers.width()) {
                        System.out.println(n5 + " " + n6 + ". " + answers.answer(n5, n6));
                        ++n6;
                    }
                    ++n5;
                }
            }
            this.out.writeByte(79);
            this.writeAnswers(answers);
        }

        void query() throws IOException, RequestFailure, DatabaseFailure {
            try {
                if (RemoteKBServer.this.heartbeat > 5) {
                    System.out.print("QUERY");
                }
                ObjectInputStream objectInputStream = new ObjectInputStream(this.in);
                OWL oWL = (OWL)objectInputStream.readObject();
                IVar[] iVarArray = (IVar[])objectInputStream.readObject();
                int n = this.in.readInt();
                Isolation isolation = this.flagsIsolation(n);
                boolean bl = this.flagscommit(n);
                int n2 = this.flagsLimit(n);
                Answers answers = RemoteKBServer.this.server.query(this.cid, oWL, iVarArray, n2, bl, isolation);
                this.out.writeByte(79);
                this.writeAnswers(answers);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }

        void extent() throws RequestFailure, IOException {
            Object object = SerialForm.read(this.in);
            int n = this.in.readInt();
            Isolation isolation = this.flagsIsolation(n);
            boolean bl = this.flagscommit(n);
            Answers answers = RemoteKBServer.this.server.extent(this.cid, object, bl, isolation);
            this.out.writeByte(79);
            this.writeAnswers(answers);
        }

        void create() throws RequestFailure, IOException {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(this.in);
                OWL oWL = (OWL)objectInputStream.readObject();
                int n = this.in.readInt();
                Isolation isolation = this.flagsIsolation(n);
                boolean bl = this.flagscommit(n);
                OWL oWL2 = RemoteKBServer.this.server.create(this.cid, oWL, bl, isolation);
                this.out.writeByte(79);
                new ObjectOutputStream(this.out).writeObject(oWL2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }

        void currentRequests() throws IOException {
            try {
                Request[] requestArray = RemoteKBServer.this.server.getCurrentRequests();
                this.out.writeByte(79);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.out);
                objectOutputStream.writeObject(requestArray);
                objectOutputStream.flush();
            }
            catch (IOException iOException) {
                RemoteKBServer.this.server.trace(iOException);
                throw iOException;
            }
        }

        void login() throws IOException, RequestFailure {
            String string = new String(this.in.readUTF());
            String string2 = new String(this.in.readUTF());
            this.setName("Requests from " + string2);
            this.out.writeByte(79);
            this.out.writeBoolean(RemoteKBServer.this.server.login(string, string2, this.cid));
            this.out.flush();
        }

        void checkICs() throws RequestFailure, IOException {
            ICStatus iCStatus = RemoteKBServer.this.server.checkIntegrityConstraints(this.cid);
            this.out.writeByte(79);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.out);
            objectOutputStream.writeObject(iCStatus);
            objectOutputStream.flush();
            this.out.flush();
        }

        void listICs() throws RequestFailure, IOException {
            ICStatus iCStatus = RemoteKBServer.this.server.listICs(this.cid);
            this.out.writeByte(79);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.out);
            objectOutputStream.writeObject(iCStatus);
            objectOutputStream.flush();
            this.out.flush();
        }

        void isIntegrityConstraintViolation() throws RequestFailure, IOException {
            Structure structure = (Structure)SerialForm.read(this.in);
            System.out.println("before boolean autocommit = ...");
            boolean bl = this.in.readBoolean();
            boolean bl2 = RemoteKBServer.this.server.recheckICViolation(structure, this.cid);
            this.out.writeByte(79);
            this.out.writeBoolean(bl2);
            this.out.flush();
        }

        void commit() throws DatabaseFailure, IOException {
            ICStatus iCStatus = RemoteKBServer.this.server.commit(this.cid);
            this.out.writeByte(79);
            new ObjectOutputStream(this.out).writeObject(iCStatus);
        }

        void rollback() throws DatabaseFailure, IOException {
            this.out.writeByte(79);
            this.out.flush();
            RemoteKBServer.this.server.rollback(this.cid);
        }

        void insertLow() throws DatabaseFailure, RequestFailure, IOException {
            Object object = SerialForm.read(this.in);
            int n = this.in.readInt();
            Isolation isolation = this.flagsIsolation(n);
            boolean bl = this.flagscommit(n);
            ICStatus iCStatus = RemoteKBServer.this.server.insert(this.cid, object, bl, isolation);
            this.out.writeByte(79);
            new ObjectOutputStream(this.out).writeObject(iCStatus);
        }

        void deleteUser() throws IOException, StorageManagerFault, RequestFailure {
            String string = this.in.readUTF();
            boolean bl = RemoteKBServer.this.server.deleteUser(string, this.cid);
            this.out.writeByte(79);
            this.out.writeBoolean(bl);
            this.out.flush();
        }

        void changePassword() throws Exception {
            String string = this.in.readUTF();
            String string2 = this.in.readUTF();
            RemoteKBServer.this.server.deleteUser(string, this.cid);
            RemoteKBServer.this.server.addUser(string, string2, this.cid);
            this.out.writeByte(79);
        }

        void addUser() throws IOException, RequestFailure {
            String string = this.in.readUTF();
            String string2 = this.in.readUTF();
            boolean bl = RemoteKBServer.this.server.addUser(string, string2, this.cid);
            this.out.writeByte(79);
            this.out.writeBoolean(bl);
            this.out.flush();
        }

        void deleteLow() throws DatabaseFailure, RequestFailure, IOException {
            Object object = SerialForm.read(this.in);
            int n = this.in.readInt();
            Isolation isolation = this.flagsIsolation(n);
            boolean bl = this.flagscommit(n);
            ICStatus iCStatus = RemoteKBServer.this.server.delete(this.cid, object, bl, isolation);
            this.out.writeByte(79);
            new ObjectOutputStream(this.out).writeObject(iCStatus);
        }

        void insert() throws DatabaseFailure, RequestFailure, IOException {
            try {
                OWL oWL = (OWL)new ObjectInputStream(this.in).readObject();
                int n = this.in.readInt();
                Isolation isolation = this.flagsIsolation(n);
                boolean bl = this.flagscommit(n);
                ICStatus iCStatus = RemoteKBServer.this.server.insert(this.cid, oWL, bl, isolation);
                this.out.writeByte(79);
                new ObjectOutputStream(this.out).writeObject(iCStatus);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }

        void delete() throws DatabaseFailure, RequestFailure, IOException {
            try {
                OWL oWL = (OWL)new ObjectInputStream(this.in).readObject();
                int n = this.in.readInt();
                Isolation isolation = this.flagsIsolation(n);
                boolean bl = this.flagscommit(n);
                ICStatus iCStatus = RemoteKBServer.this.server.delete(this.cid, oWL, bl, isolation);
                this.out.writeByte(79);
                new ObjectOutputStream(this.out).writeObject(iCStatus);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.toString());
            }
        }

        void locks() throws DatabaseFailure, RequestFailure, IOException {
            LockInfo[] lockInfoArray = RemoteKBServer.this.server.locks();
            this.out.writeByte(79);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.out);
            objectOutputStream.writeObject(lockInfoArray);
            objectOutputStream.flush();
        }

        void numQueriesAsked() throws IOException {
            long l = RemoteKBServer.this.server.numQueriesAsked();
            this.out.writeByte(79);
            this.out.writeLong(l);
            this.out.flush();
        }

        void currentUsers() throws IOException, CommunicationsFailure, RequestFailure {
            String[] stringArray = RemoteKBServer.this.server.currentUsers();
            this.out.writeByte(79);
            this.out.writeInt(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] == null) {
                    this.out.writeUTF("[anonymous]");
                } else {
                    this.out.writeUTF(stringArray[n]);
                }
                ++n;
            }
            this.out.flush();
        }

        void allUsers() throws IOException, RequestFailure {
            String[] stringArray = RemoteKBServer.this.server.useridList(this.cid);
            this.out.writeByte(79);
            this.out.writeInt(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.out.writeUTF(stringArray[n]);
                ++n;
            }
            this.out.flush();
        }

        void writeAnswers(Answers answers) throws IOException {
            this.out.writeInt(answers.numAnswers());
            this.out.writeInt(answers.width());
            int n = 0;
            while (n < answers.numAnswers()) {
                int n2 = 0;
                while (n2 < answers.width()) {
                    this.out.writeInt(answers.id(n, n2));
                    ++n2;
                }
                ++n;
            }
            int n3 = answers.numExtended();
            this.out.writeInt(answers.numExtended());
            int n4 = 0;
            while (n4 < answers.numExtended()) {
                SerialForm.write(answers.extended(n4), this.out);
                ++n4;
            }
        }
    }
}

