/*
 * Decompiled with CFR 0.152.
 */
package com.kb.server;

import com.kb.client.DatabaseFailure;
import com.kb.client.Deadlock;
import com.kb.client.Isolation;
import com.kb.client.Timeout;
import com.kb.client_server.LockInfo;
import com.kb.kbddutil.KBProperties;
import com.kb.server.Lock;
import com.kb.server.LockDuration;
import com.kb.server.LockManager;
import com.kb.server.LockMode;
import com.kb.server.LockRequest;
import com.kb.server.Server;
import com.kb.server.Transaction;
import java.util.ArrayList;

class Locking {
    Server server;
    LockManager lm = new LockManager();
    public final boolean noLocks = KBProperties.getBoolean("com.kb.server.locks");
    public static final int timeout = 10000;

    Locking(Server server) {
        this.server = server;
    }

    public void lock(LockRequest[] lockRequestArray) throws Timeout, Deadlock {
        int n = 0;
        while (n < lockRequestArray.length) {
            this.lm.lock(lockRequestArray[n], 0L);
            ++n;
        }
    }

    public LockInfo[] locks() {
        Object object;
        Lock[] lockArray = this.lm.locks();
        ArrayList<LockInfo> arrayList = new ArrayList<LockInfo>();
        int n = 0;
        while (n < lockArray.length) {
            object = lockArray[n].requests();
            while (object.hasMoreElements()) {
                LockRequest lockRequest = (LockRequest)object.nextElement();
                arrayList.add(new LockInfo(lockRequest.target.toString(), "", lockRequest.date, lockRequest.mode.toString(), lockRequest.duration().toString(), lockRequest.status().toString()));
            }
            ++n;
        }
        object = new LockInfo[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    void freeLocks(Transaction transaction) {
        if (this.noLocks) {
            return;
        }
        if (transaction != null) {
            int n = transaction.numLockRequests() - 1;
            while (n >= 0) {
                LockRequest lockRequest = transaction.lockRequest(n);
                this.lm.unlock(lockRequest.target, transaction);
                --n;
            }
        }
    }

    void freeShortLocks(Transaction transaction) throws DatabaseFailure {
        if (this.noLocks) {
            return;
        }
        if (transaction != null) {
            int n = transaction.numLockRequests() - 1;
            while (n >= 0) {
                LockRequest lockRequest = transaction.lockRequest(n);
                if (lockRequest == null) {
                    throw this.server.fail("Null lock request " + n + " for " + transaction);
                }
                if (lockRequest.duration().lessOrEqual(LockDuration.SHORT)) {
                    this.lm.unlock(lockRequest.target, transaction);
                }
                --n;
            }
        }
    }

    void obtainLocks(Object object, Transaction transaction, boolean bl, Isolation isolation) throws Deadlock, Timeout, DatabaseFailure {
        if (this.noLocks) {
            return;
        }
        this.obtainLock(object, transaction, bl, isolation);
    }

    void obtainLock(Object object, Transaction transaction, boolean bl, Isolation isolation) throws Deadlock, Timeout, DatabaseFailure {
        LockDuration lockDuration;
        if (!(bl || isolation != Isolation.READ_UNCOMMITTED && isolation != Isolation.READ_COMMITTED)) {
            return;
        }
        if (isolation.equals(Isolation.READ_UNCOMMITTED)) {
            lockDuration = LockDuration.SHORT;
        } else if (isolation.equals(Isolation.READ_COMMITTED)) {
            lockDuration = LockDuration.MEDIUM;
        } else if (isolation.equals(Isolation.REPEATABLE_READ)) {
            lockDuration = bl ? LockDuration.MEDIUM : LockDuration.SHORT;
        } else if (isolation.equals(Isolation.SERIALIZABLE)) {
            lockDuration = LockDuration.MEDIUM;
        } else {
            throw this.server.fail("Invalid lock level " + isolation);
        }
        LockMode lockMode = bl ? LockMode.X : LockMode.S;
        this.lm.lock(object, transaction, lockMode, lockDuration, 10000L);
    }
}

