/*
 * Decompiled with CFR 0.152.
 */
package com.kb.server;

import java.io.Serializable;

public class LockMode
implements Serializable {
    private int n;
    private String name;
    public static final LockMode FREE = new LockMode("FREE", 0);
    public static final LockMode IS = new LockMode("IS", 1);
    public static final LockMode IX = new LockMode("IX", 2);
    public static final LockMode S = new LockMode("S", 3);
    public static final LockMode SIX = new LockMode("SIX", 4);
    public static final LockMode X = new LockMode("X", 5);
    public static final boolean[][] compat = new boolean[][]{new boolean[0], {true, true, true, true, true, false}, {true, true, true, false, false, false}, {true, true, false, true, false, false}, {true, true, false, false, false, false}, {true, false, false, false, false, false}};
    public static final LockMode[][] convert = new LockMode[][]{new LockMode[0], {IS, IS, IX, S, SIX, X}, {IX, IX, IX, SIX, SIX, X}, {S, S, SIX, S, SIX, X}, {SIX, SIX, SIX, SIX, SIX, X}, {X, X, X, X, X, X}};

    private LockMode(String string, int n) {
        this.n = n;
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public static LockMode max(LockMode lockMode, LockMode lockMode2) {
        if (lockMode.n > lockMode2.n) {
            return lockMode;
        }
        return lockMode2;
    }

    public static LockMode convert(LockMode lockMode, LockMode lockMode2) {
        return convert[lockMode2.n][lockMode.n];
    }

    public boolean compatibleWith(LockMode lockMode) {
        if (lockMode == FREE) {
            throw new RuntimeException("Can't request a free lock!");
        }
        return compat[lockMode.n][this.n];
    }
}

