/*
 * Decompiled with CFR 0.152.
 */
package com.kb.server;

import com.kb.client.Deadlock;
import com.kb.client.Timeout;
import com.kb.server.Lock;
import com.kb.server.LockDuration;
import com.kb.server.LockMode;
import com.kb.server.LockRequest;
import com.kb.server.LockRequestStatus;
import com.kb.server.Transaction;
import java.util.Enumeration;
import java.util.Hashtable;

public class LockManager {
    Hashtable lock_table = new Hashtable();

    public void lock(LockRequest lockRequest, long l) throws Deadlock, Timeout {
        Lock lock;
        Hashtable hashtable = this.lock_table;
        synchronized (hashtable) {
            lock = (Lock)this.lock_table.get(lockRequest.target);
            if (lock == null) {
                lock = new Lock(lockRequest.target, lockRequest.mode);
                lockRequest.setStatus(LockRequestStatus.GRANTED);
                lock.addRequest(lockRequest);
                this.lock_table.put(lockRequest.target, lock);
                lockRequest.transaction.addLockRequest(lockRequest);
                return;
            }
        }
        Lock lock2 = lock;
        synchronized (lock2) {
            LockRequest lockRequest2 = lock.findRequest(lockRequest.transaction);
            if (lockRequest2 != null) {
                if (lockRequest2.mode == lockRequest.mode && lockRequest2.duration() == lockRequest.duration() && lockRequest2.status() == LockRequestStatus.GRANTED) {
                    lockRequest.setStatus(LockRequestStatus.GRANTED);
                } else {
                    lockRequest2.setConvertMode(LockMode.convert(lockRequest2.mode, lockRequest.mode));
                    lockRequest2.setDuration(LockDuration.max(lockRequest2.duration(), lockRequest.duration()));
                    if (this.canConvert(lock, lockRequest2)) {
                        lockRequest2.setMode(LockMode.convert(lockRequest2.mode, lockRequest.mode));
                        lock.setMode(LockMode.max(lock.mode, lockRequest2.mode));
                        lockRequest = lockRequest2;
                    } else {
                        lockRequest2.setStatus(LockRequestStatus.CONVERTING);
                        lockRequest = lockRequest2;
                    }
                }
            } else {
                lock.addRequest(lockRequest);
                lockRequest.transaction.addLockRequest(lockRequest);
                if (!lock.waiting() && lock.mode.compatibleWith(lockRequest.mode)) {
                    lockRequest.setStatus(LockRequestStatus.GRANTED);
                    lock.setMode(LockMode.max(lock.mode, lockRequest.mode));
                }
            }
            if (lockRequest.status() != LockRequestStatus.GRANTED) {
                lock.setWaiting(true);
                try {
                    lock.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (lockRequest.status() == LockRequestStatus.GRANTED) {
                    return;
                }
                lockRequest.makeInstant();
                this.unlock(lockRequest.target, lockRequest.transaction);
                if (lockRequest.status() == LockRequestStatus.WAITING || lockRequest.status() == LockRequestStatus.CONVERTING) {
                    throw new Timeout(lockRequest.target);
                }
                throw new RuntimeException("Invalid lock state: " + lockRequest.status());
            }
        }
    }

    public void lock(Object object, Transaction transaction, LockMode lockMode, LockDuration lockDuration, long l) throws Deadlock, Timeout {
        LockRequest lockRequest = new LockRequest(transaction, object, lockMode, lockDuration, Thread.currentThread());
        this.lock(lockRequest, l);
    }

    public void unlock(Object object, Transaction transaction) {
        Lock lock = (Lock)this.lock_table.get(object);
        if (lock == null) {
            return;
        }
        Lock lock2 = lock;
        synchronized (lock2) {
            LockRequest lockRequest = lock.findRequest(transaction);
            if (lockRequest == null) {
                return;
            }
            transaction.removeLockRequest(lockRequest);
            --lockRequest.count;
            if (lockRequest.duration() == LockDuration.LONG || lockRequest.duration() == LockDuration.VERY_LONG || lockRequest.count > 1) {
                return;
            }
            lock.removeRequest(lockRequest);
            lock.setWaiting(false);
            lock.setMode(LockMode.FREE);
            boolean bl = true;
            Enumeration enumeration = lock.requests();
            while (enumeration.hasMoreElements() && bl) {
                boolean bl2;
                LockRequest lockRequest2 = (LockRequest)enumeration.nextElement();
                if (lockRequest2.status() == LockRequestStatus.GRANTED) {
                    lock.setMode(LockMode.max(lock.mode, lockRequest2.mode));
                    continue;
                }
                if (lockRequest2.status() == LockRequestStatus.WAITING) {
                    bl2 = lock.mode.compatibleWith(lockRequest2.mode);
                    bl = this.grant(lock, lockRequest2, bl2);
                    continue;
                }
                if (lockRequest2.status() != LockRequestStatus.CONVERTING) continue;
                bl2 = this.canConvert(lock, lockRequest2);
                bl = this.grant(lock, lockRequest2, bl2);
            }
        }
    }

    boolean grant(Lock lock, LockRequest lockRequest, boolean bl) {
        if (bl) {
            if (lockRequest.status() == LockRequestStatus.CONVERTING) {
                lock.setMode(LockMode.max(lock.mode, lockRequest.convertMode()));
            } else {
                lock.setMode(LockMode.max(lock.mode, lockRequest.mode));
            }
            lockRequest.setStatus(LockRequestStatus.GRANTED);
            lockRequest.thread.interrupt();
            return true;
        }
        lock.setWaiting(true);
        return false;
    }

    boolean canConvert(Lock lock, LockRequest lockRequest) {
        boolean bl = true;
        Enumeration enumeration = lock.requests();
        while (enumeration.hasMoreElements()) {
            LockRequest lockRequest2 = (LockRequest)enumeration.nextElement();
            if (lockRequest2 == lockRequest) continue;
            if (lockRequest2.status() != LockRequestStatus.GRANTED && lockRequest2.status() != LockRequestStatus.CONVERTING) break;
            if (lockRequest2.mode.compatibleWith(lockRequest.convertMode())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public Lock[] locks() {
        Hashtable hashtable = this.lock_table;
        synchronized (hashtable) {
            Lock[] lockArray;
            int n = 0;
            Lock[] lockArray2 = new Lock[this.lock_table.size()];
            Enumeration enumeration = this.lock_table.elements();
            while (enumeration.hasMoreElements()) {
                lockArray = (Lock)enumeration.nextElement();
                lockArray2[n++] = lockArray;
            }
            lockArray = lockArray2;
            return lockArray;
        }
    }

    public String statusString() {
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable hashtable = this.lock_table;
        synchronized (hashtable) {
            stringBuffer.append(this.lock_table.size() + " locks\n");
            int n = 1;
            Enumeration enumeration = this.lock_table.elements();
            while (enumeration.hasMoreElements()) {
                Lock lock = (Lock)enumeration.nextElement();
                stringBuffer.append(n + ". " + lock + "\n");
                Enumeration enumeration2 = lock.requests();
                while (enumeration2.hasMoreElements()) {
                    stringBuffer.append("    " + enumeration2.nextElement() + "\n");
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

