/*
 * Decompiled with CFR 0.152.
 */
package com.kb.server;

import com.kb.client.QueryFailure;
import com.kb.client.StorageManagerFault;
import com.kb.client_server.Answers;
import com.kb.client_server.ConnectionID;
import com.kb.client_server.ICStatus;
import com.kb.client_server.ICViolation;
import com.kb.client_server.Request;
import com.kb.server.Server;
import com.kb.xsb.OWL2XSB;
import com.kb.xsb.Structure;
import com.kb.xsb.Variable;

class ICManager {
    Server server;

    ICManager(Server server) {
        this.server = server;
    }

    static boolean isHardIC(ICViolation iCViolation) {
        String string = iCViolation.type();
        boolean bl = string.equalsIgnoreCase("RootCtx.HardIC") || string.equalsIgnoreCase("RootCtx.AdamantIC") || string.equalsIgnoreCase("hard");
        return bl;
    }

    public ICStatus listICs(ConnectionID connectionID) throws QueryFailure {
        Variable variable = new Variable("A");
        Variable variable2 = new Variable("B");
        Variable variable3 = new Variable("C");
        Variable variable4 = new Variable("D");
        Structure structure = new Structure((Object)"_kb_ic_viol", new Object[]{variable, variable2, variable3, variable4});
        Request request = this.server.admin.addQuery(connectionID, structure);
        try {
            Object object;
            Answers answers = this.server.sm.queryDB(structure, new Variable[]{variable, variable2, variable3, variable4}, Integer.MAX_VALUE);
            request.setCurrentState("Processed");
            ICViolation[] iCViolationArray = new ICViolation[answers.numAnswers()];
            int n = 0;
            while (n < answers.numAnswers()) {
                String string = OWL2XSB.convertParseStructure(answers.answer(n, 3)).name();
                object = OWL2XSB.convertParseStructure(answers.answer(n, 0)).name();
                Object object2 = answers.answer(n, 1);
                Structure structure2 = (Structure)answers.answer(n, 2);
                iCViolationArray[n] = new ICViolation(string, (String)object, object2, structure2);
                ++n;
            }
            boolean bl = true;
            object = new ICStatus(bl, iCViolationArray);
            Object var16_16 = null;
            this.server.admin.removeRequest(request);
            return object;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            this.server.admin.removeRequest(request);
            throw throwable;
        }
    }

    void insertICs(ICViolation[] iCViolationArray, ConnectionID connectionID) throws StorageManagerFault {
        int n = 0;
        while (n < iCViolationArray.length) {
            Object var7_6;
            Structure structure = new Structure((Object)"_kb_ic_viol", new Object[]{iCViolationArray[n].type(), iCViolationArray[n].id(), iCViolationArray[n].head(), iCViolationArray[n].msg()});
            Request request = this.server.admin.addRequest(connectionID, "Insert", structure);
            try {
                this.server.sm.insertDB(structure, this.server.getSMTransaction(connectionID));
                request.setCurrentState("Inserted");
                var7_6 = null;
                this.server.admin.removeRequest(request);
            }
            catch (Throwable throwable) {
                var7_6 = null;
                this.server.admin.removeRequest(request);
                throw throwable;
            }
            ++n;
        }
    }

    public boolean recheckICViolation(Object object, ConnectionID connectionID) throws QueryFailure {
        Request request = this.server.admin.addQuery(connectionID, object);
        try {
            Variable variable = new Variable("Fid");
            Variable variable2 = new Variable("Type");
            Variable variable3 = new Variable("Msg");
            Answers answers = this.server.sm.queryDB(object, new Variable[0], Integer.MAX_VALUE);
            boolean bl = true;
            if (answers.numAnswers() == 0) {
                Structure structure = new Structure((Object)"_kb_ic_viol", new Object[]{variable2, variable, object, variable3});
                this.server.sm.deleteDB(structure, this.server.getSMTransaction(connectionID));
                this.server.sm.commit(this.server.getSMTransaction(connectionID));
                bl = false;
            }
            boolean bl2 = bl;
            Object var11_11 = null;
            this.server.admin.removeRequest(request);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.server.admin.removeRequest(request);
            throw throwable;
        }
    }
}

