/*
 * Decompiled with CFR 0.152.
 */
package com.kb.resourceManager;

import com.kb.client.Database;
import com.kb.client.DatabaseState;
import com.ow.gui.iode.IODEThrowableDisplayer;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class ResourceTableModel
extends AbstractTableModel {
    String[] columnNames = new String[]{"Database", "Type", "Status", "Location"};
    Vector rows = new Vector();

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            try {
                Resource resource = this.getRow(n);
                System.out.println(resource.getName() + " -> " + object);
                resource.rename((String)object);
            }
            catch (Exception exception) {
                new IODEThrowableDisplayer().handle(exception);
            }
        } else {
            throw new Error("Shouldn't be able to edit column " + n2);
        }
    }

    void update(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ResourceTableModel.this.fireTableRowsUpdated(n, n);
            }
        });
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 0 && this.getRow(n).getState() == DatabaseState.Stopped;
    }

    public int getColumnCount() {
        return 4;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int n, int n2) {
        Resource resource = (Resource)this.rows.elementAt(n);
        switch (n2) {
            case 0: {
                return resource.getName();
            }
            case 1: {
                return resource.isOMS() ? "OMS" : "DDB";
            }
            case 2: {
                return resource.getState();
            }
            case 3: {
                return (resource.getHost() == null ? "localhost" : resource.getHost()) + ":" + resource.getPort();
            }
        }
        throw new Error("Invalid column " + n2);
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    Resource getRow(int n) {
        if (n == -1) {
            return null;
        }
        Resource resource = (Resource)this.rows.elementAt(n);
        return resource;
    }

    public Resource getResource(String string) {
        int n = 0;
        while (n < this.rows.size()) {
            Resource resource = (Resource)this.rows.elementAt(n);
            if (resource.getName().equals(string)) {
                return resource;
            }
            ++n;
        }
        return null;
    }

    public Resource addRow(String string) throws IOException {
        Resource resource = new Resource(string);
        this.rows.addElement(resource);
        final int n = this.rows.size() - 1;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ResourceTableModel.this.fireTableRowsInserted(n, n);
            }
        });
        return resource;
    }

    public void removeRow(final int n) {
        this.rows.removeElementAt(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ResourceTableModel.this.fireTableRowsDeleted(n, n);
            }
        });
    }

    class Resource
    extends Database {
        private JPanel panel;

        Resource(String string) throws IOException {
            super(string);
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public void setPanel(JPanel jPanel) {
            this.panel = jPanel;
        }

        public void setState(DatabaseState databaseState) {
            super.setState(databaseState);
            if (databaseState != DatabaseState.Started) {
                this.panel = null;
            }
            Vector vector = ResourceTableModel.this.rows;
            synchronized (vector) {
                int n = ResourceTableModel.this.rows.indexOf(this);
                ResourceTableModel.this.update(n);
            }
        }
    }
}

