/*
 * Decompiled with CFR 0.152.
 */
package com.kb.resourceManager;

import com.kb.admin.Admin;
import com.kb.client_server.Request;
import com.kb.resourceManager.NonEditableTableModel;
import com.kb.resourceManager.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.TableColumn;

public class RequestPanel
extends JPanel {
    Admin admin;
    JPanel jPanel;
    JButton refreshButton;
    JComboBox jComboBox;
    JLabel frequencyLabel;
    JScrollPane jScrollPane;
    JTable jTable;
    NonEditableTableModel requests;
    Timer timer;

    public RequestPanel(Admin admin) {
        try {
            this.admin = admin;
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        this.jPanel = new JPanel();
        this.frequencyLabel = new JLabel();
        this.frequencyLabel.setText("Update Frequency");
        String[] stringArray = new String[]{"Never", "1 second", "2 seconds", "5 seconds", "10 seconds"};
        this.jComboBox = new JComboBox<String>(stringArray);
        this.jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)RequestPanel.this.jComboBox.getSelectedItem();
                if (string.equals("Never")) {
                    RequestPanel.this.timer.stop();
                }
                if (string.equals("1 second")) {
                    RequestPanel.this.timer.setDelay(1000);
                    RequestPanel.this.timer.start();
                }
                if (string.equals("2 seconds")) {
                    RequestPanel.this.timer.setDelay(2000);
                    RequestPanel.this.timer.start();
                }
                if (string.equals("5 seconds")) {
                    RequestPanel.this.timer.setDelay(5000);
                    RequestPanel.this.timer.start();
                }
                if (string.equals("10 seconds")) {
                    RequestPanel.this.timer.setDelay(10000);
                    RequestPanel.this.timer.start();
                }
            }
        });
        this.refreshButton = new JButton();
        this.refreshButton.setText("Refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestPanel.this.refresh();
            }
        });
        this.jPanel.add((Component)this.frequencyLabel, null);
        this.jPanel.add((Component)this.jComboBox, null);
        this.jPanel.add((Component)this.refreshButton, null);
        this.add((Component)this.jPanel, "South");
        this.requests = new NonEditableTableModel(new String[]{"Time", "Userid", "Type", "Request", "State", "Wait Time"});
        TableSorter tableSorter = new TableSorter(this.requests);
        JTable jTable = new JTable(tableSorter);
        tableSorter.addMouseListenerToHeaderInTable(jTable);
        jTable.setSelectionMode(1);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(125);
        tableColumn.setMinWidth(125);
        tableColumn.setMaxWidth(125);
        tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(70);
        tableColumn.setMinWidth(70);
        tableColumn.setMaxWidth(70);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(40);
        tableColumn.setMinWidth(40);
        tableColumn.setMaxWidth(40);
        tableColumn = jTable.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(90);
        tableColumn.setMinWidth(90);
        tableColumn.setMaxWidth(90);
        tableColumn = jTable.getColumnModel().getColumn(5);
        tableColumn.setPreferredWidth(80);
        tableColumn.setMinWidth(80);
        tableColumn.setMaxWidth(80);
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestPanel.this.refresh();
            }
        });
        this.jScrollPane = new JScrollPane(jTable);
        this.add((Component)this.jScrollPane, "Center");
    }

    public static String format(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = new Date(l);
        gregorianCalendar.setTime(date);
        Calendar calendar = Calendar.getInstance();
        String string = new String();
        if (gregorianCalendar.get(6) < calendar.get(6) || gregorianCalendar.get(1) < calendar.get(1)) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
            string = dateFormat.format(date);
        } else {
            DateFormat dateFormat = DateFormat.getTimeInstance(1);
            string = dateFormat.format(date);
        }
        return string;
    }

    void refresh() {
        try {
            while (this.requests.getRowCount() != 0) {
                this.requests.removeRow(0);
            }
            Request[] requestArray = this.admin.currentRequests();
            Object[] objectArray = new Object[6];
            if (requestArray.length > 0) {
                int n = 0;
                while (n < requestArray.length) {
                    objectArray[0] = RequestPanel.format(requestArray[n].getTime());
                    objectArray[1] = requestArray[n].getUserid();
                    objectArray[2] = requestArray[n].getType();
                    objectArray[3] = requestArray[n].getRequest().toString();
                    objectArray[4] = requestArray[n].getCurrentState();
                    objectArray[5] = Long.toString(System.currentTimeMillis() - requestArray[n].getTime());
                    this.requests.addRow(objectArray);
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

