/*
 * Decompiled with CFR 0.152.
 */
package com.kb.resourceManager;

import com.kb.admin.Admin;
import com.kb.client.QueryFailure;
import com.kb.client_server.LockInfo;
import com.kb.resourceManager.NonEditableTableModel;
import com.kb.resourceManager.RequestPanel;
import com.ow.gui.iode.IODEThrowableDisplayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.TableColumn;

public class LocksPanel
extends JPanel {
    Admin admin;
    JPanel jPanel;
    JButton refreshButton;
    JComboBox jComboBox;
    JLabel frequencyLabel;
    JScrollPane jScrollPane;
    JTable jTable;
    NonEditableTableModel locksData;
    Timer timer;

    public LocksPanel(Admin admin) {
        this.admin = admin;
        this.setLayout(new BorderLayout());
        this.jPanel = new JPanel();
        this.frequencyLabel = new JLabel();
        this.frequencyLabel.setText("Update Frequency");
        String[] stringArray = new String[]{"Never", "1 second", "2 seconds", "5 seconds", "10 seconds"};
        this.jComboBox = new JComboBox<String>(stringArray);
        this.jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)LocksPanel.this.jComboBox.getSelectedItem();
                if (string.equals("Never")) {
                    LocksPanel.this.timer.stop();
                }
                if (string.equals("1 second")) {
                    LocksPanel.this.timer.setDelay(1000);
                    LocksPanel.this.timer.start();
                }
                if (string.equals("2 seconds")) {
                    LocksPanel.this.timer.setDelay(2000);
                    LocksPanel.this.timer.start();
                }
                if (string.equals("5 seconds")) {
                    LocksPanel.this.timer.setDelay(5000);
                    LocksPanel.this.timer.start();
                }
                if (string.equals("10 seconds")) {
                    LocksPanel.this.timer.setDelay(10000);
                    LocksPanel.this.timer.start();
                }
            }
        });
        this.refreshButton = new JButton();
        this.refreshButton.setText("Refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LocksPanel.this.refresh();
            }
        });
        this.jPanel.add((Component)this.frequencyLabel, null);
        this.jPanel.add((Component)this.jComboBox, null);
        this.jPanel.add((Component)this.refreshButton, null);
        this.add((Component)this.jPanel, "South");
        this.locksData = new NonEditableTableModel(new String[]{"Lock", "Owner", "Time", "Mode", "Duration", "State"});
        JTable jTable = new JTable(this.locksData);
        jTable.setSelectionMode(1);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(125);
        tableColumn = jTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(125);
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LocksPanel.this.refresh();
            }
        });
        this.jScrollPane = new JScrollPane(jTable);
        this.add((Component)this.jScrollPane, "Center");
        this.refresh();
    }

    void refresh() {
        while (this.locksData.getRowCount() != 0) {
            this.locksData.removeRow(0);
        }
        try {
            LockInfo[] lockInfoArray = this.admin.locks();
            int n = 0;
            while (n < lockInfoArray.length) {
                Object[] objectArray = new Object[]{lockInfoArray[n].target, lockInfoArray[n].owner, RequestPanel.format(lockInfoArray[n].acquired), lockInfoArray[n].mode, lockInfoArray[n].duration, lockInfoArray[n].state};
                this.locksData.addRow(objectArray);
                ++n;
            }
        }
        catch (QueryFailure queryFailure) {
            new IODEThrowableDisplayer().handle(queryFailure);
        }
    }
}

