/*
 * Decompiled with CFR 0.152.
 */
package com.kb.resourceManager;

import com.kb.client.Database;
import com.kb.client.KBError;
import com.kb.gui.oms.AppWindow;
import com.kb.license.License;
import com.kb.license.NoLicense;
import com.kb.license.Verify;
import com.kb.resourceManager.HelpAction;
import com.kb.resourceManager.MyJMenuItem;
import com.ow.gui.iode.action.AboutWinAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class LicenseManager
extends JPanel {
    JTable table = new JTable();
    public static DataFlavor plain;

    public static void main(String[] stringArray) {
        AppWindow appWindow = new AppWindow("License manager");
        LicenseManager licenseManager = new LicenseManager();
        appWindow.setJMenuBar(licenseManager.setupMenus());
        appWindow.getContentPane().add(licenseManager);
        ((Window)appWindow).pack();
        ((Component)appWindow).setVisible(true);
    }

    LicenseManager() {
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.table));
        this.table.setDropTarget(new DropTarget(this.table, new Dropper()));
        this.refresh();
    }

    JMenuBar setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setText("Close");
        jMenuItem.setMnemonic('C');
        jMenuItem.setToolTipText("Exit the application");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseManager.getEnclosingFrame(LicenseManager.this).dispose();
            }
        });
        JMenu jMenu2 = new JMenu("Help");
        jMenu2.setMnemonic('H');
        jMenu2.add(new MyJMenuItem(new HelpAction(null, "com/kb/resourcemanager/licensemanager/LicenseManager.hs")));
        jMenu2.add(new MyJMenuItem(new AboutWinAction(null)));
        jMenuBar.add(jMenu);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu2);
        return jMenuBar;
    }

    public static JFrame getEnclosingFrame(Component component) {
        while (component != null) {
            if (component instanceof JFrame) {
                return (JFrame)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static File getWriteableLicenseDir() throws IOException {
        File[] fileArray = Verify.getLicenseLocations();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].canWrite()) {
                return fileArray[n];
            }
            ++n;
        }
        throw new IOException("No license directory");
    }

    void refresh() {
        Object[] objectArray = new String[]{"File", "Description", "Valid?"};
        DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[0][], objectArray);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        File[] fileArray = Verify.getLicenseLocations();
        int n = 0;
        while (n < fileArray.length) {
            Verify.findLicenseFiles(fileArray[n], arrayList);
            try {
                Verify.findLicenses(fileArray[n], arrayList2);
            }
            catch (NoLicense noLicense) {
                // empty catch block
            }
            ++n;
        }
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            try {
                License license = Verify.fetchLicense(new FileInputStream(file));
                String string = "Yes";
                try {
                    Verify.isValid(license, arrayList2);
                }
                catch (NoLicense noLicense) {
                    string = noLicense.getMessage();
                }
                defaultTableModel.addRow(new Object[]{file, license, string});
            }
            catch (NoLicense noLicense) {
                defaultTableModel.addRow(new Object[]{file, "-", "Not a license file"});
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (defaultTableModel.getRowCount() == 0) {
            defaultTableModel.addRow(new Object[]{"None", "", ""});
        }
        this.table.setModel(defaultTableModel);
    }

    static {
        try {
            plain = new DataFlavor("text/plain");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class Dropper
    implements DropTargetListener {
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDragEvent.acceptDrag(1);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                block15: {
                    try {
                        try {
                            dropTargetDropEvent.acceptDrop(1);
                            Transferable transferable = dropTargetDropEvent.getTransferable();
                            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                File file = (File)iterator.next();
                                Database.copyFile(file, new File(LicenseManager.getWriteableLicenseDir(), file.getName()), null);
                            }
                        }
                        catch (IOException iOException) {
                            JOptionPane.showMessageDialog(null, iOException.getMessage(), "Could not install", 0);
                            Object var7_14 = null;
                            dropTargetDropEvent.dropComplete(true);
                            break block15;
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            throw new KBError("Unexpected error", unsupportedFlavorException);
                        }
                        Object var7_13 = null;
                        dropTargetDropEvent.dropComplete(true);
                    }
                    catch (Throwable throwable) {
                        Object var7_15 = null;
                        dropTargetDropEvent.dropComplete(true);
                        throw throwable;
                    }
                }
                LicenseManager.this.refresh();
            } else if (dropTargetDropEvent.isDataFlavorSupported(plain)) {
                try {
                    try {
                        String string;
                        dropTargetDropEvent.acceptDrop(1);
                        Transferable transferable = dropTargetDropEvent.getTransferable();
                        Reader reader = plain.getReaderForText(transferable);
                        BufferedReader bufferedReader = new BufferedReader(reader);
                        while ((string = bufferedReader.readLine()) != null) {
                            System.out.println(string);
                        }
                    }
                    catch (Exception exception) {
                        Object var9_18 = null;
                        dropTargetDropEvent.dropComplete(true);
                    }
                    Object var9_17 = null;
                    dropTargetDropEvent.dropComplete(true);
                }
                catch (Throwable throwable) {
                    Object var9_19 = null;
                    dropTargetDropEvent.dropComplete(true);
                    throw throwable;
                }
                LicenseManager.this.refresh();
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
    }
}

