/*
 * Decompiled with CFR 0.152.
 */
package com.kb.resourceManager;

import com.kb.admin.Admin;
import com.kb.client.CommunicationsFailure;
import com.kb.client.Violation;
import com.kb.kbddutil.APISupport;
import com.kb.resourceManager.ICVTableModel;
import com.kb.resourceManager.MyCellRenderer;
import com.kb.resourceManager.TableSorter;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableColumn;

public class ICViolationsPanel
extends JPanel {
    Violation[] violations = new Violation[0];
    Admin admin;
    JScrollPane jScrollPane = new JScrollPane();
    JTable jTable;
    ICVTableModel model = new ICVTableModel();
    JButton recheckButton;
    JButton refreshButton;

    public ICViolationsPanel(Admin admin) {
        this.admin = admin;
        this.init();
    }

    void getData() throws CommunicationsFailure {
        this.model.setRowCount(0);
        if (!Beans.isDesignTime()) {
            this.violations = APISupport.convertViolations(this.admin.listICViolations());
            int n = 0;
            while (n < this.violations.length) {
                this.model.addRow(new Object[]{"Unchecked", this.violations[n].msg()});
                ++n;
            }
        }
    }

    private void init() {
        TableSorter tableSorter = new TableSorter(this.model);
        this.jTable = new JTable(tableSorter);
        tableSorter.addMouseListenerToHeaderInTable(this.jTable);
        TableColumn tableColumn = this.jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(70);
        tableColumn = this.jTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(250);
        tableColumn.setCellRenderer(new MyCellRenderer());
        this.jTable.setBorder(BorderFactory.createLineBorder(Color.black));
        this.jTable.setToolTipText("");
        this.jScrollPane.setViewportBorder(BorderFactory.createLineBorder(Color.black));
        this.jScrollPane.getViewport().setBackground(Color.lightGray);
        this.jScrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.jScrollPane.setToolTipText("");
        this.jScrollPane.getViewport().add((Component)this.jTable, null);
        this.refreshButton = new JButton("Refresh");
        this.refreshButton.setMnemonic('R');
        this.refreshButton.setDefaultCapable(true);
        this.refreshButton.addActionListener(new Refresh());
        this.recheckButton = new JButton();
        this.recheckButton.setMnemonic('C');
        this.recheckButton.setText("Recheck selected violations");
        this.recheckButton.addActionListener(new Frame1_recheckButton_actionAdapter(this));
        Border border = BorderFactory.createEmptyBorder(12, 12, 11, 11);
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.refreshButton);
        jPanel.add(this.recheckButton);
        this.add((Component)this.jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(11, 0, 0, 0), 0, 0));
    }

    void recheckButton_actionPerformed(ActionEvent actionEvent) {
        try {
            int n;
            int[] nArray = this.jTable.getSelectedRows();
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = n2 + 1;
                while (n3 < nArray.length) {
                    if (nArray[n2] > nArray[n3]) {
                        n = nArray[n2];
                        nArray[n2] = nArray[n3];
                        nArray[n3] = n;
                    }
                    ++n3;
                }
                ++n2;
            }
            n = nArray.length - 1;
            while (n >= 0) {
                if (this.admin.recheckIntegrityConstraintViolation(this.violations[nArray[n]])) {
                    this.jTable.setValueAt(new Date(), nArray[n], 0);
                } else {
                    this.model.removeRow(nArray[n]);
                }
                --n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void refresh() {
        try {
            this.getData();
        }
        catch (CommunicationsFailure communicationsFailure) {
            this.removeAll();
            this.add(new JTextArea("IC violation information not available\n" + communicationsFailure.getMessage()));
        }
    }

    class Frame1_recheckButton_actionAdapter
    implements ActionListener {
        ICViolationsPanel adaptee;

        Frame1_recheckButton_actionAdapter(ICViolationsPanel iCViolationsPanel2) {
            this.adaptee = iCViolationsPanel2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.adaptee.recheckButton_actionPerformed(actionEvent);
        }
    }

    class Refresh
    implements ActionListener {
        Refresh() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ICViolationsPanel.this.refresh();
        }
    }
}

