/*
 * Decompiled with CFR 0.152.
 */
package com.kb.resourceManager;

import com.kb.admin.RemoteAdmin;
import com.kb.apps.BulkLoader;
import com.kb.apps.QueryPane;
import com.kb.client.Database;
import com.kb.client.DatabaseState;
import com.kb.client.StartFailed;
import com.kb.client.StartFailedNoLicense;
import com.kb.gui.oms.AppWindow;
import com.kb.kbddutil.KBProperties;
import com.kb.oms.LoadWindow;
import com.kb.oms.OMSAPI;
import com.kb.resourceManager.LicenseManager;
import com.kb.resourceManager.LoginListener;
import com.kb.resourceManager.MyJMenuItem;
import com.kb.resourceManager.NoBorderTableCellRenderer;
import com.kb.resourceManager.PasswordPanel;
import com.kb.resourceManager.PropsTableModel;
import com.kb.resourceManager.ResourceManagerPanel;
import com.kb.resourceManager.ResourceTableModel;
import com.kb.resourceManager.TableSorter;
import com.kb.trans.script.DBGenerator;
import com.ow.gui.iode.IODEThrowableDisplayer;
import com.ow.gui.iode.action.AboutWinAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class DatabaseFrame
extends AppWindow {
    static final GridBagConstraints labelGBC = new GridBagConstraints();
    static final GridBagConstraints indentLabelGBC = new GridBagConstraints();
    static final GridBagConstraints lineEndGBC = new GridBagConstraints();
    static final GridBagConstraints lineMiddleGBC = new GridBagConstraints();
    static final GridBagConstraints lineEndButtonGBC = new GridBagConstraints();
    java.util.Timer databaseCheckTimer = new java.util.Timer(true);
    String javaExecutable = KBProperties.get("com.kb.java", "java");
    Action umlAction = new UMLAction();
    Action umlEditorAction = new UMLEditorAction();
    Action startAction = new StartAction();
    Action stopAction = new StopAction();
    Action propsAction = new PropsAction();
    Action browseAction = new BrowseAction();
    Action loadAction = new LoadAction();
    Action generateDDBAction = new GenerateDDBAction();
    Action generateOraDBAction = new GenerateOraDBAction();
    Action bulkLoadAction = new BulkLoadAction();
    Action emptyAction = new EmptyAction();
    Action deleteAction = new DeleteAction();
    Action queryAction = new QueryAction();
    Action cloneAction = new CloneAction();
    Action importAction = new ImportAction();
    JMenuBar menuBar = new JMenuBar();
    JMenu menuFile = new JMenu();
    JMenuItem menuFileExit = new JMenuItem();
    JMenuItem menuFileStart = new MyJMenuItem(this.startAction);
    JMenuItem menuFileStop = new MyJMenuItem(this.stopAction);
    JMenu menuRefresh = new JMenu();
    JMenu databaseMenu = new JMenu("Database");
    JMenu toolsMenu = new JMenu("Tools");
    JMenu omsMenu = new JMenu("OMS");
    JMenuItem cloneMenuItem;
    JMenuItem apiMenuItem;
    JMenuItem menufreq1;
    JRadioButtonMenuItem menufreq2;
    JRadioButtonMenuItem menufreq3;
    JRadioButtonMenuItem menufreq4;
    JRadioButtonMenuItem menufreq5;
    JRadioButtonMenuItem menufreq6;
    ButtonGroup frequenciesGroup;
    File databasesDir;
    Properties importedDBs;
    File databasesFile;
    Timer refresher;
    JScrollPane jScrollPane;
    JPanel rightPanel;
    JSplitPane jSplitPane;
    JTable databaseTable;
    TableSorter sorter;
    ResourceTableModel databaseTableModel;
    int counter;
    static /* synthetic */ Class class$java$lang$Object;

    public DatabaseFrame(String string) {
        super("Control Panel");
        this.omsMenu.setMnemonic('O');
        this.cloneMenuItem = new MyJMenuItem(this.cloneAction);
        this.apiMenuItem = new JMenuItem("API generator");
        this.menufreq1 = new JMenuItem();
        this.menufreq2 = new JRadioButtonMenuItem();
        this.menufreq3 = new JRadioButtonMenuItem();
        this.menufreq4 = new JRadioButtonMenuItem();
        this.menufreq5 = new JRadioButtonMenuItem();
        this.menufreq6 = new JRadioButtonMenuItem();
        this.frequenciesGroup = new ButtonGroup();
        this.frequenciesGroup.add(this.menufreq2);
        this.frequenciesGroup.add(this.menufreq3);
        this.frequenciesGroup.add(this.menufreq4);
        this.frequenciesGroup.add(this.menufreq5);
        this.frequenciesGroup.add(this.menufreq6);
        this.importedDBs = new Properties();
        URL uRL = ClassLoader.getSystemResource("databases");
        if (uRL == null) {
            try {
                this.importedDBs.store(new FileOutputStream(KBProperties.installDir() + "/databases"), "List of imported databases");
            }
            catch (Exception exception) {
                // empty catch block
            }
            uRL = ClassLoader.getSystemResource("databases");
        }
        if (uRL != null && "file".equals(uRL.getProtocol())) {
            this.databasesFile = new File(uRL.getFile());
            this.importAction.setEnabled(true);
        }
        this.rightPanel = new JPanel(new BorderLayout());
        this.counter = 0;
        try {
            this.enableEvents(64L);
            this.databasesDir = new File(string);
            this.initialize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.dispose();
        }
    }

    private void initialize() {
        this.jScrollPane = new JScrollPane();
        this.databaseTableModel = new ResourceTableModel();
        this.databaseTable = new JTable(this.databaseTableModel);
        this.databaseTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = DatabaseFrame.class$("java.lang.Object")) : class$java$lang$Object, new NoBorderTableCellRenderer());
        this.databaseTable.setSelectionMode(0);
        this.refresher = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseFrame.this.updateTable();
            }
        });
        this.updateTable();
        ListSelectionModel listSelectionModel = this.databaseTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DatabaseFrame.this.updateMenus();
            }
        });
        this.jScrollPane.setHorizontalScrollBarPolicy(30);
        this.jScrollPane.setVerticalScrollBarPolicy(20);
        this.jScrollPane.getViewport().setBackground(Color.lightGray);
        this.jScrollPane.getViewport().add((Component)this.databaseTable, null);
        this.jSplitPane = new JSplitPane(0, this.jScrollPane, this.rightPanel);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jSplitPane.setDividerLocation(-1);
        this.menuFile.setText("File");
        this.menuFile.setMnemonic('f');
        this.databaseMenu.add(this.menuFileStart);
        this.databaseMenu.add(this.menuFileStop);
        this.databaseMenu.add(new MyJMenuItem(this.propsAction));
        this.menuFile.add(new MyJMenuItem(new CloseAction()));
        this.menuFile.addSeparator();
        this.menuFile.add(new MyJMenuItem(this.importAction));
        this.menuFile.addSeparator();
        this.menuFileExit.setText("Exit");
        this.menuFileExit.setMnemonic('X');
        this.menuFileExit.setToolTipText("Exit the application");
        this.menuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.menuFile.add(this.menuFileExit);
        this.menuBar.add(this.menuFile);
        this.menuRefresh.setText("Refresh");
        this.menuRefresh.setMnemonic('r');
        this.menufreq1.setText("Now");
        this.menufreq1.setMnemonic('n');
        this.menufreq1.setToolTipText("Refresh the list of databases now");
        this.menufreq1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseFrame.this.menufreq1_actionPerformed(actionEvent);
            }
        });
        this.menuRefresh.add(this.menufreq1);
        this.menufreq2.setText("Never");
        this.menufreq2.setToolTipText("Stop automatic refresh of database list");
        this.menufreq2.setMnemonic('e');
        this.menufreq2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseFrame.this.menufreq2_actionPerformed(actionEvent);
            }
        });
        this.menuRefresh.add(this.menufreq2);
        this.menufreq3.setText("High");
        this.menufreq3.setMnemonic('H');
        this.menufreq3.setToolTipText("Automatically refresh database list every second");
        this.menufreq3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseFrame.this.menufreq3_actionPerformed(actionEvent);
            }
        });
        this.menuRefresh.add(this.menufreq3);
        this.menufreq4.setText("Medium");
        this.menufreq4.setToolTipText("Automatically refresh database list every 10 seconds");
        this.menufreq4.setMnemonic('M');
        this.menufreq4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseFrame.this.menufreq4_actionPerformed(actionEvent);
            }
        });
        this.menuRefresh.add(this.menufreq4);
        this.menufreq5.setText("Low");
        this.menufreq5.setToolTipText("Automatically refresh database list every 60 seconds");
        this.menufreq5.setMnemonic('L');
        this.menufreq5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseFrame.this.menufreq5_actionPerformed(actionEvent);
            }
        });
        this.menuRefresh.add(this.menufreq5);
        this.menufreq5.doClick();
        this.apiMenuItem.setMnemonic('A');
        this.apiMenuItem.setToolTipText("Start the STAPI generator on the selected database");
        this.apiMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseFrame.this.generateAPI();
            }
        });
        this.omsMenu.add(new MyJMenuItem(this.browseAction));
        this.omsMenu.add(new MyJMenuItem(this.loadAction));
        this.omsMenu.add(new MyJMenuItem(this.generateDDBAction));
        this.omsMenu.add(new MyJMenuItem(this.umlEditorAction));
        this.databaseMenu.add(new MyJMenuItem(this.queryAction));
        this.databaseMenu.add(new MyJMenuItem(this.bulkLoadAction));
        this.databaseMenu.add(this.cloneMenuItem);
        this.databaseMenu.add(this.apiMenuItem);
        this.databaseMenu.setMnemonic('D');
        this.databaseMenu.addSeparator();
        this.databaseMenu.add(new MyJMenuItem(this.emptyAction));
        this.databaseMenu.add(new MyJMenuItem(this.deleteAction));
        this.toolsMenu.add(new MyJMenuItem(new StartLicenseManager()));
        this.toolsMenu.setMnemonic('T');
        JMenu jMenu = new JMenu("Help");
        jMenu.setMnemonic('H');
        jMenu.add(new MyJMenuItem(new AboutWinAction(this)));
        this.menuFile.add(this.menuFileExit);
        this.menuBar.add(this.menuFile);
        this.menuBar.add(this.menuRefresh);
        this.menuBar.add(this.omsMenu);
        this.menuBar.add(this.databaseMenu);
        this.menuBar.add(this.toolsMenu);
        this.menuBar.add(jMenu);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.setBackground(Color.lightGray);
        container.add((Component)this.jSplitPane, "Center");
        this.setJMenuBar(this.menuBar);
        this.setTitle("Ontology Works Control Panel");
        ((Component)this).setSize(400, 400);
        this.pack();
        ((Component)this).setVisible(true);
        if (this.databaseTableModel.getRowCount() > 0) {
            this.databaseTable.addRowSelectionInterval(0, 0);
        }
    }

    void updateTable() {
        ResourceTableModel.Resource resource;
        Object object;
        File[] fileArray = this.databasesDir.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                arrayList.add(fileArray[n].getName());
            }
            ++n;
        }
        try {
            InputStream inputStream = ClassLoader.getSystemResourceAsStream("databases");
            if (inputStream != null) {
                this.importedDBs = new Properties();
                this.importedDBs.load(inputStream);
                object = ((Hashtable)this.importedDBs).keys();
                while (object.hasMoreElements()) {
                    arrayList.add((String)object.nextElement());
                }
            }
        }
        catch (IOException iOException) {
            new IODEThrowableDisplayer().handle(iOException);
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            object = (String)arrayList.get(n2);
            resource = this.databaseTableModel.getResource((String)object);
            if (resource == null) {
                try {
                    resource = this.databaseTableModel.addRow((String)object);
                }
                catch (IOException iOException) {
                    new IODEThrowableDisplayer().handle(iOException);
                }
            }
            ++n2;
        }
        int n3 = this.databaseTableModel.getRowCount() - 1;
        while (n3 >= 0) {
            resource = this.databaseTableModel.getRow(n3);
            if (!arrayList.contains(resource.getDatabaseName())) {
                this.databaseTableModel.removeRow(n3);
            }
            --n3;
        }
        int n4 = 0;
        while (n4 < this.databaseTableModel.getRowCount()) {
            this.checkDatabase(this.databaseTableModel.getRow(n4));
            ++n4;
        }
        boolean bl = this.databaseTableModel.getRowCount() > 0;
        this.databaseMenu.setEnabled(bl);
        this.omsMenu.setEnabled(bl);
        if (bl && this.databaseTable.getSelectedRow() == -1) {
            this.databaseTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void fileExit_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void startFailedMessage(ResourceTableModel.Resource resource, String string) {
        resource.setState(DatabaseState.Failed);
        resource.setPanel(null);
        JOptionPane.showMessageDialog(null, "See " + string, resource.getName() + " failed to start", 0);
    }

    void noLicenseMessage(ResourceTableModel.Resource resource, String string) {
        resource.setState(DatabaseState.Failed);
        resource.setPanel(null);
        JOptionPane.showMessageDialog(null, "Could not find a license for " + resource.getName(), "No license available", 0);
    }

    public void menufreq1_actionPerformed(ActionEvent actionEvent) {
        this.updateTable();
    }

    public void menufreq2_actionPerformed(ActionEvent actionEvent) {
        this.refresher.stop();
    }

    public void menufreq3_actionPerformed(ActionEvent actionEvent) {
        this.refresher.setDelay(1000);
        this.refresher.start();
    }

    public void menufreq4_actionPerformed(ActionEvent actionEvent) {
        this.refresher.setDelay(10000);
        this.refresher.start();
    }

    public void menufreq5_actionPerformed(ActionEvent actionEvent) {
        this.refresher.setDelay(60000);
        this.refresher.start();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            System.exit(0);
        }
    }

    void generateAPI() {
        try {
            ResourceTableModel.Resource resource = this.getSelectedRow();
            JFrame jFrame = (JFrame)Class.forName("com.kb.apigen.APIGenerator").getConstructors()[0].newInstance(resource.getURLString(), null, null);
            jFrame.pack();
            ((Component)jFrame).setVisible(true);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            JOptionPane.showMessageDialog(this, "Missing jvm.jar or tools.jar libraries for creating API:\n" + noClassDefFoundError.getMessage());
        }
        catch (Exception exception) {
            new IODEThrowableDisplayer().handle(exception);
        }
    }

    void startLoader() {
        final ResourceTableModel.Resource resource = this.getSelectedRow();
        new Thread("Starting loader " + resource.getDatabaseName()){

            public void run() {
                OMSAPI oMSAPI = new OMSAPI(resource.getURLString());
                new LoadWindow(oMSAPI, false).show();
            }
        }.start();
    }

    void cloneDatabase() {
        Object object;
        File file;
        File file2;
        ResourceTableModel.Resource resource;
        block2: {
            int n;
            resource = this.getSelectedRow();
            file2 = new File(resource.getDir());
            file = null;
            do {
                file = null;
                object = JOptionPane.showInputDialog(this, "Enter name of new copy:", "Clone " + resource.getName(), 3, null, null, "Copy of " + resource.getName());
                if (object == null || !(file = new File(file2.getParent(), object.toString())).exists() || (n = JOptionPane.showConfirmDialog(null, file + " already exists; overwrite?")) == 0) break block2;
            } while (n != 2);
            return;
        }
        if (file != null) {
            object = new ProgressMonitor(null, "Copying " + file2 + " to " + file, null, 0, 100);
            ((ProgressMonitor)object).setProgress(0);
            ((ProgressMonitor)object).setMillisToDecideToPopup(0);
            ((ProgressMonitor)object).setMillisToPopup(0);
            File file3 = file;
            new Thread((ProgressMonitor)object, resource, file3, "Cloning " + file2){
                private final /* synthetic */ ProgressMonitor val$monitor;
                private final /* synthetic */ Database val$db;
                private final /* synthetic */ File val$fDest;
                {
                    this.val$monitor = progressMonitor;
                    this.val$db = database;
                    this.val$fDest = file;
                }

                public void run() {
                    block5: {
                        try {
                            try {
                                this.val$monitor.setProgress(1);
                                this.val$db.clone(this.val$fDest, this.val$monitor);
                                DatabaseFrame.this.updateTable();
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                JOptionPane.showMessageDialog(null, "Cannot clone:\n" + fileNotFoundException.getMessage(), "Clone failed", 0);
                                Object var4_2 = null;
                                this.val$monitor.close();
                                break block5;
                            }
                            catch (Exception exception) {
                                new IODEThrowableDisplayer().handle(exception);
                                Object var4_3 = null;
                                this.val$monitor.close();
                            }
                            Object var4_1 = null;
                            this.val$monitor.close();
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            this.val$monitor.close();
                            throw throwable;
                        }
                    }
                }
            }.start();
        }
    }

    public void updateMenus() {
        final ResourceTableModel.Resource resource = this.getSelectedRow();
        if (resource == null) {
            this.setRightPanel(new JTextField("Select a database"));
        } else if (resource.getState() == DatabaseState.Started) {
            this.startAction.setEnabled(false);
            this.stopAction.setEnabled(true);
            this.browseAction.setEnabled(true);
            this.cloneAction.setEnabled(false);
            this.generateDDBAction.setEnabled(true);
            this.generateOraDBAction.setEnabled(true);
            this.bulkLoadAction.setEnabled(true);
            this.loadAction.setEnabled(true);
            this.umlAction.setEnabled(true);
            this.umlEditorAction.setEnabled(true);
            this.apiMenuItem.setEnabled(true);
            this.emptyAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
            this.queryAction.setEnabled(false);
            JPanel jPanel = resource.getPanel();
            if (jPanel != null) {
                this.setRightPanel(jPanel);
            } else {
                String string = resource.getName();
                final PasswordPanel passwordPanel = new PasswordPanel(string);
                resource.setPanel(passwordPanel);
                this.setRightPanel(passwordPanel);
                passwordPanel.addLoginListener(new LoginListener(){

                    public void login() {
                        RemoteAdmin remoteAdmin = passwordPanel.getRemoteAdmin();
                        ResourceManagerPanel resourceManagerPanel = new ResourceManagerPanel(remoteAdmin);
                        DatabaseFrame.this.setRightPanel(resourceManagerPanel);
                        resource.setPanel(resourceManagerPanel);
                    }
                });
            }
        } else {
            this.startAction.setEnabled(true);
            this.stopAction.setEnabled(false);
            this.browseAction.setEnabled(false);
            this.cloneAction.setEnabled(true);
            this.generateDDBAction.setEnabled(false);
            this.generateOraDBAction.setEnabled(false);
            this.loadAction.setEnabled(false);
            this.umlAction.setEnabled(false);
            this.umlEditorAction.setEnabled(false);
            this.apiMenuItem.setEnabled(false);
            this.bulkLoadAction.setEnabled(false);
            this.emptyAction.setEnabled(true);
            this.deleteAction.setEnabled(true);
            this.queryAction.setEnabled(false);
            this.setRightPanel(new JTextField("Database stopped"));
        }
    }

    void setRightPanel(JComponent jComponent) {
        JPanel jPanel = this.rightPanel;
        synchronized (jPanel) {
            if (this.rightPanel.getComponentCount() == 0 || this.rightPanel.getComponent(0) != jComponent) {
                this.rightPanel.removeAll();
                this.rightPanel.add((Component)jComponent, "Center");
                this.rightPanel.validate();
                this.rightPanel.repaint();
            }
        }
    }

    void checkDatabase(final ResourceTableModel.Resource resource) {
        if (resource.isCloning()) {
            resource.setState(DatabaseState.Cloning);
            this.updateMenus();
            return;
        }
        if (resource.isGenerating()) {
            resource.setState(DatabaseState.Generating);
            this.updateMenus();
            return;
        }
        new Thread("Checking " + resource.getName()){

            public void run() {
                boolean bl = resource.isStarted();
                DatabaseState databaseState = resource.getState();
                if (bl) {
                    if (databaseState != DatabaseState.Stopping) {
                        resource.setState(DatabaseState.Started);
                    }
                } else if (databaseState != DatabaseState.Failed && databaseState != DatabaseState.Starting) {
                    resource.setState(DatabaseState.Stopped);
                    resource.setPanel(null);
                }
                DatabaseFrame.this.updateMenus();
            }
        }.start();
    }

    void saveDatabases() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.databasesFile.getAbsolutePath());
            this.importedDBs.store(fileOutputStream, "List of databases name=URL");
        }
        catch (IOException iOException) {
            new IODEThrowableDisplayer().handle(iOException);
        }
    }

    boolean selectedRowActiveOMS() {
        ResourceTableModel.Resource resource = this.getSelectedRow();
        return resource.getState() == DatabaseState.Started && resource.isOMS();
    }

    public static void deleteDatabase(Database database) {
        ProgressMonitor progressMonitor = new ProgressMonitor(null, "Deleting " + database, null, 0, 100);
        progressMonitor.setMillisToDecideToPopup(0);
        progressMonitor.setMillisToPopup(0);
        try {
            database.delete(progressMonitor);
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(null, throwable.getMessage(), "Delete failed", 0);
        }
        progressMonitor.close();
    }

    public void deleteData(Database database) {
        int n = JOptionPane.showConfirmDialog(this, "Delete all data from " + database.getDatabaseName() + "?\n" + "NOTE: OMS databases should NOT be emptied", "Confirm empty", 0);
        if (n == 0) {
            ProgressMonitor progressMonitor = new ProgressMonitor(null, "Emptying " + database, null, 0, 100);
            progressMonitor.setMillisToDecideToPopup(0);
            progressMonitor.setMillisToPopup(0);
            try {
                database.deleteData(progressMonitor);
            }
            catch (Throwable throwable) {
                JOptionPane.showMessageDialog(this, "Cannot delete " + throwable.getMessage(), "Empty failed", 0);
            }
            progressMonitor.close();
        }
    }

    ResourceTableModel.Resource getSelectedRow() {
        int n = this.databaseTable.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return this.databaseTableModel.getRow(n);
    }

    String getSelectedDatabase() {
        return this.getSelectedRow().getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DatabaseFrame.labelGBC.anchor = 17;
        DatabaseFrame.labelGBC.ipadx = 12;
        DatabaseFrame.labelGBC.ipady = 10;
        DatabaseFrame.indentLabelGBC.anchor = 17;
        DatabaseFrame.indentLabelGBC.ipadx = 12;
        DatabaseFrame.indentLabelGBC.ipady = 10;
        DatabaseFrame.indentLabelGBC.insets = new Insets(0, 12, 0, 0);
        DatabaseFrame.lineEndGBC.gridwidth = 0;
        DatabaseFrame.lineEndGBC.weightx = 1.0;
        DatabaseFrame.lineEndGBC.anchor = 17;
        DatabaseFrame.lineMiddleGBC.weightx = 1.0;
        DatabaseFrame.lineMiddleGBC.fill = 2;
        DatabaseFrame.lineEndButtonGBC.gridwidth = 0;
    }

    class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            super("Delete database...");
            this.putValue("ShortDescription", "Delete or un-import the database.");
            this.putValue("MnemonicKey", new Integer(69));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = DatabaseFrame.this.getSelectedRow().getName();
            new Thread(this, string, "Deleting " + string){
                private final /* synthetic */ String val$key;
                private final /* synthetic */ DeleteAction this$1;
                {
                    this.this$1 = deleteAction;
                    this.val$key = string;
                }

                public void run() {
                    int n = JOptionPane.showConfirmDialog(null, "Delete " + this.val$key + "?", "Confirm delete", 0);
                    if (n == 0) {
                        if (((Hashtable)DeleteAction.access$500((DeleteAction)this.this$1).importedDBs).get(this.val$key) != null) {
                            ((Hashtable)DeleteAction.access$500((DeleteAction)this.this$1).importedDBs).remove(this.val$key);
                            DeleteAction.access$500(this.this$1).saveDatabases();
                        } else {
                            DatabaseFrame.deleteDatabase(DeleteAction.access$500(this.this$1).getSelectedRow());
                        }
                        DeleteAction.access$500(this.this$1).updateTable();
                    }
                }
            }.start();
        }

        public void setEnabled(boolean bl) {
            DatabaseState databaseState = DatabaseFrame.this.getSelectedRow().getState();
            if (databaseState == DatabaseState.Stopped || databaseState == DatabaseState.Failed) {
                super.setEnabled(true);
            } else {
                super.setEnabled(false);
            }
        }

        static /* synthetic */ DatabaseFrame access$500(DeleteAction deleteAction) {
            return deleteAction.DatabaseFrame.this;
        }
    }

    class QueryAction
    extends AbstractAction {
        QueryAction() {
            super("Query tool");
            this.putValue("ShortDescription", "Starts a query tool on the database.");
            this.putValue("MnemonicKey", new Integer(113));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = DatabaseFrame.this.getSelectedRow().getURLString();
            QueryPane.main(new String[]{string});
        }

        public void setEnabled(boolean bl) {
            DatabaseState databaseState = DatabaseFrame.this.getSelectedRow().getState();
            if (databaseState == DatabaseState.Started) {
                super.setEnabled(true);
            } else {
                super.setEnabled(false);
            }
        }
    }

    class EmptyAction
    extends AbstractAction {
        EmptyAction() {
            super("Empty database...");
            this.putValue("ShortDescription", "Delete all data from the database.");
            this.putValue("MnemonicKey", new Integer(69));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new Thread(this, "Empting " + DatabaseFrame.this.getSelectedRow().getDatabaseName()){
                private final /* synthetic */ EmptyAction this$1;
                {
                    this.this$1 = emptyAction;
                }

                public void run() {
                    EmptyAction.access$400(this.this$1).deleteData(EmptyAction.access$400(this.this$1).getSelectedRow());
                }
            }.start();
        }

        public void setEnabled(boolean bl) {
            DatabaseState databaseState = DatabaseFrame.this.getSelectedRow().getState();
            if (databaseState == DatabaseState.Stopped || databaseState == DatabaseState.Failed) {
                super.setEnabled(true);
            } else {
                super.setEnabled(false);
            }
        }

        static /* synthetic */ DatabaseFrame access$400(EmptyAction emptyAction) {
            return emptyAction.DatabaseFrame.this;
        }
    }

    class BulkLoadAction
    extends AbstractAction {
        BulkLoadAction() {
            super("Bulk loader");
            this.putValue("ShortDescription", "Start the bulk data loader");
            this.putValue("MnemonicKey", new Integer(66));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new Thread(this, "Bulk loader " + DatabaseFrame.this.getSelectedRow().getName()){
                private final /* synthetic */ BulkLoadAction this$1;
                {
                    this.this$1 = bulkLoadAction;
                }

                public void run() {
                    BulkLoader.main(new String[]{BulkLoadAction.access$300(this.this$1).getSelectedRow().getURLString()});
                }
            }.start();
        }

        public void setEnabled(boolean bl) {
            if (DatabaseFrame.this.getSelectedRow().getState() == DatabaseState.Started) {
                super.setEnabled(true);
            } else {
                super.setEnabled(false);
            }
        }

        static /* synthetic */ DatabaseFrame access$300(BulkLoadAction bulkLoadAction) {
            return bulkLoadAction.DatabaseFrame.this;
        }
    }

    class GenerateOraDBAction
    extends AbstractAction {
        GenerateOraDBAction() {
            super("Generate Oracle DB");
            this.putValue("ShortDescription", "Start the OraDB generator wizard");
            this.putValue("MnemonicKey", new Integer(79));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResourceTableModel.Resource resource = DatabaseFrame.this.getSelectedRow();
            OMSAPI oMSAPI = new OMSAPI(resource.getURLString());
        }

        public void setEnabled(boolean bl) {
            ResourceTableModel.Resource resource = DatabaseFrame.this.getSelectedRow();
            if (resource.getState() == DatabaseState.Started && resource.isOMS()) {
                super.setEnabled(true);
            } else {
                super.setEnabled(false);
            }
        }
    }

    class GenerateDDBAction
    extends AbstractAction {
        GenerateDDBAction() {
            super("Generate Deductive DB");
            this.putValue("ShortDescription", "Start the DDB generator wizard");
            this.putValue("MnemonicKey", new Integer(71));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResourceTableModel.Resource resource = DatabaseFrame.this.getSelectedRow();
            new Thread(this, resource, "Database generator " + resource.getURLString()){
                private final /* synthetic */ Database val$db;
                private final /* synthetic */ GenerateDDBAction this$1;
                {
                    this.this$1 = generateDDBAction;
                    this.val$db = database;
                }

                public void run() {
                    try {
                        OMSAPI oMSAPI = new OMSAPI(this.val$db.getURLString());
                        DBGenerator dBGenerator = new DBGenerator(oMSAPI, "Wizard");
                        dBGenerator.startOracle();
                    }
                    catch (Throwable throwable) {
                        new IODEThrowableDisplayer().handle(throwable);
                    }
                }
            }.start();
        }

        public void setEnabled(boolean bl) {
            ResourceTableModel.Resource resource = DatabaseFrame.this.getSelectedRow();
            if (resource.getState() == DatabaseState.Started && resource.isOMS()) {
                super.setEnabled(true);
            } else {
                super.setEnabled(false);
            }
        }
    }

    class LoadedFilesAction
    extends AbstractAction {
        LoadedFilesAction() {
            super("Show loaded files");
            this.putValue("ShortDescription", "Display a list of files loaded into the OMS");
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResourceTableModel.Resource resource = DatabaseFrame.this.getSelectedRow();
            new Thread(this, "Checking loaded files"){
                private final /* synthetic */ LoadedFilesAction this$1;
                {
                    this.this$1 = loadedFilesAction;
                }

                public void run() {
                }
            }.start();
        }

        public void setEnabled(boolean bl) {
            this.setEnabled(false);
            ResourceTableModel.Resource resource = DatabaseFrame.this.getSelectedRow();
            if (resource.getState() == DatabaseState.Started && resource.isOMS()) {
                super.setEnabled(true);
            } else {
                super.setEnabled(false);
            }
        }
    }

    class LoadAction
    extends AbstractAction {
        LoadAction() {
            super("Load OWL");
            this.putValue("ShortDescription", "Load OWL into this OMS");
            this.putValue("MnemonicKey", new Integer(76));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DatabaseFrame.this.startLoader();
        }

        public void setEnabled(boolean bl) {
            ResourceTableModel.Resource resource = DatabaseFrame.this.getSelectedRow();
            if (resource.getState() == DatabaseState.Started && resource.isOMS()) {
                super.setEnabled(true);
            } else {
                super.setEnabled(false);
            }
        }
    }

    class UMLEditorAction
    extends AbstractAction {
        UMLEditorAction() {
            super("UML Editor");
            this.putValue("ShortDescription", "Start the UML Editor");
            this.putValue("MnemonicKey", new Integer(69));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = DatabaseFrame.this.getSelectedRow().getURLString();
                Class.forName("com.kb.uml.UMLEditor").getMethod("main", new String[0].getClass()).invoke(null, new Object[]{new String[]{string}});
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                JOptionPane.showMessageDialog(DatabaseFrame.this, "UML Editor not installed");
            }
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(DatabaseFrame.this.selectedRowActiveOMS());
        }
    }

    class UMLAction
    extends AbstractAction {
        UMLAction() {
            super("UML Browser");
            this.putValue("ShortDescription", "Start the UML Browser");
            this.putValue("MnemonicKey", new Integer(85));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = DatabaseFrame.this.getSelectedRow().getURLString();
                Class.forName("com.kb.uml.UML").getMethod("main", new String[0].getClass()).invoke(null, new Object[]{new String[]{string}});
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                JOptionPane.showMessageDialog(DatabaseFrame.this, "UML not installed");
            }
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(DatabaseFrame.this.selectedRowActiveOMS());
        }
    }

    class ImportAction
    extends AbstractAction {
        ImportAction() {
            super("Import...");
            if (DatabaseFrame.this.importedDBs == null) {
                this.setEnabled(false);
            }
            this.putValue("ShortDescription", "Import an existing database");
            this.putValue("LongDescription", "Adds an existing database to the list of databases on the control panel.");
            this.putValue("MnemonicKey", new Integer(73));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block3: {
                String string;
                JPanel jPanel = new JPanel(new GridBagLayout());
                JLabel jLabel = new JLabel("Name");
                JTextField jTextField = new JTextField(30);
                jLabel.setLabelFor(jTextField);
                JRadioButton jRadioButton = new JRadioButton("Local");
                JRadioButton jRadioButton2 = new JRadioButton("Remote");
                JTextField jTextField2 = new JTextField(40);
                JTextField jTextField3 = new JTextField(40);
                JLabel jLabel2 = new JLabel("URL");
                jLabel2.setLabelFor(jTextField2);
                JLabel jLabel3 = new JLabel("Directory");
                jLabel3.setLabelFor(jTextField3);
                JButton jButton = new JButton("Browse");
                jButton.addActionListener(new ActionListener(this, jTextField3){
                    private final /* synthetic */ JTextField val$file;
                    private final /* synthetic */ ImportAction this$1;
                    {
                        this.this$1 = importAction;
                        this.val$file = jTextField;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setFileSelectionMode(1);
                        int n = jFileChooser.showOpenDialog(ImportAction.access$200(this.this$1));
                        if (n == 0) {
                            this.val$file.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                        }
                    }
                });
                jRadioButton.addItemListener(new ItemListener(this, jLabel3, jRadioButton, jTextField3, jButton){
                    private final /* synthetic */ JLabel val$fileLabel;
                    private final /* synthetic */ JRadioButton val$localButton;
                    private final /* synthetic */ JTextField val$file;
                    private final /* synthetic */ JButton val$browse;
                    private final /* synthetic */ ImportAction this$1;
                    {
                        this.this$1 = importAction;
                        this.val$fileLabel = jLabel;
                        this.val$localButton = jRadioButton;
                        this.val$file = jTextField;
                        this.val$browse = jButton;
                    }

                    public void itemStateChanged(ItemEvent itemEvent) {
                        this.val$fileLabel.setEnabled(this.val$localButton.isSelected());
                        this.val$file.setEnabled(this.val$localButton.isSelected());
                        this.val$browse.setEnabled(this.val$localButton.isSelected());
                    }
                });
                jRadioButton2.addItemListener(new ItemListener(this, jLabel2, jRadioButton2, jTextField2){
                    private final /* synthetic */ JLabel val$urlLabel;
                    private final /* synthetic */ JRadioButton val$remoteButton;
                    private final /* synthetic */ JTextField val$url;
                    private final /* synthetic */ ImportAction this$1;
                    {
                        this.this$1 = importAction;
                        this.val$urlLabel = jLabel;
                        this.val$remoteButton = jRadioButton;
                        this.val$url = jTextField;
                    }

                    public void itemStateChanged(ItemEvent itemEvent) {
                        this.val$urlLabel.setEnabled(this.val$remoteButton.isSelected());
                        this.val$url.setEnabled(this.val$remoteButton.isSelected());
                    }
                });
                jPanel.add((Component)jRadioButton, lineEndGBC);
                jPanel.add((Component)jLabel3, indentLabelGBC);
                jPanel.add((Component)jTextField3, lineMiddleGBC);
                jPanel.add((Component)jButton, lineEndButtonGBC);
                jPanel.add((Component)jRadioButton2, lineEndGBC);
                jPanel.add((Component)jLabel2, indentLabelGBC);
                jPanel.add((Component)jTextField2, lineEndGBC);
                jPanel.add((Component)jLabel, labelGBC);
                jPanel.add((Component)jTextField, lineEndGBC);
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(jRadioButton);
                buttonGroup.add(jRadioButton2);
                jRadioButton.setSelected(true);
                jRadioButton2.setSelected(false);
                PlainDocument plainDocument = new PlainDocument();
                ((JTextComponent)jTextField2).setDocument(plainDocument);
                PlainDocument plainDocument2 = new PlainDocument();
                ((JTextComponent)jTextField3).setDocument(plainDocument2);
                DocumentListener documentListener = new DocumentListener(this, jTextField){
                    private final /* synthetic */ JTextField val$name;
                    private final /* synthetic */ ImportAction this$1;
                    {
                        this.this$1 = importAction;
                        this.val$name = jTextField;
                    }

                    public void changedUpdate(DocumentEvent documentEvent) {
                        this.set(documentEvent);
                    }

                    public void insertUpdate(DocumentEvent documentEvent) {
                        this.set(documentEvent);
                    }

                    public void removeUpdate(DocumentEvent documentEvent) {
                        this.set(documentEvent);
                    }

                    public void set(DocumentEvent documentEvent) {
                        Document document = documentEvent.getDocument();
                        try {
                            String string = document.getText(0, document.getLength());
                            string = string.replace('\\', '/');
                            int n = string.lastIndexOf(47);
                            if (n >= 0) {
                                string = string.substring(n + 1);
                            }
                            this.val$name.setText(string);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                plainDocument.addDocumentListener(documentListener);
                plainDocument2.addDocumentListener(documentListener);
                while (true) {
                    JOptionPane jOptionPane = new JOptionPane(jPanel, -1, 2);
                    JDialog jDialog = jOptionPane.createDialog(null, "Import database");
                    jDialog.show();
                    int n = 2;
                    try {
                        n = (Integer)jOptionPane.getValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n != 0) break block3;
                    string = jTextField.getText();
                    if (DatabaseFrame.this.databaseTableModel.getResource(string) == null) break;
                    JOptionPane.showMessageDialog(null, "There is already a database named " + string, "Cannot import " + string, 0);
                }
                String string2 = jRadioButton.isSelected() ? "local:" + jTextField3.getText() : jTextField2.getText();
                ((Hashtable)DatabaseFrame.this.importedDBs).put(string, string2);
                DatabaseFrame.this.saveDatabases();
                DatabaseFrame.this.updateTable();
            }
        }

        static /* synthetic */ DatabaseFrame access$200(ImportAction importAction) {
            return importAction.DatabaseFrame.this;
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            super("Close");
            this.putValue("ShortDescription", "Close this window");
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DatabaseFrame.this.fileExit_actionPerformed(actionEvent);
        }
    }

    class StopAction
    extends AbstractAction {
        StopAction() {
            super("Stop");
            this.putValue("ShortDescription", "Stop the selected datbase");
            this.putValue("MnemonicKey", new Integer(84));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResourceTableModel.Resource resource = DatabaseFrame.this.getSelectedRow();
            String string = resource.getName();
            resource.setPanel(null);
            resource.setState(DatabaseState.Stopping);
            new Thread(this, string, "Stopping " + resource.getDatabaseName()){
                private final /* synthetic */ String val$selectedDatabase;
                private final /* synthetic */ StopAction this$1;
                {
                    this.this$1 = stopAction;
                    this.val$selectedDatabase = string;
                }

                public void run() {
                    try {
                        new RemoteAdmin(this.val$selectedDatabase).stop();
                    }
                    catch (Exception exception) {
                        new IODEThrowableDisplayer().handle(exception);
                    }
                }
            }.start();
            DatabaseFrame.this.databaseCheckTimer.scheduleAtFixedRate(new TimerTask(this, resource, string){
                int times;
                public static final int max = 5;
                private final /* synthetic */ ResourceTableModel.Resource val$row;
                private final /* synthetic */ String val$selectedDatabase;
                private final /* synthetic */ StopAction this$1;
                {
                    this.this$1 = stopAction;
                    this.val$row = resource;
                    this.val$selectedDatabase = string;
                    this.times = 0;
                }

                public void run() {
                    ++this.times;
                    boolean bl = this.val$row.isStarted();
                    if (!bl) {
                        this.val$row.setState(DatabaseState.Stopped);
                        StopAction.access$100(this.this$1).updateMenus();
                        this.cancel();
                    } else if (this.times == 5) {
                        this.val$row.setState(DatabaseState.Unknown);
                        JOptionPane.showMessageDialog(null, this.val$selectedDatabase + " failed to stop", this.val$selectedDatabase + " failed to stop", 0);
                    }
                }
            }, 0L, 1000L);
        }

        static /* synthetic */ DatabaseFrame access$100(StopAction stopAction) {
            return stopAction.DatabaseFrame.this;
        }
    }

    class PropsAction
    extends AbstractAction {
        PropsAction() {
            super("Properties");
            this.putValue("ShortDescription", "Display properties of the selected database");
            this.putValue("MnemonicKey", new Integer(80));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResourceTableModel.Resource resource = DatabaseFrame.this.getSelectedRow();
            String string = resource.getName();
            JTable jTable = new JTable(new PropsTableModel(resource));
            JOptionPane.showMessageDialog(DatabaseFrame.this, new JScrollPane(jTable), string, 1);
        }
    }

    class CloneAction
    extends AbstractAction {
        CloneAction() {
            super("Clone...");
            this.putValue("ShortDescription", "Clone the selected database");
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DatabaseFrame.this.cloneDatabase();
        }

        public void setEnabled(boolean bl) {
            DatabaseState databaseState = DatabaseFrame.this.getSelectedRow().getState();
            super.setEnabled(databaseState != DatabaseState.Cloning && databaseState != DatabaseState.Building);
        }
    }

    class StartAction
    extends AbstractAction {
        StartAction() {
            super("Start");
            this.putValue("ShortDescription", "Start the selected database");
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setEnabled(false);
            ResourceTableModel.Resource resource = DatabaseFrame.this.getSelectedRow();
            String string = resource.getDatabaseName();
            resource.setState(DatabaseState.Starting);
            new File("logs").mkdirs();
            String string2 = "logs/log." + string + "." + DatabaseFrame.this.counter++;
            DatabaseFrame.this.updateMenus();
            new Thread(this, resource, string2, "Starting " + resource.getDatabaseName()){
                private final /* synthetic */ ResourceTableModel.Resource val$row;
                private final /* synthetic */ String val$trace;
                private final /* synthetic */ StartAction this$1;
                {
                    this.this$1 = startAction;
                    this.val$row = resource;
                    this.val$trace = string;
                }

                public void run() {
                    try {
                        this.val$row.startAndWait(this.val$trace, 200);
                        this.val$row.setState(DatabaseState.Started);
                        StartAction.access$000(this.this$1).updateMenus();
                    }
                    catch (StartFailedNoLicense startFailedNoLicense) {
                        StartAction.access$000(this.this$1).noLicenseMessage(this.val$row, this.val$trace);
                    }
                    catch (StartFailed startFailed) {
                        StartAction.access$000(this.this$1).startFailedMessage(this.val$row, this.val$trace);
                    }
                    catch (Exception exception) {
                        new IODEThrowableDisplayer().handle(exception);
                    }
                }
            }.start();
        }

        public void setEnabled(boolean bl) {
            DatabaseState databaseState = DatabaseFrame.this.getSelectedRow().getState();
            if (databaseState == DatabaseState.Stopped || databaseState == DatabaseState.Failed) {
                super.setEnabled(true);
            } else {
                super.setEnabled(false);
            }
        }

        static /* synthetic */ DatabaseFrame access$000(StartAction startAction) {
            return startAction.DatabaseFrame.this;
        }
    }

    class BrowseAction
    extends AbstractAction {
        BrowseAction() {
            super("Browse");
            this.putValue("ShortDescription", "Browse the selected database");
            this.putValue("MnemonicKey", new Integer(66));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ResourceTableModel.Resource resource = DatabaseFrame.this.getSelectedRow();
            String string = resource.getName();
            String string2 = resource.getURLString();
            try {
                Process process = Runtime.getRuntime().exec(new String[]{DatabaseFrame.this.javaExecutable, "-Ddatabase=" + string2, "com.ow.gui.iode.IODE"});
            }
            catch (IOException iOException) {
                new IODEThrowableDisplayer().handle(iOException);
            }
        }

        public void setEnabled(boolean bl) {
            ResourceTableModel.Resource resource = DatabaseFrame.this.getSelectedRow();
            if (resource.getState() == DatabaseState.Started && resource.isOMS()) {
                super.setEnabled(true);
            } else {
                super.setEnabled(false);
            }
        }
    }

    class StartLicenseManager
    extends AbstractAction {
        StartLicenseManager() {
            super("License Manager");
            this.putValue("ShortDescription", "Opens the license manager");
            this.putValue("MnemonicKey", new Integer(76));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LicenseManager.main(new String[0]);
        }
    }
}

