/*
 * Decompiled with CFR 0.152.
 */
package com.kb.resourceManager;

import com.kb.admin.Admin;
import com.kb.resourceManager.AdminSubJTable;
import com.kb.resourceManager.EditUserDialog;
import com.kb.resourceManager.TableSorter;
import com.kb.resourceManager.Users;
import com.ow.gui.iode.IODEThrowableDisplayer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AdminMaintenancePanel
extends JPanel {
    Admin admin;
    String[] useridlist = new String[0];
    JScrollPane jScrollPane;
    AdminSubJTable jTable;
    Users users;
    JPanel jPanel;
    JButton addButton;
    JButton editButton;
    JButton deleteButton;

    public AdminMaintenancePanel(Admin admin) {
        this.admin = admin;
        try {
            this.init();
        }
        catch (Throwable throwable) {
            this.removeAll();
            new IODEThrowableDisplayer().handle(throwable);
            this.add(new JLabel("Database failed"));
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.jScrollPane = new JScrollPane();
        if (!Beans.isDesignTime()) {
            this.useridlist = this.admin.allUsers();
        }
        this.users = new Users(this.useridlist);
        TableSorter tableSorter = new TableSorter(this.users);
        this.jTable = new AdminSubJTable(tableSorter);
        tableSorter.addMouseListenerToHeaderInTable(this.jTable);
        ListSelectionModel listSelectionModel = this.jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (AdminMaintenancePanel.this.jTable.getSelectedRow() != -1) {
                    AdminMaintenancePanel.this.deleteButton.setEnabled(true);
                    AdminMaintenancePanel.this.editButton.setEnabled(true);
                } else {
                    AdminMaintenancePanel.this.deleteButton.setEnabled(false);
                    AdminMaintenancePanel.this.editButton.setEnabled(false);
                }
            }
        });
        this.jScrollPane.getViewport().add((Component)this.jTable, null);
        this.jPanel = new JPanel();
        this.addButton = new JButton();
        this.addButton.setMnemonic('A');
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminMaintenancePanel.this.addButton_actionPerformed(actionEvent);
            }
        });
        this.editButton = new JButton();
        this.editButton.setMnemonic('E');
        this.editButton.setText("Edit");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminMaintenancePanel.this.editButton_actionPerformed(actionEvent);
            }
        });
        this.editButton.setEnabled(false);
        this.deleteButton = new JButton();
        this.deleteButton.setMnemonic('D');
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdminMaintenancePanel.this.deleteButton_actionPerformed(actionEvent);
            }
        });
        this.deleteButton.setEnabled(false);
        GridLayout gridLayout = new GridLayout();
        this.jPanel.setLayout(gridLayout);
        gridLayout.setHgap(5);
        this.jPanel.add((Component)this.addButton, null);
        this.jPanel.add((Component)this.editButton, null);
        this.jPanel.add((Component)this.deleteButton, null);
        this.add((Component)this.jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), -1000, -1000));
        this.add((Component)this.jPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(11, 0, 0, 0), 0, 0));
    }

    void deleteButton_actionPerformed(ActionEvent actionEvent) {
        try {
            int[] nArray = this.jTable.getSelectedRows();
            int n = 0;
            while (n < nArray.length) {
                this.admin.deleteUser((String)this.users.getValueAt(nArray[n], 0));
                ++n;
            }
            int n2 = nArray.length - 1;
            while (n2 >= 0) {
                this.users.removeRow(nArray[n2]);
                --n2;
            }
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void addButton_actionPerformed(ActionEvent actionEvent) {
        try {
            EditUserDialog editUserDialog = new EditUserDialog(new JFrame(), this.admin, "add");
            editUserDialog.setTitle("Add User");
            ((Component)editUserDialog).setVisible(true);
            while (this.users.getRowCount() != 0) {
                this.users.removeRow(0);
            }
            this.useridlist = this.admin.allUsers();
            int n = 0;
            while (n < this.useridlist.length) {
                this.users.addRow(new Object[]{this.useridlist[n]});
                ++n;
            }
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void editButton_actionPerformed(ActionEvent actionEvent) {
        try {
            int n = this.jTable.getSelectedRow();
            String string = (String)this.jTable.getValueAt(n, 0);
            String string2 = (String)this.jTable.getValueAt(n, 1);
            EditUserDialog editUserDialog = new EditUserDialog(new JFrame(), this.admin, "update");
            editUserDialog.setUseridPassword(string, string2);
            editUserDialog.setTitle("Edit User");
            ((Component)editUserDialog).setVisible(true);
            while (this.users.getRowCount() != 0) {
                this.users.removeRow(0);
            }
            this.useridlist = this.admin.allUsers();
            int n2 = 0;
            while (n2 < this.useridlist.length) {
                this.users.addRow(new Object[]{this.useridlist[n2]});
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

