/*
 * Decompiled with CFR 0.152.
 */
package com.kb.owl;

import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.owl.TypedVarSpec;

public class VarSpec
extends OWL {
    private final OWL[] the_vars;

    public VarSpec(OWL[] oWLArray) {
        this.the_vars = oWLArray;
        if (oWLArray == null || oWLArray.length == 0) {
            throw new Error("Variable specifications cannot be empty: " + oWLArray);
        }
        int n = 0;
        while (n < oWLArray.length) {
            if (!(oWLArray[n] instanceof IVar) && !(oWLArray[n] instanceof TypedVarSpec)) {
                throw new Error("Invalid entry for a variable specification: " + oWLArray[n] + ", " + oWLArray[n].getClass());
            }
            ++n;
        }
    }

    public OWL arg(int n) {
        return this.the_vars[n];
    }

    public int arity() {
        return this.the_vars.length;
    }

    public int length() {
        return this.the_vars.length;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VarSpec)) {
            return false;
        }
        VarSpec varSpec = (VarSpec)object;
        int n = this.length();
        if (n != varSpec.length()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!this.arg(n2).equals(varSpec.arg(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(').append(this.the_vars[0]);
        int n = 1;
        while (n < this.the_vars.length) {
            stringBuffer.append(' ').append(this.the_vars[n]);
            ++n;
        }
        return stringBuffer.append(')').toString();
    }
}

