/*
 * Decompiled with CFR 0.152.
 */
package com.kb.owl;

import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.KBDate;
import com.kb.owl.OWL;
import com.kb.owl.OWLParser;
import com.kb.owl.QuotedString;
import com.kb.owl.Symbol;
import com.kb.owl.SyntaxError;
import com.kb.xsb.Structure;
import com.kb.xsb.Variable;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Time {
    static final int XSB_MAX = 100000000;
    public static Symbol owlStart = new Symbol("RootCtx.Start");
    public static Symbol owlNow = new Symbol("RootCtx.Now");
    static final Object xsbStart = "RootCtx.Start";
    static final Object xsbNow = "RootCtx.Now";
    static final long granularity = 60000L;
    public static List months = new ArrayList();
    public static final TimeZone GMT;

    public static Date[] owl2java(OWL oWL) throws SyntaxError {
        Form form = (Form)oWL;
        if (oWL.named("RootCtx.Date")) {
            return Time.point2java(form.arg(0));
        }
        if (oWL.named("RootCtx.Span")) {
            Date[] dateArray = new Date[]{owlStart.equals(form.arg(0)) ? KBDate.start : Time.owl2java(form.arg(0))[0], owlNow.equals(form.arg(1)) ? KBDate.now : Time.owl2java(form.arg(1))[1]};
            return dateArray;
        }
        throw new SyntaxError("Unrecognized date format: " + oWL);
    }

    static Date[] point2java(OWL oWL) throws SyntaxError {
        if (oWL instanceof QuotedString) {
            String string = ((QuotedString)oWL).text();
            long[] lArray = Time.date2java(string);
            Date[] dateArray = new Date[]{new Date(lArray[0]), new Date(lArray[1])};
            return dateArray;
        }
        throw new SyntaxError("Unrecognized date format: " + oWL);
    }

    public static OWL java2owl(Date date) {
        if (date.equals(KBDate.start)) {
            return owlStart;
        }
        if (date.equals(KBDate.now)) {
            return owlNow;
        }
        return new Form("RootCtx.Date", (OWL)new QuotedString(Time.java2date(date.getTime())));
    }

    public static Object[] owl2xsbPair(OWL oWL) throws SyntaxError {
        if (oWL instanceof IVar) {
            return new Object[]{new Variable(), new Variable()};
        }
        Date[] dateArray = Time.owl2java(oWL);
        return new Object[]{Time.java2xsb(dateArray[0]), Time.java2xsb(dateArray[1])};
    }

    public static Object owl2xsb(OWL oWL) throws SyntaxError {
        if (oWL instanceof IVar) {
            return new Variable(oWL.name());
        }
        Date[] dateArray = Time.owl2java(oWL);
        return new Structure("_kbti", Time.java2xsb(dateArray[0]), Time.java2xsb(dateArray[1]));
    }

    public static OWL xsb2owl(Object object) {
        Date[] dateArray = Time.xsb2java(object);
        if (dateArray[1] == null) {
            return Time.java2owl(dateArray[0]);
        }
        return new Form("RootCtx.Span", Time.java2owl(dateArray[0]), Time.java2owl(dateArray[1]));
    }

    public static Object java2xsb(Date date) {
        if (date.equals(KBDate.start)) {
            return xsbStart;
        }
        if (date.equals(KBDate.now)) {
            return xsbNow;
        }
        long l = date.getTime() / 60000L;
        if ((long)((int)l) != l) {
            throw new Error("Time beyond that allowed by granularity");
        }
        return new Integer((int)l);
    }

    public static Date[] xsb2java(Object object) {
        Date[] dateArray = new Date[2];
        if (object.equals(xsbStart)) {
            dateArray[0] = KBDate.start;
        } else if (object.equals(xsbNow)) {
            dateArray[0] = KBDate.now;
        } else if (object instanceof Integer) {
            dateArray[0] = new Date(((Integer)object).longValue() * 60000L);
        } else if (object instanceof Structure) {
            Structure structure = (Structure)object;
            if (structure.functor().equals("_kbtp")) {
                int n = (Integer)structure.arg(0);
                int n2 = (Integer)structure.arg(1);
                dateArray[0] = new Date((long)(n * 100000000 + n2) * 60000L);
            } else {
                dateArray[0] = Time.xsb2java(structure.arg(0))[0];
                dateArray[1] = Time.xsb2java(structure.arg(1))[0];
            }
        } else {
            throw new Error("Invalid XSB date object " + object);
        }
        return dateArray;
    }

    public static String java2date(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(GMT);
        gregorianCalendar.setTime(new Date(l));
        String string = "";
        string = string + gregorianCalendar.get(1) + " ";
        string = string + months.get(gregorianCalendar.get(2)) + " ";
        string = string + gregorianCalendar.get(5) + " ";
        string = string + gregorianCalendar.get(11) + ":";
        int n = gregorianCalendar.get(12);
        string = n > 10 ? string + n : string + "0" + n;
        int n2 = gregorianCalendar.get(13);
        string = n2 > 10 ? string + ":0" + n2 : string + ":" + n2;
        return string;
    }

    public static long[] date2java(String string) throws SyntaxError {
        Object object;
        Object object2;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        TimeZone timeZone = GMT;
        int n7 = -1;
        try {
            object2 = stringTokenizer.nextToken();
            try {
                n = Integer.parseInt((String)object2);
                n7 = 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxError("Invalid year: " + (String)object2);
            }
            object = stringTokenizer.nextToken();
            n2 = months.indexOf(((String)object).toLowerCase());
            if (n2 == -1) {
                try {
                    n2 = Integer.parseInt((String)object) - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SyntaxError("Invalid month: " + (String)object);
                }
            }
            n7 = 2;
            String string2 = stringTokenizer.nextToken();
            try {
                n3 = Integer.parseInt(string2);
                n7 = 5;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxError("Invalid day: " + string2);
            }
            String string3 = stringTokenizer.nextToken(": ");
            try {
                n4 = Integer.parseInt(string3);
                n7 = 10;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxError("Invalid hour: " + string3);
            }
            String string4 = stringTokenizer.nextToken(": ");
            try {
                n5 = Integer.parseInt(string4);
                n7 = 12;
            }
            catch (NumberFormatException numberFormatException) {
                throw new SyntaxError("Invalid minute: " + string4);
            }
            String string5 = stringTokenizer.nextToken();
            try {
                n6 = (int)Double.parseDouble(string5);
                n7 = 13;
                string5 = null;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (string5 == null) {
                string5 = stringTokenizer.nextToken();
            }
            timeZone = TimeZone.getTimeZone(string5);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (n7 == -1) {
            throw new SyntaxError("Invalid date format " + string);
        }
        object2 = new GregorianCalendar(n, n2, n3, n4, n5, n6);
        ((Calendar)object2).setTimeZone(timeZone);
        object = new long[2];
        object[0] = ((Calendar)object2).getTime().getTime();
        if (n7 == 1 || n7 == 2 || n7 == 5 || n7 == 10 || n7 == 12) {
            ((GregorianCalendar)object2).add(n7, 1);
        }
        object[1] = ((Calendar)object2).getTime().getTime();
        return object;
    }

    public static void main(String[] stringArray) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        OWLParser oWLParser = new OWLParser(bufferedReader);
        OWL oWL = oWLParser.readExpr();
        Date[] dateArray = Time.owl2java(oWL);
        System.out.println(dateArray[0] + ":" + dateArray[0].getTime() + " " + dateArray[1] + ":" + dateArray[1].getTime());
        Object object = Time.owl2xsb(oWL);
        System.out.println(object);
        Date[] dateArray2 = Time.xsb2java(object);
        System.out.println(dateArray2[0].getTime() + " " + dateArray2[1].getTime());
        OWL oWL2 = Time.xsb2owl(object);
        System.out.println(oWL2);
    }

    static {
        months.add("jan");
        months.add("feb");
        months.add("mar");
        months.add("apr");
        months.add("may");
        months.add("jun");
        months.add("jul");
        months.add("aug");
        months.add("sep");
        months.add("oct");
        months.add("nov");
        months.add("dec");
        GMT = TimeZone.getTimeZone("GMT");
    }
}

