/*
 * Decompiled with CFR 0.152.
 */
package com.kb.owl;

import com.kb.owl.OWL;

public class Symbol
extends OWL {
    static final long serialVersionUID = -8514508368860024854L;
    private final String name;

    public Symbol(int n) {
        this.name = "" + n;
    }

    public Symbol(float f) {
        this.name = "" + f;
    }

    public Symbol(String string) {
        this.name = string;
        if (string == null) {
            throw new NullPointerException("name must not be null");
        }
    }

    public String name() {
        return this.name;
    }

    public OWL functor() {
        return this;
    }

    public boolean named(String string) {
        return this.name.equals(string);
    }

    public boolean named(Symbol symbol) {
        return this.equals(symbol);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Symbol) {
            return ((Symbol)object).name.equals(this.name);
        }
        return false;
    }

    public boolean isInt() {
        try {
            Integer.parseInt(this.name);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public int intValue() {
        try {
            return Integer.parseInt(this.name);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean isReal() {
        try {
            Float.parseFloat(this.name);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public float realValue() {
        try {
            return Float.parseFloat(this.name);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    public String toString() {
        return this.name;
    }

    public Object toXSB() {
        if (this.isInt()) {
            return new Integer(this.intValue());
        }
        if (this.isReal()) {
            return new Float(this.realValue());
        }
        return this.name;
    }
}

