/*
 * Decompiled with CFR 0.152.
 */
package com.kb.owl;

import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.owl.QuotedString;
import com.kb.owl.SVar;
import com.kb.owl.Symbol;
import com.kb.owl.SyntaxError;
import com.kb.owl.TypedVarSpec;
import com.kb.owl.VarSpec;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Vector;

public class OWLParser {
    public static final OWL eof = new OWL();
    private String pushback_token = null;
    protected PushbackReader is;
    protected LineNumberReader lnr;
    boolean returnComments;

    public OWLParser(Reader reader) {
        this.lnr = reader instanceof LineNumberReader ? (LineNumberReader)reader : new LineNumberReader(reader);
        this.is = new PushbackReader(this.lnr);
    }

    public int getLineNumber() {
        try {
            this.pushback(this.token());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lnr.getLineNumber() + 1;
    }

    boolean isEOL(int n) {
        return n == 13 || n == 10;
    }

    boolean isWhiteSpace(int n) {
        return n == 32 || n == 9 || this.isEOL(n);
    }

    boolean isEof(int n) {
        return n == -1;
    }

    boolean isDelimiter(int n) {
        return this.isWhiteSpace(n) || this.isEof(n) || n == 41 || n == 40 || n == 34 || n == 59;
    }

    boolean isDecimalDigit(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    void pushback(String string) {
        this.pushback_token = string;
    }

    String token() throws IOException, EndOfStreamException, SyntaxError {
        String string = this.token0();
        return string;
    }

    public boolean getReturnComments() {
        return this.returnComments;
    }

    public void setReturnComments(boolean bl) {
        this.returnComments = bl;
    }

    String token0() throws IOException, EndOfStreamException, SyntaxError {
        int n;
        if (this.pushback_token != null) {
            String string = this.pushback_token;
            this.pushback_token = null;
            return string;
        }
        block8: while (true) {
            n = this.is.read();
            switch (n) {
                case -1: {
                    throw new EndOfStreamException();
                }
                case 40: {
                    return "(";
                }
                case 41: {
                    return ")";
                }
                case 39: {
                    return "'";
                }
                case 34: {
                    return "\"";
                }
                case 59: {
                    StringBuffer stringBuffer = null;
                    if (this.returnComments) {
                        stringBuffer = new StringBuffer();
                        stringBuffer.append((char)n);
                    }
                    while (true) {
                        if ((n = this.is.read()) == -1) {
                            throw new EndOfStreamException();
                        }
                        if (n == 10 || n == -1) break;
                        if (!this.returnComments) continue;
                        stringBuffer.append((char)n);
                    }
                    if (!this.returnComments) continue block8;
                    return stringBuffer.toString();
                }
            }
            if (!this.isWhiteSpace(n)) break;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 41) {
            throw new SyntaxError(this.getLineNumber(), "Unbalanced parentheses");
        }
        do {
            stringBuffer.append((char)n);
            n = this.is.read();
            if (!this.isEof(n)) continue;
            throw new EndOfStreamException();
        } while (!this.isDelimiter(n));
        this.is.unread(n);
        String string = stringBuffer.toString();
        return string;
    }

    public OWL readExpr() throws IOException, SyntaxError {
        try {
            String string = this.token();
            if (string.equals("(")) {
                return this.list();
            }
            if (string.equals("'")) {
                return this.quoted_symbol();
            }
            if (string.equals("~")) {
                return this.kbquoted_symbol();
            }
            if (string.equals("\"")) {
                return this.string();
            }
            if (string.startsWith("?")) {
                return new IVar(string);
            }
            if (string.startsWith("@")) {
                return new SVar(string);
            }
            if (string.startsWith(":")) {
                throw new SyntaxError(this.getLineNumber(), "An identifier may not start with a colon");
            }
            if (string.equals(")")) {
                throw new SyntaxError(this.lnr, "Unbalanced parentheses");
            }
            return new Symbol(string);
        }
        catch (EndOfStreamException endOfStreamException) {
            return eof;
        }
    }

    OWL quoted_symbol() throws IOException, SyntaxError {
        return new Form("quote", this.readExpr());
    }

    OWL kbquoted_symbol() throws IOException, SyntaxError {
        return new Form("_$kbquote", this.readExpr());
    }

    OWL list() throws IOException, EndOfStreamException, SyntaxError {
        int n = this.getLineNumber();
        try {
            Object[] objectArray;
            String string = this.token();
            if (string.equals(")")) {
                return null;
            }
            this.pushback(string);
            OWL oWL = this.readExpr();
            if (oWL.named("exists") || oWL.named("forall")) {
                VarSpec varSpec = this.read_vspec();
                OWL oWL2 = this.readExpr();
                String string2 = this.token();
                if (!string2.equals(")")) {
                    throw new SyntaxError(this.getLineNumber(), "Expected only to arguments to a quantifier.");
                }
                return new Form(oWL, (OWL)varSpec, oWL2);
            }
            Vector<OWL> vector = new Vector<OWL>();
            while (!(objectArray = this.token()).equals(")")) {
                this.pushback((String)objectArray);
                vector.addElement(this.readExpr());
            }
            objectArray = new OWL[vector.size()];
            vector.copyInto(objectArray);
            Form form = new Form(oWL, (OWL[])objectArray);
            return form;
        }
        catch (EndOfStreamException endOfStreamException) {
            throw new SyntaxError(n, "Missing close parenthesis");
        }
    }

    private VarSpec read_vspec() throws IOException, EndOfStreamException, SyntaxError {
        Object object;
        String string = this.token();
        if (!string.equals("(")) {
            throw new SyntaxError(this.getLineNumber(), "Expected a '(' to open a variable specification: " + string);
        }
        Vector<Object> vector = new Vector<Object>();
        while (!(string = this.token()).equals(")")) {
            if (string.equals("(")) {
                this.pushback(string);
                vector.addElement(this.read_typed_vspec());
                continue;
            }
            this.pushback(string);
            object = this.readExpr();
            if (!(object instanceof IVar)) {
                throw new SyntaxError(this.getLineNumber(), "Expected each entry for a variable specification to be either an IVar or a typed-specification: " + object + ", " + object.getClass());
            }
            vector.addElement(object);
        }
        object = new OWL[vector.size()];
        vector.copyInto((Object[])object);
        return new VarSpec((OWL[])object);
    }

    private TypedVarSpec read_typed_vspec() throws IOException, EndOfStreamException, SyntaxError {
        String string = this.token();
        if (!string.equals("(")) {
            throw new SyntaxError(this.getLineNumber(), "Expected a '(' to open a typed-variable specification entry: " + string);
        }
        OWL oWL = this.readExpr();
        if (!(oWL instanceof IVar)) {
            throw new SyntaxError(this.getLineNumber(), "Expected an IVar to start a typed-variable specification entry: " + oWL + ", " + oWL.getClass());
        }
        OWL oWL2 = this.readExpr();
        string = this.token();
        if (!string.equals(")")) {
            throw new SyntaxError(this.getLineNumber(), "Expected only a variable, a property, and then a closing ')' for a typed-variable specification entry " + string);
        }
        return new TypedVarSpec((IVar)oWL, oWL2);
    }

    OWL string() throws IOException {
        String string = new String();
        int n;
        while ((n = this.is.read()) != -1) {
            if (n == 34) {
                return new QuotedString(string);
            }
            if (n == 92) {
                n = this.is.read();
                if (n == -1) {
                    return eof;
                }
                string = string + (char)n;
                continue;
            }
            string = string + (char)n;
        }
        return eof;
    }

    public class EndOfStreamException
    extends Exception {
    }
}

