/*
 * Decompiled with CFR 0.152.
 */
package com.kb.owl;

import com.kb.owl.Form;
import com.kb.owl.OWL;
import com.kb.owl.OWLParser;
import com.kb.owl.Symbol;
import com.kb.owl.SyntaxError;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Vector;

public class KFLParser
extends OWLParser {
    private OWL[] next = none;
    private int nextOWL = 0;
    private static OWL[] none = new OWL[0];
    private OWL primary;
    private OWL ctx;
    boolean returnPrimaryDirs = false;

    public KFLParser(Reader reader) {
        super(reader);
    }

    public OWL getContext() {
        return this.ctx;
    }

    public void setReturnPrimaryDirs(boolean bl) {
        this.returnPrimaryDirs = bl;
    }

    public boolean getReturnPrimaryDirs() {
        return this.returnPrimaryDirs;
    }

    public OWL readOWLExpr() throws SyntaxError, IOException {
        while (this.nextOWL >= this.next.length) {
            OWL oWL = this.readKFLExpr();
            if (oWL == OWLParser.eof) {
                return OWLParser.eof;
            }
            this.next = this.KFLtoOWL(oWL);
            this.nextOWL = 0;
        }
        return this.next[this.nextOWL++];
    }

    public OWL[] KFLtoOWL(OWL oWL) {
        if (!(oWL instanceof Form)) {
            return new OWL[]{oWL};
        }
        Form form = (Form)oWL;
        if (form.functor().toString().startsWith(":")) {
            if (form.functor().named(":Prop") || form.functor().named(":Fun") || form.functor().named(":Const") || form.functor().named(":Rel") || form.functor().named(":Fun")) {
                this.primary = form.arg(0);
                if (this.returnPrimaryDirs) {
                    return new OWL[]{oWL};
                }
                return none;
            }
            if (form.functor().named(":Sig")) {
                ArrayList<Form> arrayList = new ArrayList<Form>();
                int n = 0;
                while (n < form.arity()) {
                    arrayList.add(new Form("RootCtx.argProp", this.primary, (OWL)new Symbol("" + (n + 1)), form.arg(n)));
                    ++n;
                }
                OWL[] oWLArray = new OWL[arrayList.size()];
                arrayList.toArray(oWLArray);
                return oWLArray;
            }
            if (form.functor().named(":Inst")) {
                return new OWL[]{new Form(form.arg(0), this.primary)};
            }
            if (form.functor().named(":Args")) {
                ArrayList<Form> arrayList = new ArrayList<Form>();
                int n = 0;
                while (n < form.arity()) {
                    arrayList.add(new Form("RootCtx.argName", this.primary, (OWL)new Symbol("" + (n + 1)), form.arg(n)));
                    ++n;
                }
                OWL[] oWLArray = new OWL[arrayList.size()];
                arrayList.toArray(oWLArray);
                return oWLArray;
            }
            if (form.functor().named(":Mode")) {
                return none;
            }
            if (form.functor().named(":Idx")) {
                return none;
            }
            if (form.functor().named(":IC")) {
                return none;
            }
            if (form.functor().named(":Ctx")) {
                this.primary = form.arg(0);
                return none;
            }
            if (form.functor().named(":Use")) {
                this.ctx = form.arg(0);
                return none;
            }
            if (form.functor().named(":Copyright")) {
                return none;
            }
            if (form.functor().named(":Name")) {
                return none;
            }
            if (form.functor().named(":Description")) {
                return none;
            }
            Symbol symbol = new Symbol(form.functor().toString().substring(1));
            OWL[] oWLArray = new OWL[form.arity() + 1];
            oWLArray[0] = this.primary;
            int n = 0;
            while (n < form.arity()) {
                oWLArray[n + 1] = form.arg(n);
                ++n;
            }
            return new OWL[]{new Form((OWL)symbol, oWLArray)};
        }
        this.primary = form;
        return new OWL[]{form};
    }

    public OWL readKFLExpr() throws SyntaxError, IOException {
        Form form = null;
        try {
            String string = this.token();
            if (string.startsWith(":")) {
                Object[] objectArray;
                Symbol symbol = new Symbol(string);
                Vector<Object[]> vector = new Vector<Object[]>();
                while (!this.findEol()) {
                    objectArray = this.readExpr();
                    vector.addElement(objectArray);
                }
                objectArray = new OWL[vector.size()];
                vector.copyInto(objectArray);
                form = new Form((OWL)symbol, (OWL[])objectArray);
                return form;
            }
            this.pushback(string);
            return this.readExpr();
        }
        catch (OWLParser.EndOfStreamException endOfStreamException) {
            return OWLParser.eof;
        }
    }

    boolean findEol() throws IOException {
        int n;
        do {
            if (this.isEOL(n = this.is.read()) || n == -1 || n == 65535) {
                return true;
            }
            if (n != 59) continue;
            while (!this.isEOL(n = this.is.read()) && n != -1) {
            }
            return true;
        } while (this.isWhiteSpace(n));
        this.is.unread(n);
        return false;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            try {
                KFLParser kFLParser = new KFLParser(new FileReader(stringArray[n]));
                OWL oWL = kFLParser.readKFLExpr();
                while (oWL != OWLParser.eof) {
                    System.out.println(oWL);
                    oWL = kFLParser.readOWLExpr();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }
}

