/*
 * Decompiled with CFR 0.152.
 */
package com.kb.license;

import com.kb.kbddutil.KBProperties;
import com.kb.license.License;
import com.kb.license.NoLicense;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignedObject;
import java.security.spec.DSAPublicKeySpec;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class Verify {
    static final String readme = "Pbatenghyngvbaf, lbh svtherq bhg jurer gb oernx gur yvprafvat.  Lbh fb fzneg.  Ovt sng unvel qrny.";
    static final BigInteger p = new BigInteger("fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c7", 16);
    static final BigInteger q = new BigInteger("9760508f15230bccb292b982a2eb840bf0581cf5", 16);
    static final BigInteger g = new BigInteger("f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a", 16);
    static final BigInteger y = new BigInteger("23b8e2cbfcf6e80017534e2e78555f91a8c3538be23965acc5cc7c2bc297b30434c5fb8fceeaaf3e639f652682acfe6ea4751e4d75e57324f979db519dcec6325de4729e65ccece3fab9e6f14f09bc731d2cec835f96a57ad9b670ad9b00b1162bf4613803a53ed363dbed8d7bba05b50f3c4c08607a52e9c2e486d21ac87ecc", 16);

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            throw new Exception("Format: license-filename ...");
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                File file = new File(stringArray[n]);
                System.out.println(Verify.findLicense(file));
            }
            catch (Exception exception) {
                System.out.println(stringArray[n] + ": Nope " + exception.getMessage());
            }
            ++n;
        }
    }

    public static License findLicense(File file) throws NoLicense {
        ArrayList arrayList = new ArrayList();
        Verify.findLicenses(file, arrayList);
        HashMap<License, String> hashMap = new HashMap<License, String>();
        int n = 0;
        while (n < arrayList.size()) {
            License license = (License)arrayList.get(n);
            try {
                Verify.isValid(license, arrayList);
                return license;
            }
            catch (NoLicense noLicense) {
                hashMap.put(license, "invalid license");
                ++n;
            }
        }
        throw new NoLicense(hashMap);
    }

    public static void isValid(License license, ArrayList arrayList) {
        license.valid();
        int n = 0;
        while (n < arrayList.size()) {
            License license2 = (License)arrayList.get(n);
            if (license2.revoked(license)) {
                throw new NoLicense("License revoked");
            }
            ++n;
        }
    }

    public static void findLicenses(File file, List list) {
        try {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    Verify.findLicenses(fileArray[n], list);
                    ++n;
                }
            } else {
                FileInputStream fileInputStream = new FileInputStream(file);
                list.add(Verify.fetchLicense(fileInputStream));
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new NoLicense("Can't read file " + file);
        }
    }

    public static void findLicenseFiles(File file, List list) throws NoLicense {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                Verify.findLicenseFiles(fileArray[n], list);
                ++n;
            }
        } else {
            list.add(file);
        }
    }

    public static License fetchLicense(InputStream inputStream) {
        return Verify.checkSignature(inputStream);
    }

    public static License checkSignature(InputStream inputStream) {
        try {
            Signature signature = Signature.getInstance("SHA1withDSA");
            SignedObject signedObject = (SignedObject)new ObjectInputStream(inputStream).readObject();
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(y, p, q, g);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PublicKey publicKey = keyFactory.generatePublic(dSAPublicKeySpec);
            if (signedObject.verify(publicKey, signature)) {
                return (License)signedObject.getObject();
            }
            throw new NoLicense("Invalid signature on license");
        }
        catch (NoLicense noLicense) {
            throw noLicense;
        }
        catch (Throwable throwable) {
            throw new NoLicense(throwable.getMessage());
        }
    }

    public static File[] getLicenseLocations() {
        HashSet<File> hashSet = new HashSet<File>();
        hashSet.add(new File("licenses").getAbsoluteFile());
        hashSet.add(new File(KBProperties.installDir() + "/licenses").getAbsoluteFile());
        String string = KBProperties.get("com.kb.licenseDir");
        if (string != null && string.length() > 0) {
            hashSet.add(new File(string).getAbsoluteFile());
        }
        File[] fileArray = new File[hashSet.size()];
        ((AbstractCollection)hashSet).toArray(fileArray);
        return fileArray;
    }
}

