/*
 * Decompiled with CFR 0.152.
 */
package com.kb.license;

import com.kb.license.License;
import com.kb.license.NoLicense;
import com.kb.license.Sign;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SignedObject;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class TimeLicense
implements License,
Serializable {
    private long time = System.currentTimeMillis();
    private List revoked;
    private long duration;
    public static final long serialVersionUID = 3048242438704128339L;

    public String id() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0, Locale.US);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        dateFormat.setTimeZone(timeZone);
        return dateFormat.format(new Date(this.time)) + " to " + new Date(this.time + this.duration);
    }

    public void revoke(String string) {
        if (this.revoked == null) {
            this.revoked = new ArrayList();
        }
        this.revoked.add(string);
    }

    public boolean revoked(License license) {
        if (this.revoked == null) {
            return false;
        }
        return this.revoked.contains(license.id());
    }

    TimeLicense(long l) {
        this.duration = l;
    }

    public void valid() throws NoLicense {
        long l = System.currentTimeMillis();
        if (l > this.time && l < this.time + this.duration) {
            return;
        }
        throw new NoLicense("License invalid: " + this.id());
    }

    public String toString() {
        return this.id();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            throw new Exception("Format: duration filename [revoke...]");
        }
        System.out.print("Password: ");
        System.out.flush();
        String string = new BufferedReader(new InputStreamReader(System.in)).readLine();
        String string2 = stringArray[1];
        long l = TimeLicense.parseTime(stringArray[0]);
        TimeLicense timeLicense = new TimeLicense(l);
        int n = 2;
        while (n < stringArray.length) {
            timeLicense.revoke(stringArray[n]);
            ++n;
        }
        SignedObject signedObject = Sign.signObject(timeLicense, string);
        new ObjectOutputStream(new FileOutputStream(string2)).writeObject(signedObject);
    }

    public static long parseTime(String string) {
        String string2 = string.substring(0, string.length() - 1);
        char c = string.charAt(string.length() - 1);
        long l = Long.parseLong(string2);
        if (c == 'd') {
            return 86400000L * l;
        }
        if (c == 'h') {
            return 3600000L * l;
        }
        if (c == 'y') {
            return 1557628928L * l;
        }
        return Long.parseLong(string);
    }
}

