/*
 * Decompiled with CFR 0.152.
 */
package com.kb.kbddutil;

import com.kb.kbddutil.KBProperties;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;

public class RememberingFileChooser
extends JFileChooser {
    public final String key;

    public RememberingFileChooser(String string) {
        this.key = string;
    }

    public int showDialog(Component component, String string) {
        this.setCurrentDirectory(this.recall());
        int n = super.showDialog(component, string);
        this.remember();
        return n;
    }

    public File recall() {
        String string = KBProperties.get(this.key);
        if (string == null) {
            return null;
        }
        return new File(string);
    }

    public void remember() {
        File file = this.getCurrentDirectory();
        String string = file.getAbsolutePath();
        string = string.replace('\\', '/');
        KBProperties.put(this.key, string);
        KBProperties.save();
    }

    public void setSelectedFile(File file) {
        if (file == null) {
            return;
        }
        switch (this.getFileSelectionMode()) {
            case 0: {
                if (!file.isDirectory()) break;
                return;
            }
            case 1: {
                if (file.isDirectory()) break;
                return;
            }
        }
        super.setSelectedFile(file);
    }
}

