/*
 * Decompiled with CFR 0.152.
 */
package com.kb.kbddutil;

import com.kb.kbddutil.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitor;

public class MonitoredInputStream
extends CountingInputStream {
    ProgressMonitor monitor;
    JProgressBar progressBar;

    public MonitoredInputStream(InputStream inputStream, ProgressMonitor progressMonitor) {
        super(inputStream);
        this.monitor = progressMonitor;
    }

    public MonitoredInputStream(InputStream inputStream, JProgressBar jProgressBar) {
        super(inputStream);
        this.progressBar = jProgressBar;
    }

    public void reset() {
        super.reset();
        this.updateProgress();
    }

    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this.updateProgress();
        return l2;
    }

    void updateProgress() {
        if (this.monitor != null) {
            this.monitor.setProgress((int)this.n);
        }
        if (this.progressBar != null) {
            this.progressBar.setValue((int)this.n);
        }
    }

    public int read() throws IOException {
        if (this.monitor != null && this.monitor.isCanceled()) {
            return -1;
        }
        int n = super.read();
        this.updateProgress();
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.monitor != null && this.monitor.isCanceled()) {
            return -1;
        }
        int n3 = super.read(byArray, n, n2);
        this.updateProgress();
        return n3;
    }

    public long getCount() {
        return this.n;
    }

    public void mark(int n) {
        super.mark(n);
        this.updateProgress();
    }
}

