/*
 * Decompiled with CFR 0.152.
 */
package com.kb.kbddutil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class KBProperties {
    public static final String installDirProp = "com.kb.installDir";
    public static final String masterPropFile = "_kbprops";
    public static final String userPropFile = "_kbprops_user";
    public static final String apiDir = "apiDir";
    public static final String apiData = "apiData";
    public static final String pkg = "apiPackage";
    public static final String propInfo = "reportProps";
    private static String whiteSpaceChars = " \t\r\n\f";
    private static String separatorChars = "=: \t\r\n\f";
    static Properties masterProps = new Properties();
    static Properties userProps = new Properties();
    static boolean reportPropInfo;
    static URL userPropURL;
    static URL masterPropURL;

    private KBProperties() {
    }

    public static String get(String string) {
        return KBProperties.get(string, "");
    }

    public static String get(String string, String string2) {
        String string3 = null;
        try {
            string3 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            string3 = null;
        }
        if (string3 == null) {
            string3 = userProps.getProperty(string);
        }
        if (string3 == null) {
            string3 = masterProps.getProperty(string, string2);
        }
        KBProperties.report(string, string3);
        return string3;
    }

    public static boolean getBoolean(String string) {
        String string2 = KBProperties.get(string);
        return string2.equalsIgnoreCase("true");
    }

    public static Integer getInt(String string) {
        return KBProperties.getInteger(string);
    }

    public static Integer getInt(String string, int n) {
        return KBProperties.getInteger(string, n);
    }

    public static int get_int(String string, int n) {
        return KBProperties.getInteger(string, n);
    }

    public static Integer getInteger(String string) {
        String string2 = KBProperties.get(string);
        Integer n = null;
        try {
            n = Integer.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = null;
        }
        return n;
    }

    public static Integer getInteger(String string, int n) {
        Integer n2 = KBProperties.getInteger(string);
        if (n2 == null) {
            n2 = new Integer(n);
        }
        return n2;
    }

    private static void report(String string, String string2) {
        if (reportPropInfo) {
            System.out.println("KBProperties: key -" + string + "- value -" + string2 + '-');
        }
    }

    public static void put(String string, String string2) {
        ((Hashtable)userProps).put(string, string2);
    }

    public static void put(String string, int n) {
        ((Hashtable)userProps).put(string, String.valueOf(n));
    }

    public static boolean savable() {
        return userPropURL != null && userPropURL.getProtocol().equals("file");
    }

    public static void saveFamily(String string) {
        Object object;
        Object[] objectArray = ((Hashtable)userProps).keySet().toArray();
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < objectArray.length) {
            object = (String)objectArray[n];
            if (((String)object).startsWith(string)) {
                vector.add(object);
            }
            ++n;
        }
        object = new String[vector.size()];
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            object[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        KBProperties.save((String[])object);
    }

    public static void save() {
        Object[] objectArray = ((Hashtable)userProps).keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
        KBProperties.save(stringArray);
    }

    public static String installDir() {
        if (masterPropURL == null) {
            return ".";
        }
        File file = new File(masterPropURL.getFile());
        return file.getParent();
    }

    public static boolean save(String[] stringArray) {
        if (!KBProperties.savable()) {
            return false;
        }
        try {
            BufferedReader bufferedReader;
            try {
                bufferedReader = new BufferedReader(new FileReader(userPropURL.getFile()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Creating new user properties file " + userPropURL.getFile());
                bufferedReader = new BufferedReader(new StringReader(""));
            }
            String string = KBProperties.processSave(bufferedReader, stringArray);
            bufferedReader.close();
            FileWriter fileWriter = new FileWriter(userPropURL.getFile());
            fileWriter.write(string, 0, string.length());
            fileWriter.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private static String processSave(BufferedReader bufferedReader, String[] stringArray) throws IOException {
        String string;
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = KBProperties.readWholeLine(bufferedReader)) != null) {
            if (KBProperties.isCommentOrSpace(string)) {
                stringBuffer.append(string);
                stringBuffer.append(string2);
                continue;
            }
            String string3 = KBProperties.getKeyFromLine(string);
            if (KBProperties.removeKeyFromArray(string3, stringArray)) {
                if (KBProperties.get(string3).equals(((Hashtable)masterProps).get(string3))) continue;
                stringBuffer.append(string3);
                stringBuffer.append('=');
                stringBuffer.append(KBProperties.get(string3));
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(string);
            stringBuffer.append(string2);
        }
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            String string4 = stringArray[n];
            if (string4.length() > 0 && !KBProperties.get(string4).equals(((Hashtable)masterProps).get(string4))) {
                if (bl) {
                    stringBuffer.append(string2);
                    stringBuffer.append("# Other properties...");
                    stringBuffer.append(string2);
                    bl = false;
                }
                stringBuffer.append(string4);
                stringBuffer.append('=');
                stringBuffer.append(KBProperties.get(string4));
                stringBuffer.append(string2);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private static String readWholeLine(BufferedReader var0) throws IOException {
        var1_1 = var0.readLine();
        if (var1_1 == null) {
            return var1_1;
        }
        if (!KBProperties.isCommentOrSpace(var1_1)) ** GOTO lbl18
        return var1_1;
lbl-1000:
        // 1 sources

        {
            var2_2 = var1_1.substring(0, var1_1.length() - 1);
            var3_3 = var0.readLine();
            if (var3_3 == null) {
                var3_3 = "";
            }
            var4_4 = 0;
            var4_4 = 0;
            while (var4_4 < var3_3.length()) {
                if (KBProperties.whiteSpaceChars.indexOf(var3_3.charAt(var4_4)) == -1) break;
                ++var4_4;
            }
            var3_3 = var3_3.substring(var4_4, var3_3.length());
            var1_1 = var2_2 + var3_3;
lbl18:
            // 2 sources

            ** while (var1_1.charAt((int)(var1_1.length() - 1)) == '\\')
        }
lbl19:
        // 1 sources

        return var1_1;
    }

    private static boolean isCommentOrSpace(String string) {
        String string2 = "#!";
        return string.trim().length() == 0 || string2.indexOf(string.charAt(0)) != -1;
    }

    private static String getKeyFromLine(String string) {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return "";
        }
        int n = 0;
        while (n < string2.length() && separatorChars.indexOf(string2.charAt(n)) == -1) {
            ++n;
        }
        return string2.substring(0, n);
    }

    private static boolean removeKeyFromArray(String string, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                stringArray[n] = "";
                return true;
            }
            ++n;
        }
        return false;
    }

    static {
        try {
            masterPropURL = ClassLoader.getSystemResource(masterPropFile);
            if (masterPropURL != null) {
                masterProps.load(masterPropURL.openStream());
            }
            if ((userPropURL = ClassLoader.getSystemResource(userPropFile)) != null) {
                userProps.load(userPropURL.openStream());
            } else {
                userPropURL = masterPropURL != null ? new URL(masterPropURL, userPropFile) : new URL("file:_kbprops_user");
            }
            KBProperties.put(installDirProp, KBProperties.installDir());
        }
        catch (Exception exception) {
            System.err.println("An exception occurred while trying to load the KB properties.");
            exception.printStackTrace();
        }
        reportPropInfo = KBProperties.getBoolean(propInfo);
    }
}

