/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.oms;

import com.kb.client.KBException;
import com.kb.oms.OMSAPI;
import com.kb.oms.OMSAnswers;
import com.kb.oms.OMSException;
import com.kb.owl.Form;
import com.kb.owl.IVar;
import com.kb.owl.OWL;
import com.kb.owl.OWLParser;
import com.kb.owl.Symbol;
import com.kb.util.ArrayUtils;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class Sage {
    private static final String hasTypeName = "RootCtx.hasType";
    private static Hashtable instances;
    private static Object[] empty;
    OMSAPI omsapi;
    public static final String SupertypePred = "RootCtx.sup";
    public static final String SuperPredPred = "baseCtx.supPred";

    public static Sage getSage(OMSAPI oMSAPI) {
        Sage sage = (Sage)instances.get(oMSAPI);
        if (sage == null) {
            sage = new Sage(oMSAPI);
            instances.put(oMSAPI, sage);
        }
        return sage;
    }

    private Sage(OMSAPI oMSAPI) {
        this.omsapi = oMSAPI;
    }

    public OMSAPI getOMSAPI() {
        return this.omsapi;
    }

    public void close() {
        try {
            this.omsapi.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        instances.remove(this.omsapi);
    }

    public static void closeAll() {
        Enumeration enumeration = instances.elements();
        while (enumeration.hasMoreElements()) {
            Sage sage = (Sage)enumeration.nextElement();
            sage.close();
        }
        instances = new Hashtable();
    }

    public boolean isType(OWL oWL) {
        if (oWL == null) {
            return false;
        }
        OMSAnswers oMSAnswers = this.query("RootCtx.Type", oWL);
        return oMSAnswers != null && oMSAnswers.numAnswers() >= 1;
    }

    public boolean isPredicate(OWL oWL) {
        if (oWL == null) {
            return false;
        }
        OMSAnswers oMSAnswers = this.query("RootCtx.Relation", oWL);
        return oMSAnswers != null && oMSAnswers.numAnswers() >= 1;
    }

    public boolean isConstant(OWL oWL) {
        if (oWL == null) {
            return false;
        }
        return !this.isFormula(oWL);
    }

    public boolean isFormula(OWL oWL) {
        return this.getFIDStruct(oWL) != null;
    }

    public boolean isFormula(Form form) {
        boolean bl = false;
        try {
            bl = this.omsapi.getFID(form) != null || this.omsapi.getSentence(form) != null;
        }
        catch (KBException kBException) {
            bl = false;
        }
        return bl;
    }

    public Form getFIDStruct(Object object) {
        return null;
    }

    public Form getFIDStruct(String string) {
        if (string == null) {
            return null;
        }
        Object var2_2 = null;
        if (var2_2 == null) {
            try {
                StringReader stringReader = new StringReader(string);
                OWLParser oWLParser = new OWLParser(stringReader);
                OWL oWL = oWLParser.readExpr();
                stringReader.close();
                if (oWL instanceof Form) {
                    return this.getFIDStruct((Form)oWL);
                }
            }
            catch (Exception exception) {
                var2_2 = null;
            }
        }
        return var2_2;
    }

    public Form getFIDStruct(Form form) {
        if (form == null) {
            return null;
        }
        Form form2 = null;
        try {
            form2 = this.omsapi.getFID(form);
        }
        catch (KBException kBException) {
            form2 = null;
        }
        return form2;
    }

    public Form getFormula(Form form) {
        Form form2 = null;
        try {
            form2 = (Form)this.omsapi.getSentence(form);
        }
        catch (KBException kBException) {
            form2 = null;
        }
        return form2;
    }

    public String getArgType(OWL oWL, int n) {
        IVar iVar = new IVar("?Type");
        OMSAnswers oMSAnswers = this.query("RootCtx.argProp", oWL, new Symbol(n), iVar);
        if (oMSAnswers == null) {
            return null;
        }
        Object[] objectArray = oMSAnswers.answerSet(0);
        if (objectArray.length == 0) {
            return null;
        }
        return objectArray[0].toString();
    }

    public String[] getSubtypes(String string) {
        IVar iVar = new IVar("?Subtype");
        OMSAnswers oMSAnswers = this.query(SupertypePred, iVar, new Symbol(string));
        if (oMSAnswers == null) {
            return new String[0];
        }
        Object[] objectArray = oMSAnswers.answerSet(0);
        return this.toStringArray(objectArray);
    }

    public String[] getSupertypes(String string) {
        return this.toStringArray(this.functionQuery(new Symbol(string), SupertypePred));
    }

    public Object[] getSubs(OWL oWL, String string) {
        IVar iVar = new IVar("?Sub");
        OMSAnswers oMSAnswers = this.query(string, iVar, oWL);
        if (oMSAnswers == null) {
            return empty;
        }
        return oMSAnswers.answerSet(0);
    }

    public Object[] getSupers(OWL oWL, String string) {
        return this.functionQuery(oWL, string);
    }

    public String[] getExtent(OWL oWL) {
        IVar iVar = new IVar("?Member");
        OMSAnswers oMSAnswers = null;
        oMSAnswers = this.query(oWL, (OWL)iVar);
        if (oMSAnswers == null) {
            return new String[0];
        }
        Object[] objectArray = oMSAnswers.answerSet(0);
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = objectArray[n].toString();
            ++n;
        }
        return stringArray;
    }

    public String[] getRemarks(OWL oWL) {
        IVar iVar = new IVar("?Remark");
        IVar iVar2 = new IVar("?String");
        Form form = new Form("RootCtx.sharedRem", oWL, (OWL)iVar);
        Form form2 = new Form("RootCtx.rem", (OWL)iVar, (OWL)iVar2);
        Form form3 = new Form("and", (OWL)form, (OWL)form2);
        Object[] objectArray = this.query(form3).answerSet(1);
        Object[] objectArray2 = this.functionQuery(oWL, "RootCtx.rem");
        Object[] objectArray3 = ArrayUtils.add(objectArray2, objectArray);
        return this.toStringArray(objectArray3);
    }

    public Object[] getAntecedents(OWL oWL) {
        Object[] objectArray = this.functionQuery(oWL, "oms_ante_use");
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof Form) {
                try {
                    objectArray2[n] = this.omsapi.getSentence((Form)objectArray[n]);
                }
                catch (KBException kBException) {
                    objectArray2[n] = "(query failure)";
                }
            } else {
                System.out.println("Warning: Form expected (got " + objectArray[n] + ")");
            }
            ++n;
        }
        return objectArray2;
    }

    public Object[] getConclusions(OWL oWL) {
        Object[] objectArray = this.functionQuery(oWL, "oms_conc_use");
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof Form) {
                try {
                    objectArray2[n] = this.omsapi.getSentence((Form)objectArray[n]);
                }
                catch (KBException kBException) {
                    objectArray2[n] = "(query failure)";
                }
            } else {
                System.out.println("Warning: Form expected (got " + objectArray[n] + ")");
            }
            ++n;
        }
        return objectArray2;
    }

    public Object[] functionQuery(OWL oWL, String string) {
        IVar iVar = new IVar("?Second");
        OMSAnswers oMSAnswers = this.query(string, oWL, iVar);
        if (oMSAnswers == null) {
            return new String[0];
        }
        Object[] objectArray = oMSAnswers.answerSet(0);
        return objectArray;
    }

    public Object[] functionQuery(OWL oWL, String string, OWL oWL2) {
        IVar iVar = new IVar("?Third");
        OMSAnswers oMSAnswers = this.query(string, oWL, oWL2, iVar);
        if (oMSAnswers == null) {
            return new String[0];
        }
        Object[] objectArray = oMSAnswers.answerSet(0);
        return objectArray;
    }

    public String[] matchSymbols(String string) {
        String[] stringArray = null;
        try {
            stringArray = this.omsapi.matchSymbols(string);
        }
        catch (KBException kBException) {
            stringArray = null;
        }
        return stringArray;
    }

    private String[] toStringArray(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = objectArray[n].toString();
            ++n;
        }
        return stringArray;
    }

    private OMSAnswers query(OWL oWL, OWL oWL2) {
        return this.formatQuery(new Form(oWL, oWL2));
    }

    private OMSAnswers query(String string, OWL oWL) {
        return this.formatQuery(new Form(string, oWL));
    }

    private OMSAnswers query(String string, OWL oWL, OWL oWL2) {
        return this.formatQuery(new Form(string, oWL, oWL2));
    }

    private OMSAnswers query(String string, OWL oWL, OWL oWL2, OWL oWL3) {
        return this.formatQuery(new Form(string, oWL, oWL2, oWL3));
    }

    private OMSAnswers query(String string, OWL oWL, OWL oWL2, OWL oWL3, OWL oWL4) {
        return this.formatQuery(new Form(string, oWL, oWL2, oWL3, oWL4));
    }

    public OMSAnswers query(Form form) {
        return this.formatQuery(form);
    }

    private OMSAnswers formatQuery(Form form) {
        System.out.println("Sage asking: " + form);
        OMSAnswers oMSAnswers = null;
        try {
            oMSAnswers = this.omsapi.ask((OWL)form);
        }
        catch (OMSException oMSException) {
            oMSException.printStackTrace();
            oMSAnswers = null;
        }
        catch (KBException kBException) {
            kBException.printStackTrace();
            oMSAnswers = null;
        }
        return oMSAnswers;
    }

    static {
        empty = new Object[0];
        instances = new Hashtable();
    }
}

