/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.oms;

import com.kb.gui.oms.OsymHandler;
import com.kb.gui.oms.Sage;
import com.kb.owl.OWL;
import javax.swing.JEditorPane;

public class RemarkPane
extends JEditorPane {
    Sage sage;
    String text;

    public RemarkPane(Sage sage) {
        super("text/html", "");
        this.setSage(sage);
        this.addHyperlinkListener(new OsymHandler(this));
    }

    public void setConstant(OWL oWL) {
        if (oWL == null) {
            this.setText("");
        } else {
            String[] stringArray = this.sage.getRemarks(oWL);
            String string = oWL.toString();
            if (stringArray == null || stringArray.length == 0) {
                this.setText("No remarks found for <osym>" + string + "</osym>.");
            } else {
                this.setText(this.toSingleString(stringArray));
            }
        }
    }

    public void setSage(Sage sage) {
        this.sage = sage;
    }

    public void setText(String string) {
        this.text = string;
        StringBuffer stringBuffer = new StringBuffer("<font size=-1>\n");
        stringBuffer.append(OsymHandler.process(string));
        stringBuffer.append("</font>");
        super.setText(stringBuffer.toString());
    }

    public String getText() {
        return this.text;
    }

    private String toSingleString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append("<hr><font size=-1>");
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

