/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.oms;

import com.kb.gui.Util;
import com.kb.gui.event.SelectionEvent;
import com.kb.gui.event.SelectionListener;
import com.kb.gui.hier.HierView;
import com.kb.gui.oms.AttrTable;
import com.kb.gui.oms.Popup;
import com.kb.gui.oms.Sage;
import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;

public class PredView
extends JPanel
implements ListSelectionListener,
TableColumnModelListener {
    public static final String PFX = "omsgui.browser.predview.";
    public static final String leftProp = "omsgui.browser.predview.left";
    public static final int leftDef = 200;
    private static final String arityPred = "baseCtx.arity";
    private static final Object[][] predAttrs = new Object[][]{{AttrTable.TERM, "baseCtx.nameString", "baseCtx.arity", new Object[]{"baseCtx.argType", new Symbol(1)}, new Object[]{"baseCtx.argMode", new Symbol(1)}}, {AttrTable.TERM, "baseCtx.nameString", "baseCtx.arity", new Object[]{"baseCtx.argType", new Symbol(1)}, new Object[]{"baseCtx.argType", new Symbol(2)}, new Object[]{"baseCtx.argMode", new Symbol(1)}, new Object[]{"baseCtx.argMode", new Symbol(2)}}, {AttrTable.TERM, "baseCtx.nameString", "baseCtx.arity", new Object[]{"baseCtx.argType", new Symbol(1)}, new Object[]{"baseCtx.argType", new Symbol(2)}, new Object[]{"baseCtx.argType", new Symbol(3)}, new Object[]{"baseCtx.argMode", new Symbol(1)}, new Object[]{"baseCtx.argMode", new Symbol(2)}, new Object[]{"baseCtx.argMode", new Symbol(3)}}};
    Sage sage;
    OWL pred;
    boolean painted;
    Vector selListeners;
    AttrTable attrTable;
    JLabel sigLabel;
    HierView hierView;
    JSplitPane splitPane;

    public PredView(Sage sage) {
        this.sage = sage;
        this.painted = false;
        this.initGUI();
        this.selListeners = new Vector();
    }

    private void initGUI() {
        this.attrTable = new AttrTable(this.sage);
        this.attrTable.setCellSelectionEnabled(true);
        this.attrTable.setSelectionMode(0);
        this.attrTable.getSelectionModel().addListSelectionListener(this);
        this.attrTable.getColumnModel().addColumnModelListener(this);
        Popup popup = new Popup((Component)this.attrTable, this.sage);
        popup.add(0);
        popup.add(1);
        popup.add(2);
        this.sigLabel = new JLabel();
        Util.adjustFont(this.sigLabel, 1, 2);
        this.sigLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("North", this.sigLabel);
        jPanel.add("Center", this.attrTable);
        this.hierView = new HierView(this.sage, "baseCtx.supPred", null);
        this.splitPane = new JSplitPane(0, jPanel, this.hierView);
        this.setLayout(new BorderLayout());
        this.add("Center", this.splitPane);
    }

    public void setPred(OWL oWL) {
        this.pred = oWL;
        this.attrTable.setTerm(this.pred);
        this.attrTable.setAttrs(predAttrs[this.arityOf(this.pred) - 1]);
        this.sigLabel.setText(this.signatureString(oWL));
        this.hierView.setRoot(oWL);
    }

    public OWL getPred() {
        return this.pred;
    }

    private int arityOf(OWL oWL) {
        Object[] objectArray = this.sage.functionQuery(oWL, arityPred);
        int n = 1;
        try {
            n = Integer.decode(objectArray[0].toString());
        }
        catch (NumberFormatException numberFormatException) {
            n = 1;
        }
        return n;
    }

    private String signatureString(OWL oWL) {
        StringBuffer stringBuffer = new StringBuffer(oWL.toString());
        stringBuffer.append(": ");
        int n = 1;
        while (n <= this.arityOf(oWL)) {
            String string;
            if (n > 1) {
                stringBuffer.append(" X ");
            }
            if ((string = this.sage.getArgType(oWL, n)) == null) {
                string = "??";
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.selectionChanged(listSelectionEvent);
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.selectionChanged(listSelectionEvent);
    }

    private void selectionChanged(ListSelectionEvent listSelectionEvent) {
        this.notifyListeners(new SelectionEvent(this.attrTable, this.attrTable.getValueAt(this.attrTable.getSelectedRow(), this.attrTable.getSelectedColumn())));
    }

    public void addChildSelectionListener(SelectionListener selectionListener) {
        this.selListeners.add(selectionListener);
    }

    public void addChildFocusListener(FocusListener focusListener) {
        this.addFocusListener(focusListener);
        this.attrTable.addFocusListener(focusListener);
    }

    private void notifyListeners(SelectionEvent selectionEvent) {
        Enumeration enumeration = this.selListeners.elements();
        while (enumeration.hasMoreElements()) {
            SelectionListener selectionListener = (SelectionListener)enumeration.nextElement();
            selectionListener.selectionChanged(selectionEvent);
        }
    }
}

