/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.oms;

import com.kb.gui.Util;
import com.kb.gui.oms.Sage;
import com.kb.gui.oms.ViewAction;
import com.kb.gui.oms.ViewNewWinAction;
import com.kb.oms.OMSAPI;
import com.kb.owl.OWL;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;

public class Popup
extends JPopupMenu
implements MouseListener {
    public static final int VIEW = 0;
    public static final int VIEWNEW = 1;
    public static final int DELETE = 2;
    public static final int SEPARATOR = 127;
    Component target;
    Sage sage;
    Vector actions;

    public Popup(Component component, OMSAPI oMSAPI) {
        this(component, Sage.getSage(oMSAPI));
    }

    public Popup(Component component, Sage sage) {
        if (!(component instanceof JTable || component instanceof JTextComponent || component instanceof JList || component instanceof JTree)) {
            throw new IllegalArgumentException("component must be instance of JTable, JTextComponent, JList, or JTree");
        }
        this.target = component;
        this.sage = sage;
        component.addMouseListener(this);
        this.actions = new Vector();
    }

    public void add(int n) {
        this.actions.addElement(new Integer(n));
    }

    public JMenuItem add(Action action) {
        this.actions.addElement(action);
        return null;
    }

    public void addSeparator() {
        this.actions.addElement(new Integer(127));
    }

    public Component getTarget() {
        return this.target;
    }

    public Sage getSage() {
        return this.sage;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        this.selectItemAtPoint(mouseEvent.getPoint());
        this.showPopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private void showPopup(Component component, int n, int n2) {
        this.removeAll();
        Object object = Util.getSelectedItem(this.target);
        Enumeration enumeration = this.actions.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof Integer) {
                this.addStdAction((int)((Integer)e), object);
                continue;
            }
            if (!(e instanceof Action)) continue;
            this.addToPopup(' ', (Action)e);
        }
        this.show(component, n, n2);
    }

    private void addStdAction(int n, Object object) {
        if (!(object instanceof OWL)) {
            throw new ClassCastException("addStdAction: Unexpected " + object.getClass());
        }
        this.addStdAction(n, (OWL)object);
    }

    private void addStdAction(int n, OWL oWL) {
        if (n == 0) {
            this.addToPopup('E', new ViewAction(this.target, oWL, this.sage));
        } else if (n == 1) {
            this.addToPopup('W', new ViewNewWinAction(this.target, oWL, this.sage));
        } else if (n == 127 && oWL != null) {
            super.addSeparator();
        }
    }

    private void addToPopup(char c, Action action) {
        JMenuItem jMenuItem = super.add(action);
    }

    private void selectItemAtPoint(Point point) {
        if (this.target instanceof JTable) {
            JTable jTable = (JTable)this.target;
            int n = jTable.rowAtPoint(point);
            int n2 = jTable.columnAtPoint(point);
            if (n != -1 && n2 != -1) {
                jTable.setRowSelectionInterval(n, n);
                jTable.setColumnSelectionInterval(n2, n2);
            }
        } else if (!(this.target instanceof JTextComponent)) {
            JTree jTree;
            TreePath treePath;
            if (this.target instanceof JList) {
                JList jList = (JList)this.target;
                jList.setSelectedIndex(jList.locationToIndex(point));
            } else if (this.target instanceof JTree && (treePath = (jTree = (JTree)this.target).getPathForLocation((int)point.getX(), (int)point.getY())) != null) {
                jTree.setSelectionPath(treePath);
            }
        }
    }
}

