/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.oms;

import com.kb.kbddutil.KBProperties;
import com.kb.oms.KFLFile;
import com.kb.oms.LoadWindow;
import com.kb.util.gui.FileFilterExt;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class OpenKFLAction
extends AbstractAction {
    static File curDirectory = new File(KBProperties.get("omsgui.load.kflDirectory", ""));
    final LoadWindow loadWindow;
    final JFileChooser chooser;

    public OpenKFLAction() {
        this((LoadWindow)null);
    }

    public OpenKFLAction(LoadWindow loadWindow) {
        this(loadWindow, "Open KFL file...");
    }

    public OpenKFLAction(LoadWindow loadWindow, String string) {
        super(string);
        if (loadWindow == null) {
            throw new IllegalArgumentException("loadWindow must be non-null");
        }
        this.loadWindow = loadWindow;
        this.chooser = new JFileChooser();
        this.chooser.addChoosableFileFilter(new FileFilterExt(new String[]{"kfl"}, "KFL files"));
    }

    public static void setCurrentDirectory(File file) {
        curDirectory = file;
    }

    public static void setCurrentDirectory(String string) {
        curDirectory = new File(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.chooser.setCurrentDirectory(curDirectory);
        int n = this.chooser.showOpenDialog((Component)this.loadWindow);
        if (n == 0) {
            curDirectory = this.chooser.getCurrentDirectory();
            String string = curDirectory.getAbsolutePath();
            string = string.replace('\\', '/');
            KBProperties.put("omsgui.load.kflDirectory", string);
            KBProperties.save(new String[]{"omsgui.load.kflDirectory"});
            this.loadWindow.openKFLFile(new KFLFile(this.chooser.getSelectedFile()));
        }
    }
}

