/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.oms;

import com.kb.gui.ObjChooser;
import com.kb.gui.Util;
import com.kb.gui.event.SelectionEvent;
import com.kb.gui.event.SelectionListener;
import com.kb.gui.oms.AboutAction;
import com.kb.gui.oms.AppWindow;
import com.kb.gui.oms.ArchiveAction;
import com.kb.gui.oms.AskWinAction;
import com.kb.gui.oms.CloseAppWinAction;
import com.kb.gui.oms.ExitOMSAction;
import com.kb.gui.oms.InfoPane;
import com.kb.gui.oms.LoadWinAction;
import com.kb.gui.oms.RestoreAction;
import com.kb.gui.oms.Sage;
import com.kb.gui.oms.ViewAction;
import com.kb.gui.oms.ViewNewWinAction;
import com.kb.oms.OMSAPI;
import com.kb.owl.Form;
import com.kb.owl.OWL;
import com.kb.owl.Symbol;
import com.kb.owl.SyntaxError;
import com.ow.util.OWUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class OMSBrowser
extends AppWindow
implements ActionListener,
SelectionListener,
FocusListener {
    public static final String title = "OMS Browser";
    public static final String PFX = "omsgui.browser.";
    Sage sage;
    Object curSelection;
    JMenu constMenu;
    JButton findButton;
    JTextField constField;
    InfoPane infoPane;

    public String getWindowName() {
        return "browser";
    }

    public int getWinXDef() {
        return 0;
    }

    public int getWinYDef() {
        return 0;
    }

    public int getWinWidthDef() {
        return 500;
    }

    public int getWinHeightDef() {
        return 500;
    }

    public static void main(String[] stringArray) {
        AppWindow.init();
        OMSAPI oMSAPI = null;
        try {
            oMSAPI = new OMSAPI();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.exit(1);
        }
        OMSBrowser oMSBrowser = new OMSBrowser(oMSAPI, true);
        oMSBrowser.show();
    }

    public OMSBrowser(AppWindow appWindow, OWL oWL) {
        this(appWindow.getOMSAPI(), oWL, appWindow.getExitOnLastClosed());
    }

    public OMSBrowser(AppWindow appWindow, String string) {
        this(appWindow.getOMSAPI(), string, appWindow.getExitOnLastClosed());
    }

    public OMSBrowser(OMSAPI oMSAPI, String string) {
        this(oMSAPI, string, false);
    }

    public OMSBrowser(OMSAPI oMSAPI) {
        this(oMSAPI, (OWL)null, false);
    }

    public OMSBrowser(OMSAPI oMSAPI, OWL oWL) {
        this(oMSAPI, oWL, false);
    }

    public OMSBrowser(OMSAPI oMSAPI, boolean bl) {
        this(oMSAPI, (OWL)null, bl);
    }

    public OMSBrowser(OMSAPI oMSAPI, OWL oWL, boolean bl) {
        super(title, oMSAPI, bl);
        this.sage = Sage.getSage(oMSAPI);
        this.initGUI();
        this.positionFrame();
        this.setConstant(oWL);
    }

    public OMSBrowser(OMSAPI oMSAPI, String string, boolean bl) {
        super(title, oMSAPI, bl);
        this.sage = Sage.getSage(oMSAPI);
        this.initGUI();
        this.positionFrame();
        this.setConstant(string);
    }

    private void initGUI() {
        this.initMenuBar();
        this.initPane();
        this.pack();
        this.setDisposeOnClose(true);
    }

    private void initMenuBar() {
        JMenu jMenu = Util.createJMenu('G', "General");
        Util.createMI(jMenu, "cN", new ViewNewWinAction((Component)this, this.sage, "New window"));
        Util.createMI(jMenu, "aS", new AskWinAction(this));
        Util.createMI(jMenu, "aL", new LoadWinAction(this));
        Util.createMI(jMenu, "aX", 'c', new CloseAppWinAction(this));
        Util.createMI(jMenu, "caX", new ExitOMSAction());
        this.constMenu = Util.createJMenu('C', "Constant");
        Util.createMI(this.constMenu, "cS", new ViewAction(this, null, this.sage));
        Util.createMI(this.constMenu, "cW", new ViewNewWinAction((Component)this, null, this.sage));
        JMenu jMenu2 = Util.createJMenu('A', "Admin");
        Util.createMI(jMenu2, "caA", new ArchiveAction(this, this.omsapi));
        Util.createMI(jMenu2, "caR", new RestoreAction(this, this.omsapi));
        Util.createMI(jMenu2, "caB", new AboutAction(this));
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(this.constMenu);
        jMenuBar.add(jMenu2);
        this.constMenu.setEnabled(false);
        this.setJMenuBar(jMenuBar);
    }

    private JMenuItem createMI(JMenu jMenu, String string, char c, String string2) {
        return Util.createMI(jMenu, this, string, c, string2);
    }

    private JMenuItem createMI(JMenu jMenu, String string, String string2) {
        return Util.createMI(jMenu, this, string, string2);
    }

    private void initPane() {
        this.constField = new JTextField(20);
        this.constField.addActionListener(this);
        this.constField.addFocusListener(this);
        this.findButton = new JButton("Search");
        this.findButton.addActionListener(this);
        this.findButton.addFocusListener(this);
        JLabel jLabel = this.createMnemLabel("Constant: ", "aO", this.constField);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("West", jLabel);
        jPanel.add("East", this.findButton);
        jPanel.add("Center", this.constField);
        this.infoPane = new InfoPane(this.sage);
        this.infoPane.addChildSelectionListener(this);
        this.infoPane.addChildFocusListener(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("North", jPanel);
        container.add("Center", this.infoPane);
    }

    private JLabel createMnemLabel(String string, String string2, Component component) {
        return Util.createMnemLabel(string, string2, component);
    }

    public Object getSelection() {
        return this.curSelection;
    }

    public void setConstant(String string) {
        this.constField.setText(string);
        this.setConstant0(string);
    }

    public void setConstant(OWL oWL) {
        this.constField.setText(oWL == null ? null : oWL.toString());
        this.setConstant0(oWL);
    }

    private void setConstant0(OWL oWL) {
        OWL oWL2 = oWL instanceof Form ? this.sage.getFIDStruct((Form)oWL) : oWL;
        this.infoPane.setConstant(oWL2);
        String string = title;
        if (oWL != null) {
            string = string + oWL.toString();
        }
        this.setTitle(title);
    }

    private void setConstant0(String string) {
        OWL oWL = this.sage.getFIDStruct(string);
        if (oWL == null) {
            try {
                oWL = OWUtil.toOWL(string);
            }
            catch (SyntaxError syntaxError) {
                oWL = null;
            }
        }
        this.infoPane.setConstant(oWL);
        String string2 = title;
        if (string != null) {
            string2 = string2 + string;
        }
        this.setTitle(title);
    }

    public void saveWindowMetrics() {
        super.saveWindowMetrics();
        this.infoPane.saveWindowProperties();
    }

    private void findConst() {
        String string = this.constField.getText();
        if (string.startsWith("%") || string.endsWith("%")) {
            this.findConstMatch();
        } else {
            this.setConstant0(string);
        }
    }

    private void findConstMatch() {
        String[] stringArray = this.sage.matchSymbols(this.constField.getText());
        if (stringArray.length > 1) {
            String string = this.showObjChooser(stringArray);
            if (string != null) {
                this.setConstant0(new Symbol(string));
            }
        } else if (stringArray.length == 1) {
            this.setConstant0(new Symbol(stringArray[0]));
        } else {
            this.setConstant0((OWL)null);
        }
    }

    private String showObjChooser(String[] stringArray) {
        String string = (String)ObjChooser.showObjChooser(this, "Select a constant", "Which constant do you want?", true, stringArray);
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.findConst();
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        Component component = (Component)selectionEvent.getSource();
        if (!component.hasFocus()) {
            return;
        }
        this.curSelection = selectionEvent.getSelection();
        System.out.println("selection: -" + this.curSelection + "-");
        this.refreshConstMenuEnable();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = SwingUtilities.findFocusOwner(this);
        if (component == this.constField || component == this.findButton) {
            this.curSelection = null;
            this.constMenu.setEnabled(false);
        } else {
            this.curSelection = Util.getSelectedItem(component);
            if (this.curSelection == null) {
                if (component == null) {
                    System.out.println("no focus");
                } else {
                    System.out.println("focus on a " + component.getClass().getName());
                }
            }
        }
        System.out.println("selection: -" + this.curSelection + "-");
        this.refreshConstMenuEnable();
    }

    private void refreshConstMenuEnable() {
        String string;
        boolean bl = true;
        if (this.curSelection == null) {
            bl = false;
        }
        if (this.curSelection instanceof String && (string = (String)this.curSelection).length() == 0) {
            bl = false;
        }
        this.constMenu.setEnabled(bl);
    }
}

