/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.oms;

import com.kb.gui.FocusBorder;
import com.kb.gui.event.SelectionEvent;
import com.kb.gui.event.SelectionListener;
import com.kb.gui.oms.ConstView;
import com.kb.gui.oms.ExtentView;
import com.kb.gui.oms.FormulaView;
import com.kb.gui.oms.Popup;
import com.kb.gui.oms.PredView;
import com.kb.gui.oms.RemarkPane;
import com.kb.gui.oms.Sage;
import com.kb.gui.oms.TypeView;
import com.kb.kbddutil.KBProperties;
import com.kb.owl.OWL;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class InfoPane
extends JPanel
implements CaretListener {
    public static final String PFX = "omsgui.browser.";
    public static final String leftProp = "omsgui.browser.left";
    public static final int leftDef = 200;
    private static final String typeStr = "Type";
    private static final String predStr = "Predicate";
    private static final String extentStr = "extent";
    private static final String constStr = "constant";
    private static final String formulaStr = "formula";
    private static int typeIdx;
    private static int predIdx;
    private static int extentIdx;
    private static int constIdx;
    private static int formulaIdx;
    private static final String filledStr = "Filled";
    private static final String clearStr = "clear";
    private static final String nullText = "Enter a constant.";
    Sage sage;
    Vector selListeners;
    boolean painted;
    TypeView typeView;
    PredView predView;
    ExtentView extentView;
    ConstView constView;
    FormulaView formulaView;
    JTabbedPane tabPane;
    JPanel clearPane;
    JLabel clearLabel;
    JSplitPane filledPane;
    CardLayout cardLayout;
    RemarkPane remarkPane;

    public InfoPane(Sage sage) {
        this.sage = sage;
        this.selListeners = new Vector();
        this.painted = false;
        this.clearPane = this.makeClearPane();
        this.tabPane = new JTabbedPane();
        this.typeView = new TypeView(sage);
        this.predView = new PredView(sage);
        this.extentView = new ExtentView(sage);
        this.constView = new ConstView(sage);
        this.formulaView = new FormulaView(sage);
        this.tabPane.add(typeStr, this.typeView);
        this.tabPane.add(predStr, this.predView);
        this.tabPane.add(extentStr, this.extentView);
        this.tabPane.add(constStr, this.constView);
        this.tabPane.add(formulaStr, this.formulaView);
        typeIdx = this.tabPane.indexOfComponent(this.typeView);
        predIdx = this.tabPane.indexOfComponent(this.predView);
        extentIdx = this.tabPane.indexOfComponent(this.extentView);
        constIdx = this.tabPane.indexOfComponent(this.constView);
        formulaIdx = this.tabPane.indexOfComponent(this.formulaView);
        this.remarkPane = new RemarkPane(sage);
        JScrollPane jScrollPane = new JScrollPane(this.remarkPane);
        new FocusBorder(jScrollPane, this.remarkPane);
        Popup popup = new Popup((Component)this.remarkPane, sage);
        popup.add(0);
        popup.add(1);
        this.remarkPane.addCaretListener(this);
        this.remarkPane.setEditable(false);
        this.filledPane = new JSplitPane(1, this.tabPane, jScrollPane);
        this.filledPane.setDividerLocation(KBProperties.get_int(leftProp, 200));
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.add((Component)this.clearPane, clearStr);
        this.add((Component)this.filledPane, filledStr);
        this.cardLayout.show(this, clearStr);
    }

    private JPanel makeClearPane() {
        JPanel jPanel = new JPanel();
        this.clearLabel = new JLabel(nullText);
        jPanel.add(this.clearLabel);
        return jPanel;
    }

    private void showType(OWL oWL, boolean bl) {
        this.tabPane.setEnabledAt(typeIdx, bl);
        if (bl) {
            this.typeView.setType(oWL);
        }
    }

    private void showPred(OWL oWL, boolean bl) {
        this.tabPane.setEnabledAt(predIdx, bl);
        if (bl) {
            this.predView.setPred(oWL);
        }
    }

    private void showExtent(OWL oWL, boolean bl) {
        this.tabPane.setEnabledAt(extentIdx, bl);
        if (bl) {
            this.extentView.setPred(oWL);
        }
    }

    private void showConst(OWL oWL, boolean bl) {
        this.tabPane.setEnabledAt(constIdx, bl);
        if (bl) {
            this.constView.setConstant(oWL);
        }
    }

    private void showFormula(OWL oWL, boolean bl) {
        this.tabPane.setEnabledAt(formulaIdx, bl);
        if (bl) {
            this.formulaView.setFormula(oWL);
        }
    }

    private void showEnabledComponent(OWL oWL) {
        if (this.tabPane.isEnabledAt(this.tabPane.getSelectedIndex())) {
            this.cardLayout.show(this, filledStr);
            return;
        }
        int n = 0;
        while (n < this.tabPane.getTabCount() && !this.tabPane.isEnabledAt(n)) {
            ++n;
        }
        if (n >= this.tabPane.getTabCount()) {
            this.cardLayout.show(this, clearStr);
            if (oWL == null) {
                this.clearLabel.setText(nullText);
            } else {
                this.clearLabel.setText("Couldn't find '" + oWL.toString() + "' in the server.");
            }
        } else {
            this.tabPane.setSelectedIndex(n);
            this.cardLayout.show(this, filledStr);
        }
    }

    public void setConstant(OWL oWL) {
        this.showType(oWL, this.sage.isType(oWL));
        this.showPred(oWL, this.sage.isPredicate(oWL));
        this.showExtent(oWL, this.sage.isType(oWL));
        this.showConst(oWL, this.sage.isConstant(oWL));
        this.showFormula(oWL, this.sage.isFormula(oWL));
        this.showEnabledComponent(oWL);
        this.remarkPane.setConstant(oWL);
    }

    protected void saveWindowProperties() {
        this.saveProperties();
    }

    protected void saveProperties() {
        if (!this.painted) {
            return;
        }
        KBProperties.put(leftProp, this.filledPane.getDividerLocation());
        KBProperties.saveFamily(leftProp);
    }

    public void paint(Graphics graphics) {
        this.painted = true;
        super.paint(graphics);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.notifyListeners(new SelectionEvent(this.remarkPane, this.remarkPane.getSelectedText()));
    }

    public void addChildSelectionListener(SelectionListener selectionListener) {
        this.typeView.addChildSelectionListener(selectionListener);
        this.predView.addChildSelectionListener(selectionListener);
        this.constView.addChildSelectionListener(selectionListener);
        this.selListeners.add(selectionListener);
    }

    public void addChildFocusListener(FocusListener focusListener) {
        this.tabPane.addFocusListener(focusListener);
        this.typeView.addChildFocusListener(focusListener);
        this.predView.addChildFocusListener(focusListener);
        this.constView.addChildFocusListener(focusListener);
        this.remarkPane.addFocusListener(focusListener);
    }

    private void notifyListeners(SelectionEvent selectionEvent) {
        Enumeration enumeration = this.selListeners.elements();
        while (enumeration.hasMoreElements()) {
            SelectionListener selectionListener = (SelectionListener)enumeration.nextElement();
            selectionListener.selectionChanged(selectionEvent);
        }
    }
}

