/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.oms;

import com.kb.gui.Util;
import com.kb.gui.oms.AttrTable;
import com.kb.gui.oms.Popup;
import com.kb.gui.oms.Sage;
import com.kb.owl.Form;
import com.kb.owl.OWL;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FormulaView
extends JPanel {
    private static final Object[] formulaAttrs = new Object[]{AttrTable.TERM, "inCtx", "constraint", "def"};
    private static final String emptyStr = "";
    Sage sage;
    JLabel topLabel;
    AttrTable attrTable;

    public FormulaView(Sage sage) {
        super(new BorderLayout());
        this.sage = sage;
        this.initGUI();
    }

    private void initGUI() {
        this.topLabel = new JLabel(emptyStr);
        Util.adjustFont(this.topLabel, 1, 2);
        this.topLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.attrTable = new AttrTable(this.sage);
        this.attrTable.setCellSelectionEnabled(true);
        this.attrTable.setSelectionMode(0);
        Popup popup = new Popup((Component)this.attrTable, this.sage);
        popup.add(0);
        popup.add(1);
        popup.add(2);
        this.add("North", this.topLabel);
        this.add("Center", new JScrollPane(this.attrTable));
    }

    public void setFormula(OWL oWL) {
        Form form = this.sage.getFIDStruct(oWL);
        if (form == null) {
            this.topLabel.setText(emptyStr);
            this.topLabel.setToolTipText(emptyStr);
        } else {
            Form form2 = this.sage.getFormula(form);
            String string = "(no parse found)";
            if (form2 != null) {
                string = form2.toString();
            }
            String string2 = form2 == null ? emptyStr : form.toString() + ": " + string;
            this.topLabel.setText(string2);
            this.topLabel.setToolTipText(string2);
        }
        this.attrTable.setTerm(form);
        this.attrTable.setAttrs(formulaAttrs);
    }
}

