/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.oms;

import com.kb.gui.FocusBorder;
import com.kb.gui.Util;
import com.kb.gui.event.SelectionEvent;
import com.kb.gui.event.SelectionListener;
import com.kb.gui.oms.Popup;
import com.kb.gui.oms.Sage;
import com.kb.owl.OWL;
import com.ow.gui.Typematic;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExtentView
extends JPanel
implements ListSelectionListener,
ActionListener {
    private static Vector empty = new Vector();
    JList objList;
    JLabel listLabel;
    JButton extentButton;
    OWL predicate;
    Vector objVector;
    Sage sage;
    Vector selListeners;

    public ExtentView(Sage sage) {
        this(sage, null);
    }

    public ExtentView(Sage sage, OWL oWL) {
        this.predicate = oWL;
        this.sage = sage;
        this.objVector = new Vector();
        this.initGUI();
        this.getList();
        this.selListeners = new Vector();
    }

    private void initGUI() {
        this.listLabel = new JLabel("");
        this.listLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.extentButton = Util.createSmallButton("retrieve");
        this.extentButton.addActionListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", this.listLabel);
        jPanel.add("East", this.extentButton);
        this.objList = new JList(this.objVector);
        this.objList.setSelectionMode(0);
        this.objList.addListSelectionListener(this);
        Popup popup = new Popup((Component)this.objList, this.sage);
        popup.add(0);
        popup.add(1);
        popup.add(2);
        new Typematic(this.objList);
        JScrollPane jScrollPane = new JScrollPane(this.objList);
        new FocusBorder(jScrollPane, this.objList);
        this.setLayout(new BorderLayout());
        this.add("North", jPanel);
        this.add("Center", jScrollPane);
    }

    public void setPred(OWL oWL) {
        this.predicate = oWL == null ? null : oWL;
        this.listLabel.setText("<retrieve> or Alt+E to get extent");
        this.objList.setListData(empty);
        this.objList.revalidate();
    }

    private void getList() {
        this.objVector = this.askExtent();
        if (this.predicate == null) {
            this.listLabel.setText("<retrieve> or Alt+E to get extent");
        } else {
            this.listLabel.setText("Found " + this.objVector.size() + " tuple(s) for '" + this.predicate.toString() + "':");
        }
        this.objList.setListData(this.objVector);
        this.objList.revalidate();
    }

    private Vector askExtent() {
        if (this.predicate == null) {
            return new Vector();
        }
        Object[] objectArray = null;
        try {
            objectArray = this.sage.getExtent(this.predicate);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        Arrays.sort(objectArray);
        Object[] objectArray2 = Util.removeDupes(objectArray);
        Vector<Object> vector = new Vector<Object>();
        if (objectArray2 != null) {
            int n = 0;
            while (n < objectArray2.length) {
                vector.addElement(objectArray2[n]);
                ++n;
            }
        }
        return vector;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.getList();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e = this.objList.getSelectedValue();
        this.notifyListeners(new SelectionEvent(this.objList, e));
    }

    public void addChildSelectionListener(SelectionListener selectionListener) {
        this.selListeners.add(selectionListener);
    }

    public void addChildFocusListener(FocusListener focusListener) {
        this.objList.addFocusListener(focusListener);
    }

    private void notifyListeners(SelectionEvent selectionEvent) {
        Enumeration enumeration = this.selListeners.elements();
        while (enumeration.hasMoreElements()) {
            SelectionListener selectionListener = (SelectionListener)enumeration.nextElement();
            selectionListener.selectionChanged(selectionEvent);
        }
    }
}

