/*
 * Decompiled with CFR 0.152.
 */
package com.kb.gui.oms;

import com.kb.gui.Util;
import com.kb.gui.event.SelectionEvent;
import com.kb.gui.event.SelectionListener;
import com.kb.gui.oms.InputImplAction;
import com.kb.gui.oms.Popup;
import com.kb.gui.oms.Sage;
import com.kb.owl.OWL;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;

public class ConstView
extends JSplitPane
implements CaretListener {
    public static final int INPUT = 1;
    public static final int IMPLEMENTATION = 2;
    Sage sage;
    OWL constant;
    Vector selListeners;
    Object[] antes;
    Object[] concs;
    int anteMode;
    int concMode;
    JLabel anteLabel;
    JLabel concLabel;
    JTextArea anteArea;
    JTextArea concArea;

    public ConstView(Sage sage) {
        super(0);
        this.sage = sage;
        this.initGUI();
        this.concMode = 1;
        this.anteMode = 1;
        this.selListeners = new Vector();
    }

    private void initGUI() {
        this.anteLabel = new JLabel("No constant");
        this.anteArea = this.initTextArea();
        this.concLabel = new JLabel("No constant");
        this.concArea = this.initTextArea();
        this.setTopComponent(this.initPane(this.anteLabel, this.anteArea));
        this.setBottomComponent(this.initPane(this.concLabel, this.concArea));
    }

    private JTextArea initTextArea() {
        JTextArea jTextArea = new JTextArea();
        Popup popup = new Popup((Component)jTextArea, this.sage);
        popup.add(0);
        popup.add(1);
        popup.addSeparator();
        popup.add(new InputImplAction(jTextArea, this, 1));
        popup.add(new InputImplAction(jTextArea, this, 2));
        jTextArea.addCaretListener(this);
        jTextArea.setEditable(false);
        return jTextArea;
    }

    private JPanel initPane(JLabel jLabel, JTextArea jTextArea) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("North", jLabel);
        jPanel.add("Center", new JScrollPane(jTextArea));
        return jPanel;
    }

    public void setConstant(OWL oWL) {
        this.constant = oWL;
        this.getSentences();
    }

    public int getViewMode(Component component) {
        if (component == this.anteArea) {
            return this.anteMode;
        }
        if (component == this.concArea) {
            return this.concMode;
        }
        return 1;
    }

    public void toggleViewMode(Component component) {
        if (component != this.anteArea && component != this.concArea) {
            return;
        }
        if (this.getViewMode(component) == 1) {
            this.setImplementationMode(component);
        } else {
            this.setInputMode(component);
        }
    }

    public void setInputMode(Component component) {
        if (component == this.anteArea) {
            if (this.anteMode == 1) {
                return;
            }
            this.anteMode = 1;
            this.refreshArea(this.anteArea, this.antes, this.anteMode);
        } else if (component == this.concArea) {
            if (this.concMode == 1) {
                return;
            }
            this.concMode = 1;
            this.refreshArea(this.concArea, this.concs, this.concMode);
        }
    }

    public void setImplementationMode(Component component) {
        if (component == this.anteArea) {
            if (this.anteMode == 2) {
                return;
            }
            this.anteMode = 2;
            this.refreshArea(this.anteArea, this.antes, this.anteMode);
        } else if (component == this.concArea) {
            if (this.concMode == 2) {
                return;
            }
            this.concMode = 2;
            this.refreshArea(this.concArea, this.concs, this.concMode);
        }
    }

    private void refreshArea(JTextArea jTextArea, Object[] objectArray, int n) {
        Object[] objectArray2 = objectArray;
        jTextArea.setText(this.arrayToText(Util.removeDupes(objectArray2)));
    }

    private void getSentences() {
        this.antes = this.sage.getAntecedents(this.constant);
        this.anteLabel.setText(this.antes.length + " sentence(s) containing " + this.constant + " in an antecedent");
        this.refreshArea(this.anteArea, this.antes, this.anteMode);
        this.concs = this.sage.getConclusions(this.constant);
        this.concLabel.setText(this.concs.length + " sentence(s) containing " + this.constant + " in a conclusion");
        this.refreshArea(this.concArea, this.concs, this.concMode);
    }

    private String arrayToText(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            stringBuffer.append(objectArray[n] == null ? "??" : objectArray[n].toString());
            if (n + 1 != objectArray.length) {
                stringBuffer.append('\n');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        JTextComponent jTextComponent = (JTextComponent)caretEvent.getSource();
        if (jTextComponent == this.anteArea) {
            this.notifyListeners(new SelectionEvent(this.anteArea, this.anteArea.getSelectedText()));
        } else if (jTextComponent == this.concArea) {
            this.notifyListeners(new SelectionEvent(this.concArea, this.concArea.getSelectedText()));
        }
    }

    public void addChildSelectionListener(SelectionListener selectionListener) {
        this.selListeners.add(selectionListener);
    }

    public void addChildFocusListener(FocusListener focusListener) {
        this.anteArea.addFocusListener(focusListener);
        this.concArea.addFocusListener(focusListener);
    }

    private void notifyListeners(SelectionEvent selectionEvent) {
        Enumeration enumeration = this.selListeners.elements();
        while (enumeration.hasMoreElements()) {
            SelectionListener selectionListener = (SelectionListener)enumeration.nextElement();
            selectionListener.selectionChanged(selectionEvent);
        }
    }
}

